/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.db;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.util.db.IModelCopier;
import to.etc.domui.util.db.QPersistentObjectState;
import to.etc.util.StringTool;
import to.etc.webapp.query.QDataContext;

public abstract class QBasicModelCopier
implements IModelCopier {
    @Override
    public abstract <T> boolean isUnloadedParent(T var1, PropertyMetaModel<?> var2) throws Exception;

    @Override
    public abstract <T> boolean isUnloadedChildList(T var1, PropertyMetaModel<?> var2) throws Exception;

    protected abstract QPersistentObjectState getObjectState(QDataContext var1, Object var2) throws Exception;

    protected abstract QPersistentObjectState getObjectState(QDataContext var1, Class<?> var2, Object var3) throws Exception;

    public static void assertPrivateContext(QDataContext dc) {
    }

    private static String identify(Object t) {
        return MetaManager.identify(t);
    }

    protected void save(CopyInfo ci, Object instance) throws Exception {
        ci.getTargetDC().save(instance);
    }

    @Override
    public <T> T copyInstanceShallow(QDataContext dc, T source) throws Exception {
        Object copy;
        if (source == null) {
            return null;
        }
        QBasicModelCopier.assertPrivateContext(dc);
        ClassMetaModel cmm = MetaManager.findClassMeta(source.getClass());
        if (!cmm.isPersistentClass()) {
            throw new IllegalStateException("The class " + cmm + " is not a persistent class");
        }
        Class<?> clz = cmm.getActualClass();
        PropertyMetaModel<?> primaryKey = cmm.getPrimaryKey();
        if (null == primaryKey) {
            throw new IllegalStateException(cmm + ": primary key undefined");
        }
        Object pk = primaryKey.getValue(source);
        if (pk == null) {
            copy = clz.newInstance();
        } else {
            copy = dc.find(clz, pk);
            if (copy == null) {
                throw new IllegalStateException("INTERNAL: probably a concurrency problem? Instance " + pk + " of class=" + clz + " cannot be loaded");
            }
        }
        block3: for (PropertyMetaModel<?> pmm : cmm.getProperties()) {
            if (pmm.isTransient()) continue;
            switch (pmm.getRelationType()) {
                default: {
                    continue block3;
                }
                case NONE: 
                case UP: 
            }
            Object v = pmm.getValue(source);
            pmm.setValue(copy, v);
        }
        return (T)copy;
    }

    @Override
    public <T> T copyInstanceDeep(QDataContext targetdc, QDataContext sourcedc, T source) throws Exception {
        CopyInfo ci = new CopyInfo(targetdc, sourcedc);
        long ts = System.nanoTime();
        T res = this.internalCopy(ci, source);
        for (InstancePair o : ci.getSaveList()) {
            this.save(ci, o.copy);
            ci.log("Saved new object: " + QBasicModelCopier.identify(o.copy) + " (from " + QBasicModelCopier.identify(o.source) + ")");
            ClassMetaModel cmm = MetaManager.findClassMeta(o.source.getClass());
            Object spk = MetaManager.getPrimaryKey(o.source, cmm);
            Object dpk = MetaManager.getPrimaryKey(o.copy, cmm);
            if (spk == null || spk.equals(dpk)) continue;
            ci.log("FATAL- PRIMARY KEY CHANGED BY HIBERNATE!!!??");
        }
        ts = System.nanoTime() - ts;
        System.out.println("Q: created 'save' copy of " + QBasicModelCopier.identify(source) + ". " + ci.getNCopied() + " copied, " + ci.m_nNew + " added and " + ci.m_nChanged + " changed records in " + StringTool.strNanoTime((long)ts));
        return res;
    }

    private <T> T internalCopy(CopyInfo donemap, T source) throws Exception {
        boolean isnew;
        Object copy = donemap.get(source);
        if (copy != null) {
            donemap.log("returning existing copy for " + QBasicModelCopier.identify(source));
            return (T)copy;
        }
        QBasicModelCopier.assertPrivateContext(donemap.getTargetDC());
        ClassMetaModel cmm = MetaManager.findClassMeta(source.getClass());
        if (!cmm.isPersistentClass()) {
            throw new IllegalStateException("The class " + cmm + " is not a persistent class");
        }
        Class<?> clz = cmm.getActualClass();
        PropertyMetaModel<?> primaryKey = cmm.getPrimaryKey();
        if (null == primaryKey) {
            throw new IllegalStateException(cmm + ": undefined primary key");
        }
        Object pk = primaryKey.getValue(source);
        QPersistentObjectState pos = this.getObjectState(donemap.getSourceDC(), source);
        if (pk == null || pos == QPersistentObjectState.NEW || pos == QPersistentObjectState.UNKNOWN) {
            copy = clz.newInstance();
            isnew = true;
        } else {
            copy = donemap.getTargetDC().find(clz, pk);
            if (copy == null) {
                throw new IllegalStateException("INTERNAL: probably a concurrency problem? Instance " + pk + " of class=" + clz + " cannot be loaded");
            }
            isnew = false;
        }
        donemap.put(source, copy);
        System.out.println();
        donemap.inc();
        this.copyProperties(donemap, source, copy, cmm, pos, isnew);
        donemap.dec();
        donemap.log("Finished src->target copy of " + QBasicModelCopier.identify(source) + (pk == null ? " (new)" : ""));
        return (T)copy;
    }

    private static String dumpValue(Object o) {
        if (o == null) {
            return "null";
        }
        String s = String.valueOf(o);
        if (s.length() > 20) {
            return s.substring(0, 20) + "...";
        }
        return s;
    }

    private <T> void copyProperties(CopyInfo donemap, T source, T copy, ClassMetaModel cmm, QPersistentObjectState pos, boolean copyisnew) throws Exception {
        if (pos == null) {
            pos = this.getObjectState(donemap.getSourceDC(), source);
        }
        boolean docopy = false;
        switch (pos) {
            default: {
                throw new IllegalStateException("Unexpected source object state " + (Object)((Object)pos) + " on " + QBasicModelCopier.identify(source));
            }
            case DELETED: {
                System.out.println("HELP! Deleted object in object graph " + QBasicModelCopier.identify(source));
                return;
            }
            case DIRTY: {
                donemap.incChanges();
            }
            case UNKNOWN: 
            case NEW: {
                docopy = true;
                break;
            }
            case PERSISTED: {
                donemap.log("Not copying fields for clean object " + QBasicModelCopier.identify(source));
                docopy = false;
            }
        }
        ArrayList childpropertylist = null;
        block11: for (PropertyMetaModel<?> propertyMetaModel : cmm.getProperties()) {
            if (propertyMetaModel.getReadOnly() == YesNoType.YES) continue;
            switch (propertyMetaModel.getRelationType()) {
                default: {
                    throw new IllegalStateException("Unexpected relation type: " + (Object)((Object)propertyMetaModel.getRelationType()) + " in " + propertyMetaModel);
                }
                case NONE: {
                    if (!docopy) continue block11;
                    Object v = propertyMetaModel.getValue(source);
                    propertyMetaModel.setValue(copy, v);
                    donemap.log("value property " + propertyMetaModel.getName() + " of " + propertyMetaModel.getClassModel() + ": " + QBasicModelCopier.dumpValue(v));
                    continue block11;
                }
                case UP: {
                    donemap.log("UP: " + propertyMetaModel.getName() + " of " + propertyMetaModel.getClassModel());
                    donemap.inc();
                    this.copyParentProperty(donemap, source, copy, propertyMetaModel);
                    donemap.dec();
                    continue block11;
                }
                case DOWN: 
            }
            if (childpropertylist == null) {
                childpropertylist = new ArrayList();
            }
            childpropertylist.add(propertyMetaModel);
        }
        if (copyisnew) {
            donemap.log("Post for save " + QBasicModelCopier.identify(copy) + " (copy of " + QBasicModelCopier.identify(source) + ")");
            donemap.save(source, copy);
            donemap.incNew();
        } else {
            donemap.incCopies();
        }
        if (childpropertylist != null) {
            for (PropertyMetaModel<Object> propertyMetaModel : childpropertylist) {
                donemap.log("DOWN: " + propertyMetaModel.getName() + " of " + propertyMetaModel.getClassModel());
                donemap.inc();
                this.copyChildListProperty(donemap, source, copy, propertyMetaModel);
                donemap.dec();
            }
        }
    }

    private <T> void copyChildListProperty(CopyInfo donemap, T source, T copy, PropertyMetaModel<?> pmm) throws Exception {
        if (this.isUnloadedChildList(source, pmm)) {
            donemap.log("Child set not loaded, skip children");
            return;
        }
        Object schild = pmm.getValue(source);
        if (schild == null) {
            donemap.log("Child set is null, no children");
            return;
        }
        List slist = (List)schild;
        Object dchild = pmm.getValue(copy);
        if (dchild == null) {
            dchild = new ArrayList(slist.size());
            pmm.setValue(copy, dchild);
        }
        List dlist = (List)dchild;
        Type vtype = pmm.getGenericActualType();
        if (vtype == null) {
            throw new IllegalStateException("Unable to determine the generic TYPE of the child record in DOWN relation property " + pmm);
        }
        Class<?> childclz = MetaManager.findCollectionType(vtype);
        if (null == childclz) {
            throw new IllegalStateException("Can't find collection type");
        }
        ClassMetaModel childmm = MetaManager.findClassMeta(childclz);
        if (!childmm.isPersistentClass()) {
            throw new IllegalStateException("The class " + childmm + " is not a persistent class");
        }
        PropertyMetaModel<?> childpkpmm = childmm.getPrimaryKey();
        if (childpkpmm == null) {
            throw new IllegalStateException("The class " + childmm + " has an unknown primary key");
        }
        HashMap dpkmap = new HashMap();
        for (Object o : dlist) {
            Object dpk = childpkpmm.getValue(o);
            if (dpk == null) {
                throw new IllegalStateException("Unexpected record with null primary key in child list " + pmm);
            }
            dpkmap.put(dpk, o);
        }
        for (Object si : slist) {
            Object di;
            Object spk = childpkpmm.getValue(si);
            if (spk == null) {
                di = this.internalCopy(donemap, si);
                donemap.log("new child " + QBasicModelCopier.identify(si) + " copied as " + QBasicModelCopier.identify(di));
                dlist.add(di);
                continue;
            }
            if (spk.equals(new Long(1100063029L))) {
                System.out.println("GOTCHA");
            }
            if ((di = dpkmap.remove(spk)) != null) {
                donemap.log("existing child " + QBasicModelCopier.identify(si) + " copying properties to " + QBasicModelCopier.identify(di));
                this.copyProperties(donemap, si, di, childmm, null, false);
                continue;
            }
            di = this.internalCopy(donemap, si);
            donemap.log("new child (existing record " + QBasicModelCopier.identify(si) + ") copied as " + QBasicModelCopier.identify(di));
            dlist.add(di);
        }
        for (Object di : dpkmap.values()) {
            donemap.log("Child " + QBasicModelCopier.identify(di) + " not in source's set anymore, deleting");
            dlist.remove(di);
            donemap.inc();
            this.possiblyDeletedRecordInSource(donemap, di);
            donemap.dec();
        }
    }

    private <T> void copyParentProperty(CopyInfo donemap, T source, T copy, PropertyMetaModel<?> pmm) throws Exception {
        Object copyparent;
        Object sparent = pmm.getValue(source);
        Object currparent = pmm.getValue(copy);
        if (sparent == null) {
            donemap.log("parent property is null.");
            copyparent = null;
        } else if (this.isUnloadedParent(source, pmm)) {
            ClassMetaModel pcmm = MetaManager.findClassMeta(sparent.getClass());
            if (!pcmm.isPersistentClass()) {
                throw new IllegalStateException("parent instance pointed to by " + pmm + " is not a persistent class");
            }
            PropertyMetaModel<?> pkpm = pcmm.getPrimaryKey();
            if (pkpm == null) {
                throw new IllegalStateException("parent instance pointed to by " + pmm + " has no primary key defined");
            }
            Object pk = pkpm.getValue(sparent);
            if (pk == null) {
                throw new IllegalStateException("undirtied and existing parent instance has a null PK!?");
            }
            copyparent = donemap.getTargetDC().getInstance(pcmm.getActualClass(), pk);
            donemap.log("property is not instantiated (lazy loaded and unused in this session), get uninstantiated reference in target");
        } else {
            copyparent = this.internalCopy(donemap, sparent);
        }
        if (copyparent != currparent && currparent != null) {
            this.possiblyDeletedRecordInSource(donemap, currparent);
        }
        pmm.setValue(copy, copyparent);
        donemap.log("parent property set to " + QBasicModelCopier.identify(copyparent) + " (source was " + QBasicModelCopier.identify(sparent) + ")");
    }

    private void possiblyDeletedRecordInSource(CopyInfo donemap, Object obj) throws Exception {
        if (obj == null) {
            throw new IllegalStateException("Target object cannot be null");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(obj.getClass());
        Object pk = MetaManager.getPrimaryKey(obj, cmm);
        if (pk == null) {
            donemap.log("delete not possible: null pk on instance " + QBasicModelCopier.identify(obj));
            return;
        }
        QPersistentObjectState pos = this.getObjectState(donemap.getSourceDC(), cmm.getActualClass(), pk);
        switch (pos) {
            default: {
                donemap.log("Delete not needed: " + QBasicModelCopier.identify(obj) + " has persistent state " + (Object)((Object)pos) + " in the source context");
                return;
            }
            case DELETED: 
            case UNKNOWN: 
        }
        this.deleteFromTarget(donemap, obj);
    }

    protected void deleteFromTarget(CopyInfo donemap, Object obj) throws Exception {
        donemap.log("deleting target object " + QBasicModelCopier.identify(obj));
        donemap.getTargetDC().delete(obj);
    }

    protected Object loadCopyFrom(QDataContext dc, Object source, ClassMetaModel cmm, boolean refonly) throws Exception {
        if (source == null) {
            return null;
        }
        if (cmm == null) {
            cmm = MetaManager.findClassMeta(source.getClass());
        }
        if (!cmm.isPersistentClass()) {
            throw new IllegalStateException("Instance " + QBasicModelCopier.identify(source) + " is not a persistent class");
        }
        PropertyMetaModel<?> pkpm = cmm.getPrimaryKey();
        if (pkpm == null) {
            throw new IllegalStateException("Instance " + QBasicModelCopier.identify(source) + " has no primary key defined");
        }
        Object pk = pkpm.getValue(source);
        if (pk == null) {
            throw new IllegalStateException("Instance " + QBasicModelCopier.identify(source) + " has a null primary key?");
        }
        return refonly ? dc.getInstance(cmm.getActualClass(), pk) : dc.find(cmm.getActualClass(), pk);
    }

    public static class CopyInfo {
        private QDataContext m_sourcedc;
        private QDataContext m_targetdc;
        private Map<Object, Object> m_sourceToTargetMap = new HashMap<Object, Object>();
        private List<InstancePair> m_saveList = new ArrayList<InstancePair>();
        int m_nCopied;
        int m_nChanged;
        int m_nNew;
        private int m_level;

        public CopyInfo(QDataContext target, QDataContext source) {
            this.m_sourcedc = source;
            this.m_targetdc = target;
        }

        public QDataContext getSourceDC() {
            return this.m_sourcedc;
        }

        public QDataContext getTargetDC() {
            return this.m_targetdc;
        }

        public void put(Object src, Object tgt) {
            this.m_sourceToTargetMap.put(src, tgt);
        }

        public Object get(Object src) {
            return this.m_sourceToTargetMap.get(src);
        }

        public void save(Object source, Object copy) {
            for (InstancePair ip : this.m_saveList) {
                if (ip.copy != copy) continue;
                return;
            }
            this.m_saveList.add(new InstancePair(source, copy));
        }

        public List<InstancePair> getSaveList() {
            return this.m_saveList;
        }

        public void incCopies() {
            ++this.m_nCopied;
        }

        public void incChanges() {
            ++this.m_nChanged;
        }

        public void incNew() {
            ++this.m_nNew;
        }

        public int getNChanged() {
            return this.m_nChanged;
        }

        public int getNCopied() {
            return this.m_nCopied;
        }

        public void inc() {
            ++this.m_level;
        }

        public void dec() {
            --this.m_level;
        }

        public void log(String s) {
            StringBuilder sb = new StringBuilder(128);
            for (int i = 0; i < this.m_level; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            System.out.println(sb.toString());
        }
    }

    private static class InstancePair {
        Object source;
        Object copy;

        public InstancePair(Object source, Object copy) {
            this.source = source;
            this.copy = copy;
        }
    }
}

