/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.images.converters;

import java.awt.Dimension;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import to.etc.domui.util.images.converters.IImageConversionSpecifier;
import to.etc.domui.util.images.converters.IImageConverter;
import to.etc.domui.util.images.converters.IImageIdentifier;
import to.etc.domui.util.images.converters.ImageConvert;
import to.etc.domui.util.images.converters.ImageConverterHelper;
import to.etc.domui.util.images.converters.ImagePageSelect;
import to.etc.domui.util.images.converters.ImageResize;
import to.etc.domui.util.images.converters.ImageSpec;
import to.etc.domui.util.images.converters.ImageThumbnail;
import to.etc.domui.util.images.machines.ImageHandler;
import to.etc.domui.util.images.machines.ImageInfo;
import to.etc.domui.util.images.machines.ImageManipulator;
import to.etc.domui.util.images.machines.OriginalImagePage;
import to.etc.sjit.ImaTool;

public class BitmapConverter
implements IImageConverter,
IImageIdentifier {
    private static final Set<String> MIMES = new HashSet<String>();

    @Override
    public int accepts(String inputmime, List<IImageConversionSpecifier> conversions) throws Exception {
        if (!MIMES.contains(inputmime)) {
            return -1;
        }
        for (IImageConversionSpecifier ics : conversions) {
            if (ics instanceof ImagePageSelect || ics instanceof ImageResize || ics instanceof ImageConvert) continue;
            return -1;
        }
        return 2;
    }

    @Override
    public void convert(ImageConverterHelper helper, List<IImageConversionSpecifier> convs) throws Exception {
        ImageSpec tis;
        String targetMime = null;
        int sourcePage = 0;
        ImageResize resize = null;
        while (convs.size() > 0) {
            IImageConversionSpecifier ics = convs.get(0);
            if (ics instanceof ImagePageSelect) {
                convs.remove(0);
                ImagePageSelect ips = (ImagePageSelect)ics;
                sourcePage = ips.getPageNumber();
                continue;
            }
            if (ics instanceof ImageConvert) {
                convs.remove(0);
                ImageConvert c = (ImageConvert)ics;
                targetMime = c.getTargetMime();
                continue;
            }
            if (!(ics instanceof ImageResize)) break;
            convs.remove(0);
            resize = (ImageResize)ics;
            if (resize.getTargetMime() == null) continue;
            targetMime = resize.getTargetMime();
        }
        boolean multipage = helper.getSource().getInfo().getPageCount() > 1;
        OriginalImagePage ip = helper.getSource().getInfo().getPage(sourcePage);
        if (targetMime == null) {
            targetMime = helper.getSource().getMime().equals("image/jpeg") || helper.getSource().getMime().equals("image/jpg") ? "image/jpeg" : "image/png";
        }
        ImageHandler ih = ImageManipulator.getImageHandler();
        if (null != resize) {
            Dimension d = ImaTool.resizeWithAspect((int)resize.getWidth(), (int)resize.getHeight(), (int)ip.getWidth(), (int)ip.getHeight());
            tis = resize instanceof ImageThumbnail ? ih.thumbnail(helper, helper.getSource(), sourcePage, d.width, d.height, targetMime) : ih.scale(helper, helper.getSource(), sourcePage, d.width, d.height, targetMime);
        } else {
            tis = multipage || !targetMime.equals(helper.getSource().getMime()) ? ih.convert(helper, helper.getSource(), sourcePage, targetMime) : helper.getSource();
        }
        helper.setTarget(tis);
    }

    @Override
    public ImageInfo identifyImage(File src, String mime) {
        ImageHandler ih = ImageManipulator.getImageHandler();
        try {
            return ih.identify(src);
        }
        catch (Exception x) {
            return null;
        }
    }

    static {
        MIMES.add("image/html");
        MIMES.add("image/plain");
        MIMES.add("image/gif");
        MIMES.add("image/png");
        MIMES.add("image/tiff");
        MIMES.add("image/jpg");
        MIMES.add("image/jpeg");
        MIMES.add("image/bmp");
        MIMES.add("application/pdf");
    }
}

