/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.images.converters;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import to.etc.domui.util.images.converters.IImageConversionSpecifier;
import to.etc.domui.util.images.converters.IImageConverter;
import to.etc.domui.util.images.converters.ImageConverterRegistry;
import to.etc.domui.util.images.converters.ImageSpec;

public class ImageConverterHelper {
    private List<File> m_workFiles = new ArrayList<File>();
    private ImageSpec m_source;
    private ImageSpec m_target;

    public ImageSpec getSource() {
        return this.m_source;
    }

    public ImageSpec getTarget() {
        return this.m_target;
    }

    public void setTarget(ImageSpec target) {
        this.m_target = target;
    }

    public File createWorkFile(String ext) throws IOException {
        File tmp = File.createTempFile("imc", "." + ext);
        this.m_workFiles.add(tmp);
        return tmp;
    }

    public void destroy() {
        for (File wf : this.m_workFiles) {
            try {
                wf.delete();
            }
            catch (Exception exception) {}
        }
    }

    public void executeConversionChain(ImageSpec src, List<IImageConversionSpecifier> speclist) throws Exception {
        if (speclist == null || speclist.size() == 0) {
            this.m_target = this.m_source = src;
            return;
        }
        this.m_source = src;
        while (speclist.size() > 0) {
            IImageConverter ic = ImageConverterRegistry.getBestConverter(src.getMime(), speclist);
            int prec = speclist.size();
            this.m_target = null;
            ic.convert(this, speclist);
            if (speclist.size() == prec) {
                throw new IllegalStateException("Converter " + ic + " does not reduce the list-of-conversions after accepting mime=" + src.getMime() + " using " + speclist);
            }
            if (this.m_target == null) {
                throw new IllegalStateException("Converter " + ic + " did not set a conversion result after converting mime=" + src.getMime() + " using " + speclist);
            }
            this.m_source = this.m_target;
        }
    }
}

