/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.images.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.util.images.converters.BitmapConverter;
import to.etc.domui.util.images.converters.IImageConversionSpecifier;
import to.etc.domui.util.images.converters.IImageConverter;
import to.etc.domui.util.images.converters.IImageIdentifier;
import to.etc.domui.util.images.machines.ImageInfo;

public final class ImageConverterRegistry {
    private static List<IImageConverter> m_list = new ArrayList<IImageConverter>();
    private static List<IImageIdentifier> m_identList = new ArrayList<IImageIdentifier>();

    private ImageConverterRegistry() {
    }

    public static synchronized void registerFactory(IImageConverter c) {
        m_list = new ArrayList<IImageConverter>(m_list);
        m_list.add(c);
    }

    static synchronized List<IImageConverter> getConverterList() {
        return m_list;
    }

    public static synchronized void registerIdentifier(IImageIdentifier c) {
        m_identList = new ArrayList<IImageIdentifier>(m_identList);
        m_identList.add(c);
    }

    public static synchronized List<IImageIdentifier> getIdentList() {
        return m_identList;
    }

    @Nonnull
    public static IImageConverter getBestConverter(String mime, List<IImageConversionSpecifier> convs) throws Exception {
        IImageConverter best = null;
        int bestscore = -1;
        for (IImageConverter ic : ImageConverterRegistry.getConverterList()) {
            int score = ic.accepts(mime, convs);
            if (score <= bestscore) continue;
            bestscore = score;
            best = ic;
        }
        if (best == null) {
            throw new IllegalStateException("No image converter known to convert a " + mime + " using " + convs.get(0));
        }
        return best;
    }

    public static ImageInfo identify(String mime, File src) {
        for (IImageIdentifier ii : ImageConverterRegistry.getIdentList()) {
            ImageInfo id = ii.identifyImage(src, mime);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    static {
        BitmapConverter bc = new BitmapConverter();
        ImageConverterRegistry.registerFactory(bc);
        ImageConverterRegistry.registerIdentifier(bc);
    }
}

