/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.images.machines;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.util.images.machines.OriginalImagePage;

public final class ImageInfo
implements Serializable {
    private String m_mime;
    private final String m_typeName;
    private final boolean m_convertable;
    @Nonnull
    private final List<OriginalImagePage> m_pageList;

    public ImageInfo(String mime, String typeName, boolean convertible, @Nonnull List<OriginalImagePage> pageList) {
        this.m_mime = mime;
        this.m_pageList = Collections.unmodifiableList(pageList);
        this.m_convertable = convertible;
        this.m_typeName = typeName;
    }

    public String getMime() {
        return this.m_mime;
    }

    public void setMime(String mime) {
        this.m_mime = mime;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean isConvertable() {
        return this.m_convertable;
    }

    @Nonnull
    public List<OriginalImagePage> getPageList() {
        return this.m_pageList;
    }

    public int getPageCount() {
        return this.m_pageList == null ? -1 : this.m_pageList.size();
    }

    @Nonnull
    public OriginalImagePage getPage(int ix) {
        if (this.m_pageList == null) {
            throw new IllegalStateException("The page list is null?");
        }
        OriginalImagePage ip = this.m_pageList.get(ix);
        if (null == ip) {
            throw new IllegalStateException("Page " + ix + " is null in page list??");
        }
        return ip;
    }
}

