/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.images.machines;

import java.io.File;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.util.images.converters.ImageConverterHelper;
import to.etc.domui.util.images.converters.ImageSpec;
import to.etc.domui.util.images.machines.ImageHandler;
import to.etc.domui.util.images.machines.ImageInfo;
import to.etc.domui.util.images.machines.OriginalImagePage;
import to.etc.util.ProcessTools;
import to.etc.util.StringTool;
import to.etc.webapp.core.ServerTools;

public final class ImageMagicImageHandler
implements ImageHandler {
    public static final String PNG = "image/png";
    public static final String JPEG = "image/jpeg";
    public static final String JPG = "image/jpg";
    public static final String GIF = "image/gif";
    private static final String[] UNIXPATHS = new String[]{"/opt/imagemagick", "/usr/local/bin", "/usr/bin", "/bin"};
    private static final String[] WINDOWSPATHS = new String[]{"c:\\program files\\ImageMagick", "c:\\Windows"};
    private static final String DENSITY = "400";
    private static boolean m_initialized;
    private static ImageMagicImageHandler m_instance;
    private File m_convert;
    private File m_identify;
    private File m_fileCommand;
    private int m_maxTasks = 2;
    private int m_numTasks;

    private ImageMagicImageHandler(@Nonnull File ident, @Nonnull File convert, File filecommand) {
        this.m_convert = convert;
        this.m_identify = ident;
        this.m_fileCommand = filecommand;
    }

    public static synchronized ImageMagicImageHandler getInstance() {
        if (!m_initialized) {
            ImageMagicImageHandler.initialize();
        }
        return m_instance;
    }

    private static boolean onWindows() {
        return File.separatorChar == '\\';
    }

    @Nonnull
    private static String getExt() {
        return ImageMagicImageHandler.onWindows() ? ".exe" : "";
    }

    private static synchronized void initialize() {
        File f;
        String[] list;
        m_initialized = true;
        ArrayList<String> pathlist = new ArrayList<String>();
        if (File.separatorChar == '\\') {
            pathlist.addAll(Arrays.asList(WINDOWSPATHS));
        } else {
            pathlist.addAll(Arrays.asList(UNIXPATHS));
        }
        String s = System.getenv("PATH");
        if (s != null && (list = s.split("\\" + File.pathSeparator)) != null) {
            pathlist.addAll(Arrays.asList(list));
        }
        File filecommand = null;
        for (String path : pathlist) {
            File f2 = new File(path, "file" + ImageMagicImageHandler.getExt());
            if (!f2.exists()) continue;
            filecommand = f2;
            break;
        }
        if (!StringTool.isBlank((String)(s = System.getenv("VP_MAGICK"))) && ImageMagicImageHandler.initMagick(f = new File(s), filecommand)) {
            return;
        }
        s = System.getProperty("vp.magick");
        if (!StringTool.isBlank((String)s) && ImageMagicImageHandler.initMagick(f = new File(s), filecommand)) {
            return;
        }
        for (String path : pathlist) {
            File base = new File(path);
            if (!ImageMagicImageHandler.initMagick(base, filecommand)) continue;
            return;
        }
        System.out.println("Error: ImageMagick not found in paths " + pathlist);
    }

    private static synchronized boolean initMagick(@Nonnull File base, @Nullable File filecommand) {
        File ident;
        File convert = new File(base, "convert" + ImageMagicImageHandler.getExt());
        if (convert.exists() && (ident = new File(base, "identify" + ImageMagicImageHandler.getExt())).exists()) {
            ImageMagicImageHandler h;
            m_instance = h = new ImageMagicImageHandler(ident, convert, filecommand);
            System.out.println("ImageMagick: using base=" + base);
            return true;
        }
        return false;
    }

    private synchronized void start() {
        while (this.m_numTasks >= this.m_maxTasks) {
            try {
                this.wait();
            }
            catch (InterruptedException ix) {
                throw new RuntimeException(ix);
            }
        }
        ++this.m_numTasks;
    }

    private synchronized void done() {
        --this.m_numTasks;
        this.notify();
    }

    @Override
    public ImageInfo identify(File input) throws Exception {
        String line;
        ProcessBuilder pb;
        int xc;
        StringBuilder sb = new StringBuilder(8192);
        String typeDescription = null;
        if (this.m_fileCommand != null && (xc = ProcessTools.runProcess((ProcessBuilder)(pb = new ProcessBuilder(this.m_fileCommand.getAbsolutePath(), "-b", input.getAbsolutePath())), (Appendable)sb)) == 0) {
            char c;
            int ix;
            String txt = sb.toString().trim();
            int len = txt.length();
            for (ix = 0; ix < len && ((c = txt.charAt(ix)) == '\r' || c == '\n' || Character.isWhitespace(c)); ++ix) {
            }
            if (ix < len) {
                int epos = txt.indexOf(10, ix);
                txt = epos != -1 ? txt.substring(ix, epos).trim() : txt.substring(ix).trim();
            }
            typeDescription = txt;
        }
        pb = new ProcessBuilder(this.m_identify.toString(), "-ping", input.toString());
        sb.setLength(0);
        xc = ProcessTools.runProcess((ProcessBuilder)pb, (Appendable)sb);
        if (xc != 0) {
            this.handleIdentifyError(input, xc, sb);
        }
        ArrayList<OriginalImagePage> list = new ArrayList<OriginalImagePage>();
        LineNumberReader lr = new LineNumberReader(new StringReader(sb.toString()));
        String mime = null;
        while (null != (line = lr.readLine())) {
            String size;
            OriginalImagePage dap;
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (!st.hasMoreTokens()) continue;
            String file = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String type = st.nextToken();
            if (!st.hasMoreTokens() || (dap = ImageMagicImageHandler.decodePage(file, type, size = st.nextToken())) == null) continue;
            list.add(dap);
            if (mime != null) continue;
            mime = dap.getMimeType();
        }
        if (list.isEmpty()) {
            this.handleIdentifyError(input, xc, sb);
        }
        ImageInfo oid = new ImageInfo(mime, typeDescription, true, list);
        return oid;
    }

    private void handleIdentifyError(File imageFile, int xc, StringBuilder output) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Identify failed for file: ");
        errorMessage.append(imageFile.toString());
        errorMessage.append('\n');
        errorMessage.append("Identify exited with code ");
        errorMessage.append(xc);
        errorMessage.append('\n');
        errorMessage.append(output.length() == 0 ? "Identify returned 0 lines." : output.toString());
        throw new IllegalStateException(errorMessage.toString());
    }

    private static OriginalImagePage decodePage(String file, String type, String size) {
        int epos;
        int page = 0;
        int pos = file.indexOf(91);
        if (pos != -1 && (epos = file.indexOf(93, pos + 1)) != -1) {
            page = StringTool.strToInt((String)file.substring(pos + 1, epos), (int)0);
        }
        if ((pos = size.indexOf(120)) == -1) {
            return null;
        }
        int width = StringTool.strToInt((String)size.substring(0, pos), (int)0);
        int height = StringTool.strToInt((String)size.substring(pos + 1), (int)0);
        if (width == 0 || height == 0) {
            return null;
        }
        String s = type.toLowerCase();
        String mime = ServerTools.getExtMimeType((String)s);
        OriginalImagePage dap = new OriginalImagePage(page, width, height, mime, type, false);
        return dap;
    }

    private static String findExt(String mime) {
        if (mime.equalsIgnoreCase(GIF)) {
            return "gif";
        }
        if (mime.equalsIgnoreCase(JPEG) || mime.equalsIgnoreCase(JPG)) {
            return "jpg";
        }
        if (mime.equalsIgnoreCase(PNG)) {
            return "png";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageSpec thumbnail(ImageConverterHelper h, ImageSpec source, int page, int width, int height, String targetMime) throws Exception {
        this.start();
        try {
            StringBuilder sb;
            String ext = ImageMagicImageHandler.findExt(targetMime);
            if (ext == null) {
                throw new IllegalArgumentException("The mime type '" + targetMime + "' is not supported");
            }
            File tof = h.createWorkFile(ext);
            ProcessBuilder pb = null;
            pb = width != 0 && height != 0 ? new ProcessBuilder(this.m_convert.toString(), source.getSource().toString() + "[" + page + "]", "-density", DENSITY, "-thumbnail", width + "x" + height, tof.toString()) : new ProcessBuilder(this.m_convert.toString(), source.getSource().toString() + "[" + page + "]", "-density", DENSITY, tof.toString());
            int xc = ProcessTools.runProcess((ProcessBuilder)pb, (Appendable)(sb = new StringBuilder(8192)));
            if (xc != 0) {
                throw new Exception("External command exception: " + this.m_convert + " returned error code " + xc + "\n" + sb.toString());
            }
            ImageSpec imageSpec = new ImageSpec(tof, targetMime, width, height);
            return imageSpec;
        }
        finally {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageSpec scale(ImageConverterHelper h, ImageSpec source, int page, int width, int height, String targetMime) throws Exception {
        if (ImageMagicImageHandler.onWindows()) {
            return this.thumbnail(h, source, page, width, height, targetMime);
        }
        this.start();
        try {
            String ext = ImageMagicImageHandler.findExt(targetMime);
            if (ext == null) {
                throw new IllegalArgumentException("The mime type '" + targetMime + "' is not supported");
            }
            File tof = h.createWorkFile(ext);
            ProcessBuilder pb = null;
            if (width != 0 && height != 0) {
                String rsz = width + "x" + height;
                pb = new ProcessBuilder(this.m_convert.toString(), "-density", DENSITY, "-size", rsz, source.getSource().toString() + "[" + page + "]", "-thumbnail", rsz, "-coalesce", "-quality", "95", tof.toString());
            } else {
                pb = new ProcessBuilder(this.m_convert.toString(), source.getSource().toString() + "[" + page + "]", "-density", DENSITY, tof.toString());
            }
            StringBuilder sb = new StringBuilder(8192);
            int xc = ProcessTools.runProcess((ProcessBuilder)pb, (Appendable)sb);
            if (xc != 0) {
                throw new Exception("External command exception: " + this.m_convert + " returned error code " + xc + "\n" + sb.toString());
            }
            ImageSpec imageSpec = new ImageSpec(tof, targetMime, width, height);
            return imageSpec;
        }
        finally {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageSpec convert(ImageConverterHelper h, ImageSpec source, int page, String targetMime) throws Exception {
        this.start();
        try {
            String ext = ImageMagicImageHandler.findExt(targetMime);
            if (ext == null) {
                throw new IllegalArgumentException("The mime type '" + targetMime + "' is not supported");
            }
            File tof = h.createWorkFile(ext);
            OriginalImagePage pi = source.getInfo().getPage(page);
            ProcessBuilder pb = new ProcessBuilder(this.m_convert.toString(), source.getSource().toString() + "[" + page + "]", "-coalesce", "-quality", "100", tof.toString());
            System.out.println("Command: " + pb.command().toString());
            StringBuilder sb = new StringBuilder(8192);
            int xc = ProcessTools.runProcess((ProcessBuilder)pb, (Appendable)sb);
            System.out.println("convert: " + sb.toString());
            if (xc != 0) {
                throw new Exception("External command exception: " + this.m_convert + " returned error code " + xc + "\n" + sb.toString());
            }
            ImageSpec imageSpec = new ImageSpec(tof, targetMime, pi.getWidth(), pi.getHeight());
            return imageSpec;
        }
        finally {
            this.done();
        }
    }
}

