/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.janitor;

import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.util.janitor.JanitorException;
import to.etc.domui.util.janitor.JanitorTask;
import to.etc.domui.util.janitor.JanitorThread;

public class Janitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Janitor.class);
    private static final int jspNONE = 0;
    private static final int jspSTART = 1;
    private static final int jspRUN = 2;
    private int m_start_phase;
    private int m_n_maxjobs;
    private int m_tasknr = 1;
    private boolean m_termination_requested = false;
    private JanitorThread[] m_job_ar;
    private int m_n_running;
    private long m_t_last_sched_run;
    private long m_t_freeslot;
    private ArrayList<JanitorTask> m_task_v = new ArrayList();
    private boolean m_thread_isrunning = false;
    private static Janitor m_j;

    public Janitor(int maxjobs) {
        this.m_n_maxjobs = maxjobs;
        this.m_job_ar = new JanitorThread[maxjobs];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Janitor janitor = this;
        synchronized (janitor) {
            if (this.m_start_phase != 0) {
                throw new RuntimeException("This instance has ALREADY been started!");
            }
            this.m_start_phase = 1;
        }
        Thread t = new Thread((Runnable)this, "Janitor");
        t.setDaemon(true);
        t.start();
        int ct = 10;
        Janitor janitor2 = this;
        synchronized (janitor2) {
            while (!this.m_thread_isrunning && ct-- > 0) {
                try {
                    this.wait(5000L);
                }
                catch (Exception exception) {}
            }
        }
        if (ct <= 0) {
            throw new RuntimeException("FATAL Janitor: thread did not start!?");
        }
        LOG.debug("Janitor: thread seems to run, life's good ;-) " + ct + ", " + this.m_thread_isrunning);
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    private long getSchedTime() {
        return this.m_t_last_sched_run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void logTask(JanitorThread jt, String msg) {
        JanitorThread janitorThread = jt;
        synchronized (janitorThread) {
            LOG.debug("T" + jt.m_slot + ":" + jt.m_jt.m_taskname + "- " + msg);
        }
    }

    public int addTask(int interval, boolean once, String name, JanitorTask jt) throws Exception {
        jt.m_j = this;
        jt.m_taskname = name;
        if (once) {
            jt.m_t_next = System.currentTimeMillis() + (long)(interval * 1000);
            jt.m_t_interval = -1;
        } else {
            jt.m_t_interval = interval;
            jt.calcNextStartTime();
        }
        this.insertOrderedTask(jt);
        return jt.m_key;
    }

    public int addTask(int offset, int interval, String name, JanitorTask jt) throws Exception {
        jt.m_j = this;
        jt.m_taskname = name;
        jt.m_t_next = this.getTime() + (long)(offset * 1000);
        jt.m_t_interval = interval;
        this.insertOrderedTask(jt);
        return jt.m_key;
    }

    private synchronized void insertOrderedTask(JanitorTask jt) throws JanitorException {
        if (this.m_task_v.contains(jt)) {
            throw new JanitorException(jt, "This task was ALREADY scheduled!!");
        }
        jt.m_key = this.m_tasknr++;
        this.insertOrdered(jt);
    }

    public int addTaskAt(Date attime, String name, JanitorTask jt) throws Exception {
        jt.m_j = this;
        jt.m_taskname = name;
        jt.m_t_interval = -1;
        jt.setNextTime(attime);
        this.insertOrderedTask(jt);
        return jt.m_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelJob(int id) {
        Janitor janitor = this;
        synchronized (janitor) {
            for (JanitorTask task : this.m_task_v) {
                if (task.m_key != id || task.m_deleted) continue;
                task.m_deleted = true;
                this.m_task_v.remove(task);
                return true;
            }
        }
        return false;
    }

    private synchronized void insertOrdered(JanitorTask jt) {
        for (int i = 0; i < this.m_task_v.size(); ++i) {
            JanitorTask tjt = this.m_task_v.get(i);
            if (jt.m_t_next >= tjt.m_t_next) continue;
            this.m_task_v.add(i, jt);
            return;
        }
        this.m_task_v.add(jt);
    }

    private void initialize() {
    }

    private void terminialize() {
    }

    public synchronized boolean mustTerminate() {
        return this.m_termination_requested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_t_freeslot = this.m_t_last_sched_run = this.getTime();
        Janitor janitor = this;
        synchronized (janitor) {
            this.m_start_phase = 2;
            this.m_thread_isrunning = true;
            this.notify();
        }
        LOG.debug("Janitor thread started - initializing");
        try {
            this.initialize();
            while (!this.mustTerminate()) {
                this.runSinglePass();
                Thread.sleep(10000L);
            }
            this.terminialize();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.error("FATAL exception in mainloop: " + t.getMessage(), t);
        }
        finally {
            this.m_thread_isrunning = false;
        }
        LOG.debug("Janitor thread stopped!?");
    }

    private void runSinglePass() {
        try {
            this.m_t_last_sched_run = this.getTime();
            if (!this.handleJobQueue()) {
                if (this.m_t_freeslot - this.getSchedTime() > 600000L) {
                    System.out.println("Janitor: No jobs have completed in 10 minutes; cannot schedule!!");
                    LOG.info("WARNING: NO JANITOR JOBS COMPLETED IN 10 MINUTES!!");
                }
            } else {
                this.m_t_freeslot = this.getSchedTime();
            }
        }
        catch (Throwable x) {
            LOG.warn("ERROR! Janitor exception catched: " + x.toString());
        }
    }

    private boolean handleJobQueue() {
        boolean hascompleted = false;
        for (int i = 0; i < this.m_n_maxjobs; ++i) {
            if (!this.handleJobSlot(i)) continue;
            hascompleted = true;
        }
        return hascompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobCompleted(JanitorThread jtd) {
        Janitor janitor = this;
        synchronized (janitor) {
            --this.m_n_running;
            jtd.setState(0);
            JanitorTask jt = jtd.m_jt;
            jtd.m_jt = null;
            jt.m_run_slot = -1;
            this.m_task_v.remove(jt);
            if (!jt.m_deleted && jt.m_t_interval != -1) {
                jt.calcNextStartTime();
                this.insertOrdered(jt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleJobSlot(int sn) {
        JanitorTask jt;
        JanitorThread jtd = this.m_job_ar[sn];
        if (jtd != null) {
            if (jtd.hasState(2)) {
                return false;
            }
            if (jtd.hasState(3)) {
                this.jobCompleted(jtd);
            }
        }
        Janitor janitor = this;
        synchronized (janitor) {
            jt = this.getRunnableTask();
            if (jt == null) {
                return true;
            }
            if (jtd == null) {
                this.m_job_ar[sn] = jtd = new JanitorThread(this, sn);
            }
            jtd.assignTask(jt);
            ++this.m_n_running;
        }
        Thread t = new Thread((Runnable)jtd, "Jt:" + jt.m_taskname);
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JanitorTask getRunnableTask() {
        long ct = this.getSchedTime();
        Janitor janitor = this;
        synchronized (janitor) {
            for (JanitorTask jt : this.m_task_v) {
                if (ct < jt.m_t_next) {
                    return null;
                }
                if (jt.m_deleted || jt.m_unrunnable || jt.m_run_slot != -1) continue;
                return jt;
            }
        }
        return null;
    }

    public long getTimeStamp() {
        if (!this.m_thread_isrunning) {
            throw new RuntimeException("Janitor: main thread is not running!?");
        }
        return this.m_t_last_sched_run;
    }

    public static synchronized Janitor getJanitor() {
        if (m_j != null) {
            return m_j;
        }
        m_j = new Janitor(10);
        m_j.start();
        return m_j;
    }
}

