/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.javascript;

import java.util.Date;
import javax.annotation.Nonnull;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.javascript.JsMethod;
import to.etc.json.JSON;
import to.etc.util.StringTool;

public class JavascriptStmt {
    @Nonnull
    private final StringBuilder m_sb;
    private boolean m_instmt;
    private JsMethod m_currentMethod;

    public JavascriptStmt(@Nonnull StringBuilder worksb) {
        this.m_sb = worksb;
    }

    @Nonnull
    public StringBuilder sb() {
        return this.m_sb;
    }

    @Nonnull
    public JavascriptStmt next() {
        if (!this.m_instmt) {
            return this;
        }
        if (this.m_sb.length() == 0) {
            return this;
        }
        char last = this.m_sb.charAt(this.m_sb.length() - 1);
        if (last != ';') {
            this.m_sb.append(";");
        }
        this.m_instmt = false;
        return this;
    }

    @Nonnull
    public JavascriptStmt select(@Nonnull NodeBase node) {
        return this.select(node.getActualID());
    }

    @Nonnull
    public JavascriptStmt select(@Nonnull String id) {
        this.sb().append("$('#").append(id).append("')");
        this.m_instmt = true;
        return this;
    }

    char lastChar() {
        int length = this.m_sb.length();
        if (length == 0) {
            return '\u0000';
        }
        return this.m_sb.charAt(length - 1);
    }

    @Nonnull
    public JavascriptStmt append(@Nonnull String string) {
        this.sb().append(string);
        this.m_instmt = true;
        return this;
    }

    @Nonnull
    public JavascriptStmt object(@Nonnull Object object) throws Exception {
        this.m_instmt = true;
        if (object == null) {
            this.sb().append("null");
        } else if (object instanceof String) {
            StringTool.strToJavascriptString((Appendable)this.sb(), (String)((String)object), (boolean)false);
        } else if (object instanceof Number) {
            this.sb().append(object.toString());
        } else if (object instanceof Date) {
            this.sb().append(((Date)object).getTime());
        } else if (object instanceof Boolean) {
            this.sb().append(((Boolean)object).toString());
        } else {
            this.sb().append(JSON.render((Object)object));
        }
        return this;
    }

    @Nonnull
    public JavascriptStmt endmethod() {
        JsMethod jm = this.m_currentMethod;
        if (null != jm) {
            this.m_currentMethod = null;
            jm.flush();
        }
        return this;
    }

    @Nonnull
    public JsMethod method(@Nonnull String name) {
        this.m_instmt = true;
        this.endmethod();
        char lc = this.lastChar();
        if (lc != '\u0000' && lc != ';' && lc != '.' && lc != '(') {
            this.sb().append('.');
        }
        this.sb().append(name);
        this.sb().append('(');
        this.m_currentMethod = new JsMethod(this);
        return this.m_currentMethod;
    }

    public static void main(String[] args) throws Exception {
        StringBuilder sb = new StringBuilder();
        JavascriptStmt st = new JavascriptStmt(sb);
        st.select("_IZ").method("options").arg("hello").arg(1).arg(Boolean.TRUE).end().next();
        System.out.println(sb.toString());
        sb.setLength(0);
        st.select("_IZ").method("options").arg("hello").arg(1).arg(Boolean.TRUE).end().next();
    }
}

