/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.js;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import to.etc.domui.util.js.IScriptScope;
import to.etc.domui.util.js.RhinoScriptScope;
import to.etc.util.RuntimeConversions;

class RhinoObjectBase
implements IScriptScope {
    @Nonnull
    private ScriptableObject m_scriptable;
    private boolean m_writable;

    RhinoObjectBase(@Nonnull ScriptableObject scriptable, boolean writable) {
        this.m_scriptable = scriptable;
        this.m_writable = writable;
    }

    RhinoObjectBase(ScriptableObject rootScope) {
        this.m_writable = true;
        Context jcx = Context.enter();
        try {
            this.m_scriptable = (ScriptableObject)jcx.newObject((Scriptable)rootScope);
            this.m_scriptable.setPrototype((Scriptable)rootScope);
            this.m_scriptable.setParentScope(null);
        }
        finally {
            Context.exit();
        }
    }

    @Nullable
    protected <T> T translateValue(Class<T> targetClass, @Nullable Object val) {
        if (null == val) {
            return null;
        }
        if (val == UniqueTag.NOT_FOUND) {
            return null;
        }
        if (targetClass.isAssignableFrom(val.getClass())) {
            return (T)val;
        }
        if (val instanceof ScriptableObject && targetClass.isAssignableFrom((val = new RhinoScriptScope((ScriptableObject)val)).getClass())) {
            return (T)val;
        }
        return (T)RuntimeConversions.convertTo((Object)val, targetClass);
    }

    public void put(@Nonnull String name, @Nullable Object instance) {
        if (!this.m_writable) {
            throw new IllegalStateException("This scope is read-only.");
        }
        this.m_scriptable.put(name, (Scriptable)this.m_scriptable, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RhinoScriptScope newScope() {
        Context jcx = Context.enter();
        try {
            ScriptableObject scope = (ScriptableObject)jcx.newObject((Scriptable)this.m_scriptable);
            scope.setPrototype((Scriptable)this.m_scriptable);
            scope.setParentScope(null);
            RhinoScriptScope rhinoScriptScope = new RhinoScriptScope(scope, true);
            return rhinoScriptScope;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    @Nullable
    public <T> T getValue(@Nonnull Class<T> targetType, @Nonnull String name) {
        Object val = ScriptableObject.getProperty((Scriptable)this.m_scriptable, (String)name);
        return this.translateValue(targetType, val);
    }

    @Override
    @Nullable
    public <T> T getAdapter(@Nonnull Class<T> clz) {
        if (clz.isAssignableFrom(Scriptable.class)) {
            return (T)this.m_scriptable;
        }
        return null;
    }

    @Override
    @Nonnull
    public <T> List<T> getProperties(@Nonnull Class<T> filterClass) {
        Object[] ids = this.m_scriptable.getIds();
        ArrayList<Object> res = new ArrayList<Object>(ids.length);
        for (Object id : ids) {
            if (!filterClass.isAssignableFrom(id.getClass())) continue;
            res.add(id);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T eval(@Nonnull Class<T> targetType, @Nonnull Reader r, @Nonnull String sourceFileNameIndicator) throws Exception {
        Context jcx = Context.enter();
        try {
            Object val = jcx.evaluateReader((Scriptable)this.m_scriptable, r, sourceFileNameIndicator, 1, null);
            T t = this.translateValue(targetType, val);
            return t;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T eval(@Nonnull Class<T> targetType, @Nonnull String expression, @Nonnull String sourceFileNameIndicator) throws Exception {
        Context jcx = Context.enter();
        try {
            Object val = jcx.evaluateString((Scriptable)this.m_scriptable, expression, sourceFileNameIndicator, 1, null);
            T t = this.translateValue(targetType, val);
            return t;
        }
        finally {
            Context.exit();
        }
    }

    public Object toObject(Object o) {
        return Context.toObject((Object)o, (Scriptable)this.m_scriptable);
    }

    @Override
    @Nonnull
    public IScriptScope addObjectProperty(@Nonnull String name) {
        RhinoScriptScope ns = this.newScope();
        this.put(name, ns);
        return ns;
    }
}

