/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.js;

import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import to.etc.domui.util.js.IScriptScope;
import to.etc.template.IJSTemplateContext;
import to.etc.template.JSLocationMapping;
import to.etc.template.JSTemplateCompiler;
import to.etc.template.JSTemplateError;

public class RhinoTemplate {
    private final String m_source;
    private final Script m_code;
    private final List<JSLocationMapping> m_locMap;

    public RhinoTemplate(String source, Script code, List<JSLocationMapping> locMap) {
        this.m_source = source;
        this.m_code = code;
        this.m_locMap = locMap;
    }

    public final String getSource() {
        return this.m_source;
    }

    public Object execute(IJSTemplateContext tc, Scriptable scope) {
        scope.put("out", scope, (Object)tc);
        Context cx = Context.enter();
        try {
            Object object = this.m_code.exec(cx, scope);
            return object;
        }
        catch (RhinoException sx) {
            int[] res = JSTemplateCompiler.remapLocation(this.m_locMap, (int)sx.lineNumber(), (int)sx.columnNumber());
            throw new JSTemplateError((Throwable)sx, sx.getMessage(), this.m_source, res[0], res[1]);
        }
        finally {
            Context.exit();
        }
    }

    private IJSTemplateContext createContext(final Appendable a) {
        return new IJSTemplateContext(){

            public void writeValue(Object v) throws Exception {
                if (v == null) {
                    return;
                }
                if (v instanceof Double) {
                    String res = v.toString();
                    if (res.endsWith(".0")) {
                        res = res.substring(0, res.length() - 2);
                    }
                    a.append(res);
                } else {
                    a.append(v.toString());
                }
            }

            public void write(String text) throws Exception {
                a.append(text);
            }
        };
    }

    public Object execute(Appendable a, Scriptable scope) {
        return this.execute(this.createContext(a), scope);
    }

    public Object execute(Appendable a, IScriptScope scope) {
        Scriptable ss = scope.getAdapter(Scriptable.class);
        return this.execute(this.createContext(a), ss);
    }
}

