/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.modelcopier;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.util.modelcopier.InstanceKey;
import to.etc.domui.util.modelcopier.ModelCopier;

public class EntityDef<T> {
    private final ModelCopier m_model;
    @Nonnull
    private final Class<T> m_entityClass;
    @Nullable
    private String[] m_searchKey;
    @Nonnull
    private ClassMetaModel m_mm;
    private boolean m_copy = true;
    private boolean m_creatable = true;
    private boolean m_createAlways;
    private boolean m_updateExisting = false;

    public EntityDef(@Nonnull ModelCopier model, @Nonnull Class<T> entityClass) {
        this.m_model = model;
        this.m_entityClass = entityClass;
        this.m_mm = MetaManager.findClassMeta(entityClass);
    }

    public T createInstance() throws Exception {
        return this.m_entityClass.newInstance();
    }

    public Class<T> getEntityClass() {
        return this.m_entityClass;
    }

    @Nonnull
    public ClassMetaModel getMetaModel() {
        return this.m_mm;
    }

    public EntityDef<T> key(String ... k) {
        if (k.length == 0) {
            throw new IllegalStateException(this + ": key set cannot be empty");
        }
        this.m_searchKey = k;
        return this;
    }

    public String[] getSearchKey() {
        if (this.m_searchKey == null) {
            throw new IllegalStateException(this + ": search key not known");
        }
        return this.m_searchKey;
    }

    @Nonnull
    public InstanceKey<T> getInstanceKey(T instance) throws Exception {
        Object[] vals = new Object[this.getSearchKey().length];
        int ix = 0;
        for (String prop : this.getSearchKey()) {
            PropertyMetaModel<?> pmm = this.m_mm.getProperty(prop);
            Object kval = pmm.getValue(instance);
            if (kval == null) {
                throw new IllegalStateException(this + ": entity " + instance + " key field " + prop + " is null - cannot locate");
            }
            if (!EntityDef.isEntityInstance(kval)) {
                vals[ix] = kval;
            } else {
                InstanceKey<?> altk;
                EntityDef<?> altd = this.m_model.getDefinition(kval.getClass());
                vals[ix] = altk = altd.getInstanceKey(kval);
            }
            ++ix;
        }
        return new InstanceKey<T>(this, vals, instance);
    }

    public static <X> boolean isEntityInstance(@Nullable X t) {
        if (t == null) {
            return false;
        }
        Class<?> tclz = t.getClass();
        ClassMetaModel cmm = MetaManager.findClassMeta(tclz);
        return cmm.isPersistentClass();
    }

    public boolean isCopy() {
        return this.m_copy;
    }

    public EntityDef<T> setCopy(boolean ok) {
        this.m_copy = ok;
        return this;
    }

    public EntityDef<T> nocopy() {
        this.m_copy = false;
        return this;
    }

    public boolean isCreatable() {
        return this.m_creatable;
    }

    public boolean isCreateAlways() {
        return this.m_createAlways;
    }

    public EntityDef<T> nocreate() {
        this.m_creatable = false;
        return this;
    }

    public EntityDef<T> createAlways() {
        this.m_createAlways = true;
        return this;
    }

    public boolean isUpdateExisting() {
        return this.m_updateExisting || this.m_model.isUpdateExisting();
    }

    public String toString() {
        return this.getEntityClass().getName();
    }

    public EntityDef<T> update() {
        this.m_updateExisting = true;
        return this;
    }
}

