/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.modelcopier;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.util.modelcopier.EntityDef;

public class InstanceKey<T> {
    @Nonnull
    private final EntityDef<T> m_entity;
    @Nonnull
    private final Object[] m_keyValues;
    private final T m_sourceInstance;

    public InstanceKey(EntityDef<T> entity, Object[] keyValues, @Nullable T sourceInstance) {
        this.m_entity = entity;
        this.m_keyValues = keyValues;
        this.m_sourceInstance = sourceInstance;
    }

    public EntityDef<T> getEntity() {
        return this.m_entity;
    }

    public Object[] getKeyValues() {
        return this.m_keyValues;
    }

    @Nullable
    public T getSourceInstance() {
        return this.m_sourceInstance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_entity == null ? 0 : this.m_entity.hashCode());
        result = 31 * result + Arrays.hashCode(this.m_keyValues);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceKey other = (InstanceKey)obj;
        if (this.m_entity == null ? other.m_entity != null : !this.m_entity.equals(other.m_entity)) {
            return false;
        }
        return Arrays.equals(this.m_keyValues, other.m_keyValues);
    }

    @Nonnull
    public Object getValue(int ix) {
        return this.m_keyValues[ix];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEntity()).append("[");
        for (int i = 0; i < this.m_keyValues.length; ++i) {
            Object v = this.m_keyValues[i];
            String n = this.getEntity().getSearchKey()[i];
            if (i > 0) {
                sb.append(',');
            }
            sb.append(n).append('=').append(v);
        }
        sb.append("]");
        return sb.toString();
    }
}

