/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.modelcopier;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.util.modelcopier.EntityDef;
import to.etc.domui.util.modelcopier.InstanceKey;
import to.etc.util.ILogSink;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContext;

public class ModelCopier {
    @Nonnull
    private final QDataContext m_dds;
    @Nullable
    private final ILogSink m_sink;
    @Nonnull
    final Map<Class<?>, EntityDef<?>> m_defMap = new HashMap();
    private StringBuilder m_pathSb = new StringBuilder();
    private String m_currentPath;
    private Set<String> m_ignorePathSet = new HashSet<String>();
    private boolean m_updateExisting;
    @Nonnull
    private Map<InstanceKey<?>, Object> m_destInstanceMap = new HashMap();
    @Nonnull
    private Map<InstanceKey<?>, Object> m_srcInstanceMap = new HashMap();
    @Nonnull
    private Stack<InstanceKey<?>> m_currentFindSet = new Stack();

    public ModelCopier(@Nullable ILogSink sink, @Nonnull QDataContext sds, @Nonnull QDataContext dds) throws Exception {
        this.m_sink = sink;
        this.m_dds = dds;
        this.m_dds.startTransaction();
    }

    private void log(String s) {
        if (null != this.m_sink) {
            this.m_sink.log(s);
        }
    }

    @Nonnull
    public ModelCopier ignorePath(String path) {
        this.m_ignorePathSet.add(path);
        return this;
    }

    public ModelCopier updateExisting() {
        this.m_updateExisting = true;
        return this;
    }

    public boolean isUpdateExisting() {
        return this.m_updateExisting;
    }

    public <T> EntityDef<T> define(@Nonnull Class<T> eclass) {
        EntityDef<Object> ed = this.m_defMap.get(eclass);
        if (null == ed) {
            ed = new EntityDef<T>(this, eclass);
            this.m_defMap.put(eclass, ed);
        }
        return ed;
    }

    @Nullable
    public <T> EntityDef<T> findDefinition(@Nonnull Class<T> eclass) {
        return this.m_defMap.get(eclass);
    }

    @Nonnull
    public <T> EntityDef<T> getDefinition(@Nonnull Class<T> eclass) {
        ClassMetaModel cmm = MetaManager.findClassMeta(eclass);
        EntityDef<?> ed = this.findDefinition(cmm.getActualClass());
        if (null == ed) {
            throw new IllegalStateException(eclass + ": no entity definition");
        }
        return ed;
    }

    @Nullable
    public <T> T copy(@Nonnull T src, Object ... except) throws Exception {
        HashSet<Object> exceptSet = new HashSet<Object>();
        for (Object xc : except) {
            exceptSet.add(xc);
        }
        return this.copyInstance(src);
    }

    @Nullable
    private <T> T findKnownDestInstance(@Nonnull InstanceKey<T> k) {
        return (T)this.m_destInstanceMap.get(k);
    }

    @Nullable
    private <T> T copyInstance(@Nonnull T src) throws Exception {
        EntityDef<?> ed = this.getDefinition(src.getClass());
        if (!ed.isCopy()) {
            return null;
        }
        InstanceKey<?> key = ed.getInstanceKey(src);
        return (T)this.destCreate(key);
    }

    public <T> T destLocate(InstanceKey<T> key) throws Exception {
        T dv = this.findKnownDestInstance(key);
        if (null != dv) {
            return dv;
        }
        if (key.getEntity().isCreateAlways()) {
            return null;
        }
        dv = this.dbfind(key);
        if (null == dv) {
            return null;
        }
        if (key.getEntity().isUpdateExisting()) {
            this.updateProperties(key, dv);
        }
        return dv;
    }

    private <T> void updateProperties(InstanceKey<T> key, T di) throws Exception {
        EntityDef<T> ed = key.getEntity();
        List<PropertyMetaModel<?>> pl = ed.getMetaModel().getProperties();
        ArrayList childList = new ArrayList();
        T si = key.getSourceInstance();
        if (null == si) {
            throw new IllegalStateException("No source instance for key " + key);
        }
        block4: for (PropertyMetaModel<?> propertyMetaModel : pl) {
            switch (propertyMetaModel.getRelationType()) {
                default: {
                    continue block4;
                }
                case DOWN: {
                    childList.add(propertyMetaModel);
                    continue block4;
                }
                case NONE: 
            }
            this.copyValue(ed, di, si, propertyMetaModel);
        }
        for (PropertyMetaModel<Object> propertyMetaModel : childList) {
        }
    }

    public <T> T destCreate(@Nonnull InstanceKey<T> key) throws Exception {
        T di = this.destLocate(key);
        if (null != di) {
            return di;
        }
        int xi = this.m_currentFindSet.indexOf(key);
        if (xi >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Find loop: ");
            for (int ix = xi; ix < this.m_currentFindSet.size(); ++ix) {
                sb.append(">");
                sb.append(this.m_currentFindSet.get(ix));
            }
            throw new IllegalStateException(sb.toString());
        }
        EntityDef<T> ed = key.getEntity();
        if (!ed.isCopy()) {
            return null;
        }
        if (!ed.isCreatable()) {
            throw new IllegalStateException(key + ": not allowed to create instances of " + ed);
        }
        T src = key.getSourceInstance();
        if (src == null) {
            throw new IllegalStateException(key + ": source instance is null??");
        }
        this.m_currentFindSet.add(key);
        System.out.println("mc: creating " + key + " (" + this.m_currentPath + ")");
        di = ed.createInstance();
        this.m_destInstanceMap.put(key, di);
        this.copyProperties(ed, di, src, key);
        this.m_currentFindSet.remove(key);
        return di;
    }

    private <T, I> void copyProperties(@Nonnull EntityDef<T> ed, @Nonnull T di, @Nonnull T si, @Nonnull InstanceKey<T> key) throws Exception {
        List<PropertyMetaModel<?>> pl = ed.getMetaModel().getProperties();
        ArrayList childList = new ArrayList();
        block5: for (PropertyMetaModel<?> propertyMetaModel : pl) {
            switch (propertyMetaModel.getRelationType()) {
                default: {
                    throw new IllegalStateException((Object)((Object)propertyMetaModel.getRelationType()) + ": ??");
                }
                case DOWN: {
                    childList.add(propertyMetaModel);
                    continue block5;
                }
                case NONE: {
                    this.copyValue(ed, di, si, propertyMetaModel);
                    continue block5;
                }
                case UP: 
            }
            this.copyParent(ed, di, si, propertyMetaModel);
        }
        this.m_dds.save(di);
        for (PropertyMetaModel<Object> propertyMetaModel : childList) {
            if (!List.class.isAssignableFrom(propertyMetaModel.getActualType())) {
                throw new IllegalStateException(propertyMetaModel + ": unsupported child relation container type");
            }
            PropertyMetaModel<Object> npm = propertyMetaModel;
            this.copyChildren(ed, di, si, npm);
        }
    }

    private <T, I, X extends List<I>> void copyChildren(@Nonnull EntityDef<T> ed, @Nonnull T di, @Nonnull T si, @Nonnull PropertyMetaModel<X> pmm) throws Exception {
        int sbl = this.m_pathSb.length();
        this.adjustPath(sbl, pmm.getName());
        if (this.isIgnoredPath()) {
            this.resetPath(sbl);
            return;
        }
        List sval = (List)pmm.getValue(si);
        ArrayList dval = (ArrayList)pmm.getValue(di);
        if (sval != null) {
            Type ct;
            Class<?> itemtype;
            if (dval == null) {
                dval = new ArrayList();
                pmm.setValue(di, dval);
            }
            if (null == (itemtype = MetaManager.findCollectionType(ct = pmm.getGenericActualType()))) {
                throw new IllegalStateException("Cannot get collection type");
            }
            this.getDefinition(itemtype);
            for (Object srci : sval) {
                Object dsti = this.copyInstance(srci);
                dval.add(dsti);
            }
        } else {
            dval = null;
        }
        this.resetPath(sbl);
        pmm.setValue(di, dval);
    }

    private <T, X> void copyParent(@Nonnull EntityDef<T> ed, @Nonnull T di, @Nonnull T si, @Nonnull PropertyMetaModel<X> pmm) throws Exception {
        int sbl = this.m_pathSb.length();
        this.adjustPath(sbl, pmm.getName());
        if (this.isIgnoredPath()) {
            this.resetPath(sbl);
            return;
        }
        Object val = pmm.getValue(si);
        if (val != null) {
            EntityDef<X> ped = this.getDefinition(pmm.getActualType());
            InstanceKey<X> vk = ped.getInstanceKey(val);
            val = this.destCreate(vk);
        }
        pmm.setValue(di, val);
        this.resetPath(sbl);
    }

    private <T, X> void copyValue(@Nonnull EntityDef<T> ed, @Nonnull T di, @Nonnull T si, @Nonnull PropertyMetaModel<X> pmm) throws Exception {
        if (pmm.isTransient() || pmm.getReadOnly() == YesNoType.YES) {
            return;
        }
        if (pmm.isPrimaryKey()) {
            return;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(pmm.getActualType());
        if (cmm.isPersistentClass()) {
            throw new IllegalStateException("Attempt to copy-by-value property " + pmm + " containing a persistent " + cmm);
        }
        Object val = pmm.getValue(si);
        pmm.setValue(di, val);
    }

    @Nullable
    public <T> T dbfind(InstanceKey<T> key) throws Exception {
        QCriteria q = QCriteria.create(key.getEntity().getEntityClass());
        int ix = 0;
        int sbl = this.m_pathSb.length();
        for (String name : key.getEntity().getSearchKey()) {
            InstanceKey altk;
            this.adjustPath(sbl, name);
            Object kv = key.getValue(ix);
            if (kv instanceof InstanceKey && null == (kv = this.destCreate(altk = (InstanceKey)kv))) {
                throw new IllegalStateException("Cannot locate key entity for field '" + name + "': " + altk);
            }
            if (kv == null) {
                throw new IllegalStateException("Logic: null key fragment " + name + " in " + key);
            }
            q.eq(name, kv);
            ++ix;
        }
        this.resetPath(sbl);
        this.log("FIND: " + key + " using " + q);
        Object di = this.m_dds.queryOne(q);
        if (null != di) {
            this.m_destInstanceMap.put(key, di);
        }
        return (T)di;
    }

    private void adjustPath(int sbl, String name) {
        this.m_pathSb.setLength(sbl);
        if (this.m_pathSb.length() > 0) {
            this.m_pathSb.append('.');
        }
        this.m_pathSb.append(name);
        this.m_currentPath = this.m_pathSb.toString();
    }

    private void resetPath(int sbl) {
        this.m_pathSb.setLength(sbl);
        this.m_currentPath = this.m_pathSb.toString();
    }

    public boolean isIgnoredPath() {
        return this.m_ignorePathSet.contains(this.m_currentPath);
    }

    private static boolean isExcepted(@Nonnull Set<Object> exceptSet, @Nonnull PropertyMetaModel<?> frpmm) {
        if (exceptSet.contains(frpmm.getName())) {
            return true;
        }
        for (Object t : exceptSet) {
            Class rc;
            if (t != Class.class || !(rc = (Class)t).isAssignableFrom(frpmm.getActualType())) continue;
            return true;
        }
        return false;
    }
}

