/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.util.resources.ClasspathFileRef;
import to.etc.domui.util.resources.ClasspathJarRef;
import to.etc.domui.util.resources.IModifyableResource;
import to.etc.util.StringTool;

public class ClasspathInventory {
    static final Logger LOG = LoggerFactory.getLogger(ClasspathInventory.class);
    private static ClasspathInventory m_instance;
    private final Set<File> m_fileSet;
    private Map<String, IModifyableResource> m_lookupMap = new HashMap<String, IModifyableResource>();
    private Map<String, ClasspathJarRef> m_jarMap = new HashMap<String, ClasspathJarRef>();
    private Map<String, ClasspathJarRef> m_jarModificationMap = new HashMap<String, ClasspathJarRef>();
    private static final IModifyableResource NOT_FOUND;

    ClasspathInventory(Set<File> files) {
        this.m_fileSet = files;
    }

    public static ClasspathInventory create(URL[] urls) {
        HashSet<File> fileSet = new HashSet<File>();
        for (URL u : urls) {
            ClasspathInventory.addUrl(fileSet, u);
        }
        return new ClasspathInventory(fileSet);
    }

    public static ClasspathInventory create(ClassLoader cl) {
        HashSet<File> fileSet = new HashSet<File>();
        ClasspathInventory.findUrlsFor(fileSet, cl);
        return new ClasspathInventory(fileSet);
    }

    public static synchronized ClasspathInventory getInstance() {
        if (m_instance == null) {
            m_instance = ClasspathInventory.create(ClasspathInventory.class.getClassLoader());
        }
        return m_instance;
    }

    private static void findUrlsFor(Set<File> result, ClassLoader loader) {
        if (loader == null) {
            return;
        }
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            for (URL u : ucl.getURLs()) {
                ClasspathInventory.addUrl(result, u);
            }
        }
        ClasspathInventory.findUrlsFor(result, loader.getParent());
    }

    private static void addUrl(Set<File> result, URL u) {
        if ("file".equalsIgnoreCase(u.getProtocol())) {
            try {
                File f = new File(u.toURI());
                result.add(f);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public synchronized IModifyableResource findResourceSource(String resourcePath) {
        IModifyableResource rr;
        long t = System.nanoTime();
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((rr = this.m_lookupMap.get(resourcePath)) != null) {
            if (rr == NOT_FOUND) {
                return null;
            }
            return rr;
        }
        IModifyableResource ts = this.scanActually(resourcePath);
        this.m_lookupMap.put(resourcePath, ts == null ? NOT_FOUND : ts);
        if (LOG.isDebugEnabled()) {
            t = System.nanoTime() - t;
            LOG.debug("inventory: " + (ts == null ? "un" : "") + "succesful findResourceSource " + resourcePath + " took " + StringTool.strNanoTime((long)t));
        }
        return ts;
    }

    public synchronized IModifyableResource findClassSource(Class<?> clz) {
        IModifyableResource rr = this.m_lookupMap.get(clz.getName());
        if (rr != null) {
            if (rr == NOT_FOUND) {
                return null;
            }
            return rr;
        }
        String path = clz.getName().replace('.', '/') + ".class";
        IModifyableResource ts = this.findResourceSource(path);
        this.m_lookupMap.put(clz.getName(), ts == null ? NOT_FOUND : ts);
        return ts;
    }

    private synchronized IModifyableResource scanActually(String path) {
        for (File u : this.m_fileSet) {
            IModifyableResource ts = this.checkForFile(u, path);
            if (ts == null) continue;
            return ts;
        }
        if (this.m_jarMap.size() != 0) {
            ClasspathJarRef jref = this.m_jarMap.get(path);
            if (jref != null) {
                return jref;
            }
            LOG.info("The classpath resource '" + path + "' cannot be found in the jars... Scanning them for changes.");
        }
        this.scanJars();
        return this.m_jarMap.get(path);
    }

    private IModifyableResource checkForFile(File f, String rel) {
        if (f.getName().toLowerCase().endsWith(".jar")) {
            return null;
        }
        if (!f.exists() || !f.isDirectory()) {
            return null;
        }
        File nw = new File(f, rel);
        if (!nw.exists() || !nw.isFile()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found classpathentry " + rel + " in " + f);
        }
        return new ClasspathFileRef(nw);
    }

    private synchronized void scanJars() {
        long ts = System.nanoTime();
        int jcount = 0;
        int lcount = 0;
        for (File f : this.m_fileSet) {
            if (!f.getName().endsWith(".jar") || !f.exists() || !f.isFile()) continue;
            if (this.loadJarInventory(f)) {
                ++lcount;
            }
            ++jcount;
        }
        ts = System.nanoTime() - ts;
        LOG.info("(Re)loading " + lcount + " changed .jar files of " + jcount + " total containing " + this.m_jarMap.size() + " entries took " + StringTool.strNanoTime((long)ts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean loadJarInventory(File f) {
        String name = f.getAbsolutePath();
        ClasspathJarRef orig = this.m_jarModificationMap.get(name);
        if (orig != null) {
            if (!orig.isModified()) {
                return false;
            }
            for (String entry : orig.getNameList()) {
                if (orig != this.m_jarMap.get(entry)) continue;
                this.m_jarMap.remove(entry);
            }
            this.m_jarModificationMap.remove(name);
        }
        ClasspathJarRef jarref = new ClasspathJarRef(f);
        this.m_jarModificationMap.put(name, jarref);
        FileInputStream is = null;
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            is = new FileInputStream(f);
            zis = new ZipInputStream(is);
            while (null != (ze = zis.getNextEntry())) {
                this.m_jarMap.put(ze.getName(), jarref);
                jarref.getNameList().add(ze.getName());
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<String> getPackageInventory(@Nonnull String pkgdirname) {
        pkgdirname = pkgdirname.replace('.', '/');
        ArrayList<String> res = new ArrayList<String>();
        for (File f : this.m_fileSet) {
            File[] far;
            File nw;
            if (f.getName().toLowerCase().endsWith(".jar") || !f.exists() || !f.isDirectory() || !(nw = new File(f, pkgdirname)).isDirectory()) continue;
            for (File fi : far = nw.listFiles()) {
                if (!fi.isFile()) continue;
                res.add(fi.getName());
            }
        }
        if (this.m_jarMap.size() == 0) {
            this.scanJars();
        }
        int pdl = pkgdirname.length();
        ClasspathInventory classpathInventory = this;
        synchronized (classpathInventory) {
            for (String ks : this.m_jarMap.keySet()) {
                String rn;
                if (!ks.startsWith(pkgdirname) || ks.length() <= pdl + 1 || ks.charAt(pdl) != '/' || (rn = ks.substring(pdl + 1)).indexOf(47) != -1) continue;
                res.add(rn);
            }
        }
        return res;
    }

    public static void main(String[] args) {
        try {
            List<String> res = ClasspathInventory.getInstance().getPackageInventory("org.apache.batik.css.dom");
            for (String s : res) {
                System.out.println("res=" + s);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static {
        NOT_FOUND = new IModifyableResource(){

            @Override
            public long getLastModified() {
                throw new IllegalStateException("Whazzup!?");
            }
        };
    }
}

