/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.domui.util.resources.IModifyableResource;
import to.etc.util.ByteBufferInputStream;
import to.etc.util.FileTool;

public class ClasspathJarRef
implements IModifyableResource {
    private File m_src;
    private long m_resourceLoaderTS;
    private long m_ts;
    private Map<String, byte[][]> m_cachedMap = new HashMap<String, byte[][]>();
    private List<String> m_nameList = new ArrayList<String>();

    public ClasspathJarRef(File src) {
        this.m_src = src;
        this.m_ts = src.lastModified();
    }

    public List<String> getNameList() {
        return this.m_nameList;
    }

    public boolean isModified() {
        return this.m_ts != this.getLastModified();
    }

    @Override
    public long getLastModified() {
        try {
            if (!this.m_src.exists()) {
                return -1L;
            }
            return this.m_src.lastModified();
        }
        catch (Exception x) {
            return -1L;
        }
    }

    private synchronized byte[][] getCachedResource(String relname) throws IOException {
        byte[][] bufs;
        long cts = this.m_src.lastModified();
        if (this.m_resourceLoaderTS != cts) {
            this.m_resourceLoaderTS = cts;
            this.m_cachedMap.clear();
        }
        if ((bufs = this.m_cachedMap.get(relname)) == null) {
            bufs = this.loadFromJar(relname);
            if (bufs == null) {
                throw new IOException("Jar file entry " + relname + " not found in jar " + this.m_src);
            }
            this.m_cachedMap.put(relname, bufs);
        }
        return bufs;
    }

    private byte[][] loadFromJar(String name) throws IOException {
        try (InputStream is = FileTool.getZipContent((File)this.m_src, (String)name);){
            if (null == is) {
                throw new IOException("File '" + name + "' not found in jar " + this.m_src);
            }
            byte[][] byArray = FileTool.loadByteBuffers((InputStream)is);
            return byArray;
        }
    }

    public InputStream getResource(String relname) throws IOException {
        return new ByteBufferInputStream(this.getCachedResource(relname));
    }

    public String toString() {
        return "[ClasspathJar: " + this.m_src.toString() + "]";
    }
}

