/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.server.DomApplication;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.domui.util.resources.IModifyableResource;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.util.ByteBufferInputStream;
import to.etc.util.ByteBufferOutputStream;
import to.etc.util.FileTool;
import to.etc.util.LineIterator;

public class CompoundResourceRef
implements IResourceRef,
IModifyableResource {
    private byte[][] m_buffers;

    private CompoundResourceRef(@Nonnull byte[][] buffers) {
        this.m_buffers = buffers;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    @Nullable
    public InputStream getInputStream() throws Exception {
        return new ByteBufferInputStream(this.m_buffers);
    }

    public static IResourceRef loadBySpec(@Nonnull DomApplication da, @Nonnull String baseDir, @Nonnull String inclset, @Nonnull String origname) throws Exception {
        ByteBufferOutputStream bos = new ByteBufferOutputStream();
        for (String line : new LineIterator(inclset)) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || !line.startsWith("include")) continue;
            CompoundResourceRef.load(da, bos, baseDir, line.substring(7).trim(), origname);
        }
        bos.close();
        return new CompoundResourceRef(bos.getBuffers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(@Nonnull DomApplication da, @Nonnull ByteBufferOutputStream bos, @Nonnull String baseDir, @Nonnull String filename, String origname) throws Exception {
        IResourceRef resource;
        if (!filename.startsWith("/")) {
            filename = baseDir + filename;
        }
        if (!(resource = da.getAppFileOrResource(filename)).exists()) {
            throw new ThingyNotFoundException("Cannot find include file " + filename + " referenced in " + origname);
        }
        InputStream is = null;
        try {
            is = resource.getInputStream();
            FileTool.copyFile((OutputStream)bos, (InputStream)is);
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{is});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{is});
    }
}

