/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.io.File;
import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceFactory;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.WebappResourceRef;

public class RedirectingResourceFactory
implements IResourceFactory {
    @Nonnull
    private final String m_match;
    @Nonnull
    private final File m_newroot;
    private final boolean m_isfile;

    public RedirectingResourceFactory(boolean isfile, @Nonnull String match, @Nonnull File newroot) {
        this.m_isfile = isfile;
        this.m_match = match;
        this.m_newroot = newroot;
        if (!newroot.exists()) {
            throw new IllegalStateException(newroot + ": path does not exist");
        }
    }

    @Override
    public int accept(@Nonnull String name) {
        if (name.startsWith(this.m_match)) {
            return 100;
        }
        return -1;
    }

    @Override
    @Nonnull
    public IResourceRef getResource(@Nonnull DomApplication da, @Nonnull String name, @Nonnull IResourceDependencyList rdl) throws Exception {
        if (this.m_isfile) {
            return new WebappResourceRef(this.m_newroot);
        }
        String sub = name.substring(this.m_match.length());
        File f = new File(this.m_newroot, sub);
        return new WebappResourceRef(f);
    }
}

