/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.io.InputStream;
import to.etc.domui.util.resources.ClasspathJarRef;
import to.etc.domui.util.resources.IModifyableResource;
import to.etc.domui.util.resources.IResourceRef;

public class ReloadingClassResourceRef
implements IResourceRef,
IModifyableResource {
    private IModifyableResource m_source;
    private Class<?> m_base;
    private String m_name;

    public ReloadingClassResourceRef(IModifyableResource mr, String name) {
        this.m_source = mr;
        this.m_base = ReloadingClassResourceRef.class;
        if (!name.startsWith("/")) {
            throw new IllegalStateException("The root-based resource reference " + name + " must start with a '/'");
        }
        this.m_name = name;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        if (this.m_source == null || !(this.m_source instanceof ClasspathJarRef)) {
            return this.m_base.getResourceAsStream(this.m_name);
        }
        ClasspathJarRef jref = (ClasspathJarRef)this.m_source;
        return jref.getResource(this.m_name.substring(1));
    }

    @Override
    public boolean exists() {
        return this.getLastModified() != -1L;
    }

    @Override
    public long getLastModified() {
        return this.m_source == null ? -1L : this.m_source.getLastModified();
    }

    public String toString() {
        return "ClassResourceRef[" + this.m_name + "]";
    }
}

