/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.util.resources.IIsModified;
import to.etc.domui.util.resources.IModifyableResource;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencies;
import to.etc.domui.util.resources.ResourceTimestamp;

public final class ResourceDependencyList
implements IResourceDependencyList {
    public static final IResourceDependencyList NULL = new IResourceDependencyList(){

        @Override
        public void add(@Nonnull IModifyableResource c) {
        }

        @Override
        public void add(@Nonnull IIsModified m) {
        }

        @Override
        public void add(@Nonnull IResourceRef ref) {
        }
    };
    @Nonnull
    private List<IIsModified> m_deplist = Collections.EMPTY_LIST;

    @Override
    public void add(@Nonnull IResourceRef ref) {
        if (ref instanceof IIsModified) {
            this.add((IIsModified)((Object)ref));
        } else if (ref instanceof IModifyableResource) {
            this.add((IModifyableResource)((Object)ref));
        } else {
            throw new IllegalArgumentException("Argument " + ref + " must implement IIsModified or IModifyableResource to be usable for dependency change tracking");
        }
    }

    @Override
    public void add(@Nonnull IIsModified m) {
        if (this.m_deplist == Collections.EMPTY_LIST) {
            this.m_deplist = new ArrayList<IIsModified>(5);
        } else {
            for (IIsModified xm : this.m_deplist) {
                if (m != xm) continue;
                return;
            }
        }
        this.m_deplist.add(m);
    }

    @Override
    public void add(@Nonnull IModifyableResource c) {
        if (this.m_deplist == Collections.EMPTY_LIST) {
            this.m_deplist = new ArrayList<IIsModified>(5);
        } else {
            for (IIsModified xm : this.m_deplist) {
                ResourceTimestamp rx;
                if (!(xm instanceof ResourceTimestamp) || (rx = (ResourceTimestamp)xm).getRef() != c) continue;
                return;
            }
        }
        this.m_deplist.add(new ResourceTimestamp(c, c.getLastModified()));
    }

    public void add(@Nonnull ResourceDependencyList c) {
        for (IIsModified mr : c.m_deplist) {
            this.add(mr);
        }
    }

    public ResourceDependencies createDependencies() {
        return new ResourceDependencies(this.m_deplist);
    }
}

