/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.awt.Dimension;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.ResourceDependencyList;
import to.etc.sjit.ImaTool;

@DefaultNonNull
public final class ResourceInfoCache {
    private final DomApplication m_application;
    private final Map<String, ImageDimension> m_imageDimensionMap = new HashMap<String, ImageDimension>();

    public ResourceInfoCache(DomApplication application) {
        this.m_application = application;
    }

    @Nullable
    public to.etc.domui.component.image.Dimension getImageDimension(NodeBase node, String themeResource) throws Exception {
        String path = node.getThemedResourceRURL(themeResource);
        return this.getImageDimension(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public to.etc.domui.component.image.Dimension getImageDimension(String resourceRURL) throws Exception {
        to.etc.domui.component.image.Dimension d;
        ImageDimension id;
        Map<String, ImageDimension> map = this.m_imageDimensionMap;
        synchronized (map) {
            id = this.m_imageDimensionMap.get(resourceRURL);
            if (null == id) {
                id = new ImageDimension();
                this.m_imageDimensionMap.put(resourceRURL, id);
            }
        }
        ImageDimension imageDimension = id;
        synchronized (imageDimension) {
            d = id.m_dimension;
            if (null == d) {
                d = id.m_dimension = this.calculateImageDimensions(resourceRURL);
            }
        }
        return d;
    }

    @Nullable
    private to.etc.domui.component.image.Dimension calculateImageDimensions(String resourceRURL) throws Exception {
        System.out.println("Calculating dimensions of " + resourceRURL);
        IResourceRef ref = DomApplication.get().getResource(resourceRURL, ResourceDependencyList.NULL);
        try (InputStream is = ref.getInputStream();){
            if (null == is) {
                to.etc.domui.component.image.Dimension dimension = null;
                return dimension;
            }
            Dimension d = ImaTool.getImageDimension((InputStream)is);
            if (null == d) {
                to.etc.domui.component.image.Dimension dimension = null;
                return dimension;
            }
            to.etc.domui.component.image.Dimension dimension = new to.etc.domui.component.image.Dimension(d);
            return dimension;
        }
    }

    private static final class ImageDimension {
        @Nullable
        to.etc.domui.component.image.Dimension m_dimension;

        private ImageDimension() {
        }
    }
}

