/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.resources;

import java.io.File;
import javax.annotation.Nonnull;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.resources.CompoundResourceRef;
import to.etc.domui.util.resources.IResourceDependencyList;
import to.etc.domui.util.resources.IResourceFactory;
import to.etc.domui.util.resources.IResourceRef;
import to.etc.domui.util.resources.WebappResourceRef;
import to.etc.util.FileTool;

public class VersionedJsResourceFactory
implements IResourceFactory {
    @Override
    public int accept(@Nonnull String name) {
        if (name.startsWith("$js/")) {
            return 15;
        }
        return -1;
    }

    @Override
    @Nonnull
    public IResourceRef getResource(@Nonnull DomApplication da, @Nonnull String name, @Nonnull IResourceDependencyList rdl) throws Exception {
        IResourceRef r;
        int pos = (name = name.substring(3)).lastIndexOf(46);
        String min = pos < 0 ? null : name.substring(0, pos) + "-min" + name.substring(pos);
        StringBuilder sb = new StringBuilder(64);
        if (!da.inDevelopmentMode() && min != null) {
            sb.append("js/").append(da.getScriptVersion()).append(min);
            r = this.tryVersionedResource(da, sb.toString());
            if (r != null) {
                return r;
            }
            sb.setLength(0);
            sb.append("js").append(min);
            r = this.tryVersionedResource(da, sb.toString());
            if (r != null) {
                if (null != rdl) {
                    rdl.add(r);
                }
                return r;
            }
        }
        sb.setLength(0);
        sb.append("js/").append(da.getScriptVersion()).append(name);
        r = this.tryVersionedResource(da, sb.toString());
        if (r == null && null == (r = this.tryVersionedResource(da, "js" + name))) {
            r = da.getAppFileOrResource("js" + name);
        }
        if (null != rdl) {
            rdl.add(r);
        }
        return r;
    }

    private IResourceRef tryVersionedResource(DomApplication da, String iname) throws Exception {
        File f = da.getAppFile(iname);
        if (f.exists() && f.isFile()) {
            return new WebappResourceRef(f);
        }
        String name = "/resources/" + iname;
        if (DomUtil.classResourceExists(this.getClass(), name)) {
            return da.createClasspathReference(name);
        }
        name = iname + ".inclspec";
        f = da.getAppFile(name);
        String inclset = null;
        if (f.exists() && f.isFile()) {
            inclset = FileTool.readFileAsString((File)f);
        } else {
            name = "/resources/" + iname + ".inclspec";
            if (DomUtil.classResourceExists(this.getClass(), name)) {
                inclset = FileTool.readResourceAsString(this.getClass(), (String)name, (String)"utf-8");
            } else {
                return null;
            }
        }
        String root = "";
        int pos = iname.lastIndexOf("/");
        if (pos > 0) {
            root = iname.substring(0, pos + 1);
        }
        return CompoundResourceRef.loadBySpec(da, root, inclset, iname);
    }
}

