/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.upload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import to.etc.util.FileTool;

public class FencedOutputStream
extends OutputStream {
    private ByteArrayOutputStream m_bbos;
    private File m_repos;
    private File m_file;
    private FileOutputStream m_fos;
    private int m_fenceSize;
    private int m_size;
    private byte[] m_buffer;

    public FencedOutputStream(File repos, int fence) {
        this.m_repos = repos;
        this.m_fenceSize = fence;
        this.m_bbos = new ByteArrayOutputStream();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.m_fos != null) {
                this.m_fos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.m_bbos != null) {
                this.m_bbos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_bbos != null) {
            this.m_buffer = this.m_bbos.toByteArray();
            this.m_bbos = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream os = this.checkOutput(1);
        os.write(b);
        ++this.m_size;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream os = this.checkOutput(len);
        os.write(b, off, len);
        this.m_size += len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        OutputStream os = this.checkOutput(b.length);
        os.write(b);
        this.m_size += b.length;
    }

    private OutputStream checkOutput(int len) throws IOException {
        if (this.m_fos != null) {
            return this.m_fos;
        }
        if (this.m_bbos.size() + len <= this.m_fenceSize) {
            return this.m_bbos;
        }
        this.m_file = FileTool.makeTempFile((File)this.m_repos);
        this.m_fos = new FileOutputStream(this.m_file);
        this.m_fos.write(this.m_bbos.toByteArray());
        this.m_bbos = null;
        return this.m_fos;
    }

    public final boolean isMemory() {
        return this.m_bbos != null || this.m_buffer != null;
    }

    public final byte[] getBuffer() {
        if (this.m_buffer == null) {
            throw new IllegalStateException("The content of this item is no longer in memory");
        }
        return this.m_buffer;
    }

    public final int size() {
        return this.m_size;
    }

    public final File getFile() {
        return this.m_file;
    }
}

