/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.upload;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import to.etc.domui.util.upload.FileUploadException;
import to.etc.domui.util.upload.UploadItem;
import to.etc.domui.util.upload.UploadParser;
import to.etc.util.WrappedException;

public class UploadHttpRequestWrapper
extends HttpServletRequestWrapper {
    public static final String UPLOADKEY = "to.etc.domui.up$load$key";
    private Map<String, String[]> m_formItemMap = new HashMap<String, String[]>();
    private Map<String, UploadItem[]> m_fileItemMap = new HashMap<String, UploadItem[]>();
    @Nullable
    private FileUploadException m_uploadException;

    public UploadHttpRequestWrapper(HttpServletRequest req) {
        super(req);
        this.init(req);
    }

    public static UploadHttpRequestWrapper findWrapper(HttpServletRequest req) {
        if (req instanceof UploadHttpRequestWrapper) {
            return (UploadHttpRequestWrapper)req;
        }
        return (UploadHttpRequestWrapper)((Object)req.getAttribute(UPLOADKEY));
    }

    private void init(HttpServletRequest req) {
        if (!UploadParser.isMultipartContent(req)) {
            throw new IllegalStateException("Cannot wrap a non-multipart request!");
        }
        UploadParser dfu = new UploadParser();
        dfu.setSizeMax(0x6400000);
        List<UploadItem> l = null;
        try {
            this.m_uploadException = null;
            l = dfu.parseRequest(req, req.getCharacterEncoding());
        }
        catch (FileUploadException sxe) {
            this.m_uploadException = sxe;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new WrappedException((Throwable)x);
        }
        if (l != null) {
            HashMap<String, ArrayList<Object>> parammap = new HashMap<String, ArrayList<Object>>();
            HashMap<String, ArrayList<Object>> filemap = new HashMap<String, ArrayList<Object>>();
            for (int i = 0; i < l.size(); ++i) {
                List<Object> v;
                UploadItem fi = l.get(i);
                String name = fi.getName().toLowerCase();
                if (!fi.isFile()) {
                    v = (ArrayList<Object>)parammap.get(name);
                    if (v == null) {
                        v = new ArrayList<Object>(5);
                        parammap.put(name, (ArrayList<Object>)v);
                    }
                    v.add(fi.getValue());
                    System.out.println("~~ form item name=" + name);
                    continue;
                }
                v = (List)filemap.get(name);
                if (v == null) {
                    v = new ArrayList(5);
                    filemap.put(name, (ArrayList<Object>)v);
                }
                v.add(fi);
            }
            for (Map.Entry me : parammap.entrySet()) {
                this.m_formItemMap.put((String)me.getKey(), ((List)me.getValue()).toArray(new String[((List)me.getValue()).size()]));
            }
            for (Map.Entry me : filemap.entrySet()) {
                this.m_fileItemMap.put((String)me.getKey(), ((List)me.getValue()).toArray(new UploadItem[((List)me.getValue()).size()]));
            }
        }
        req.setAttribute(UPLOADKEY, (Object)this);
    }

    public String getParameter(String name) {
        String[] ar = this.m_formItemMap.get(name.toLowerCase());
        return ar == null ? null : ar[0];
    }

    public String[] getParameterValues(String name) {
        return this.m_formItemMap.get(name.toLowerCase());
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> v = new Vector<String>(this.m_formItemMap.keySet());
        return v.elements();
    }

    public Map<String, String[]> getParameterMap() {
        return this.m_formItemMap;
    }

    public Map<String, UploadItem[]> getFileItemMap() throws Exception {
        this.checkUploadException();
        return this.m_fileItemMap;
    }

    private void checkUploadException() throws Exception {
        FileUploadException uploadException = this.m_uploadException;
        if (uploadException != null) {
            throw uploadException;
        }
    }

    public UploadItem getFileItem(String name) throws Exception {
        this.checkUploadException();
        UploadItem[] ar = this.m_fileItemMap.remove(name.toLowerCase());
        if (ar == null) {
            return null;
        }
        if (ar.length > 1) {
            for (UploadItem ui : ar) {
                ui.discard();
            }
            throw new IllegalStateException("Multiple file items for name=" + name);
        }
        return ar[0];
    }

    public UploadItem[] getFileItems(String name) throws Exception {
        this.checkUploadException();
        return this.m_fileItemMap.remove(name.toLowerCase());
    }

    public void releaseFiles() {
        this.m_uploadException = null;
        for (UploadItem[] uiar : this.m_fileItemMap.values()) {
            for (UploadItem ui : uiar) {
                try {
                    ui.discard();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

