/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.upload;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UploadItem {
    private String m_fieldName;
    private String m_contentType;
    private String m_charset;
    private String m_value;
    private String m_fileName;
    private File m_backingFile;
    private boolean m_file;

    public UploadItem(String fieldname, String contenttype, String charset, String filename, boolean isfile) {
        this.m_fieldName = fieldname;
        this.m_contentType = contenttype;
        this.m_fileName = filename;
        this.m_charset = charset;
        this.m_file = isfile;
    }

    public boolean isFile() {
        return this.m_file;
    }

    public void setFile(File f) {
        this.m_backingFile = f;
    }

    @Nullable
    public String getCharSet() {
        return this.m_charset;
    }

    public String getValue() {
        return this.m_value;
    }

    void setValue(String sa) {
        this.m_value = sa;
    }

    void setValue(File f) {
        this.m_backingFile = f;
    }

    @Nonnull
    public String getName() {
        return this.m_fieldName;
    }

    @Nullable
    public String getRemoteFileName() {
        return this.m_fileName;
    }

    @Nullable
    public String getContentType() {
        return this.m_contentType;
    }

    public int getSize() {
        if (this.isFile() && this.m_backingFile == null) {
            throw new IllegalStateException("The file has already been closed (deleted)");
        }
        if (this.m_backingFile != null) {
            return (int)this.m_backingFile.length();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.m_fileName == null;
    }

    public File getFile() {
        if (this.isFile() && this.m_backingFile == null) {
            throw new IllegalStateException("The file has already been closed (deleted)");
        }
        return this.m_backingFile;
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="FindBugs definition is wrong for mkdirs, and delete() may fail in code here")
    void discard() {
        if (this.m_backingFile == null) {
            return;
        }
        try {
            System.out.println("Releasing unclaimed FILE upload: " + this.getName() + ", " + this.getSize() + " @" + this.getFile());
            this.m_backingFile.delete();
            this.m_backingFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.m_backingFile == null) {
            return;
        }
        try {
            this.m_backingFile.delete();
            this.m_backingFile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

