/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.util.upload;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import to.etc.domui.util.upload.FileUploadException;
import to.etc.domui.util.upload.FileUploadInterruptedException;
import to.etc.domui.util.upload.FileUploadSizeExceededException;
import to.etc.domui.util.upload.HeaderParser;
import to.etc.domui.util.upload.MiniParser;
import to.etc.domui.util.upload.MultipartStream;
import to.etc.domui.util.upload.UploadHttpRequestWrapper;
import to.etc.domui.util.upload.UploadItem;
import to.etc.util.FileTool;

public class UploadParser {
    private static final String MULTIPART = "multipart/";
    private static final String MULTIPART_MIXED = "multipart/mixed";
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String FORM_DATA = "form-data";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String ATTACHMENT = "attachment";
    private int m_sizeMax = 0x6400000;

    public final int getSizeMax() {
        return this.m_sizeMax;
    }

    public final void setSizeMax(int sizeMax) {
        this.m_sizeMax = sizeMax;
    }

    public static final boolean isMultipartContent(HttpServletRequest req) {
        if (!"POST".equalsIgnoreCase(req.getMethod())) {
            return false;
        }
        String contentType = req.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public static final HttpServletRequest wrapIfNeeded(HttpServletRequest req) {
        if (!UploadParser.isMultipartContent(req)) {
            return req;
        }
        if (UploadHttpRequestWrapper.findWrapper(req) != null) {
            return req;
        }
        return new UploadHttpRequestWrapper(req);
    }

    public List<UploadItem> parseRequest(HttpServletRequest ctx, String hdrencoding) throws FileUploadException, IOException {
        try {
            String ct = ctx.getContentType();
            int requestSize = ctx.getContentLength();
            ServletInputStream is = ctx.getInputStream();
            return this.parseRequest((InputStream)is, hdrencoding, ct, requestSize);
        }
        catch (EOFException ex) {
            throw new FileUploadInterruptedException(ex);
        }
    }

    private static String getStringHeader(Map<String, Object> hdr, String name) {
        Object o = hdr.get(name.toLowerCase());
        if (o == null || o instanceof List) {
            return null;
        }
        return (String)o;
    }

    private static void discardItems(List<UploadItem> l) {
        int i = l.size();
        while (--i >= 0) {
            UploadItem ui = l.get(i);
            try {
                ui.discard();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public List<UploadItem> parseRequest(InputStream is, String hdrencoding, String contentType, int requestSize) throws FileUploadException, IOException {
        if (contentType == null || !contentType.toLowerCase().startsWith(MULTIPART)) {
            throw new FileUploadException("Content type is not an accepted multipart type but " + contentType);
        }
        if (requestSize == -1) {
            throw new FileUploadException("The content length is missing or invalid");
        }
        MiniParser p = new MiniParser();
        byte[] boundary = this.decodeBoundary(p, contentType);
        if (boundary == null) {
            throw new FileUploadException("The request did not specify a 'boundary'");
        }
        HeaderParser hp = new HeaderParser();
        HashMap<String, Object> headermap = new HashMap<String, Object>();
        MultipartStream multi = new MultipartStream(is, boundary);
        multi.setHeaderEncoding(hdrencoding);
        ArrayList<UploadItem> l = new ArrayList<UploadItem>();
        if (!multi.skipPreamble()) {
            return l;
        }
        boolean ok = false;
        boolean toolarge = false;
        try {
            while (true) {
                hp.parse(headermap, multi.readHeaders(), true);
                String fieldname = this.decodeHeaderItem(headermap, CONTENT_DISPOSITION, "name", FORM_DATA, null, p);
                if (fieldname == null) {
                    multi.discardBodyData();
                } else {
                    String subContentType = UploadParser.getStringHeader(headermap, CONTENT_TYPE);
                    if (subContentType != null && subContentType.toLowerCase().startsWith(MULTIPART_MIXED)) {
                        byte[] subBoundary = this.decodeBoundary(p, subContentType);
                        if (subBoundary == null) {
                            throw new FileUploadException("The sub-content type did not specify a 'boundary'");
                        }
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            hp.parse(headermap, multi.readHeaders(), true);
                            String filename = this.decodeHeaderItem(headermap, CONTENT_DISPOSITION, "filename", FORM_DATA, ATTACHMENT, p);
                            if (filename != null) {
                                if (!this.readItem(p, l, headermap, multi, fieldname, filename)) {
                                    toolarge = true;
                                }
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else {
                        String filename = this.decodeHeaderItem(headermap, CONTENT_DISPOSITION, "filename", FORM_DATA, ATTACHMENT, p);
                        if (!this.readItem(p, l, headermap, multi, fieldname, filename)) {
                            toolarge = true;
                        }
                    }
                }
                if (multi.readBoundary()) continue;
                if (toolarge) {
                    throw new FileUploadSizeExceededException(this.m_sizeMax);
                }
                ok = true;
                ArrayList<UploadItem> arrayList = l;
                return arrayList;
            }
        }
        finally {
            if (!ok) {
                UploadParser.discardItems(l);
            }
        }
    }

    private byte[] decodeBoundary(MiniParser p, String contentType) {
        p.init(contentType);
        while (p.parseNext()) {
            if (!"boundary".equalsIgnoreCase(p.getProperty())) continue;
            String val = p.getValue();
            if (val == null || val.length() == 0) {
                return null;
            }
            try {
                return val.getBytes("ISO-8859-1");
            }
            catch (Exception x) {
                return val.getBytes();
            }
        }
        return null;
    }

    private String decodeHeaderItem(Map<String, Object> headers, String headername, String keyname, String h1, String h2, MiniParser mp) {
        Object o = headers.get(headername.toLowerCase());
        if (o == null || !(o instanceof String)) {
            return null;
        }
        String hdr = (String)o;
        if (!(hdr.startsWith(h1) || h2 != null && hdr.startsWith(h2))) {
            return null;
        }
        mp.init(hdr);
        while (mp.parseNext()) {
            if (!keyname.equalsIgnoreCase(mp.getProperty())) continue;
            if (mp.getValue() == null) {
                return null;
            }
            return mp.getValue().trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readItem(MiniParser p, List<UploadItem> l, Map<String, Object> headermap, MultipartStream multi, String fieldname, String fn) throws IOException {
        boolean isfile;
        String contenttype = UploadParser.getStringHeader(headermap, CONTENT_TYPE);
        String charset = null;
        if (contenttype != null) {
            p.init(contenttype);
            while (p.parseNext()) {
                if (!"charset".equalsIgnoreCase(p.getProperty()) || p.getValue() == null) continue;
                charset = p.getValue();
                break;
            }
        }
        if (charset == null) {
            charset = "utf-8";
        }
        boolean bl = isfile = fn != null;
        if (fn != null && fn.trim().length() == 0) {
            fn = null;
        }
        UploadItem ui = new UploadItem(fieldname, contenttype, charset, fn, isfile);
        OutputStream os = null;
        ByteArrayOutputStream bos = null;
        File resf = null;
        int bytesRead = -1;
        boolean ok = false;
        try {
            if (fn != null) {
                String ext = FileTool.getFileExtension((String)fn);
                if (ext.length() == 0) {
                    ext = "tmp";
                }
                resf = File.createTempFile("upld", "." + ext);
                os = new FileOutputStream(resf);
            } else {
                bos = new ByteArrayOutputStream(8192);
                os = bos;
            }
            bytesRead = multi.readBodyData(os, this.m_sizeMax);
            os.close();
            os = null;
            ok = true;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception ext) {}
            if (!ok) {
                try {
                    if (resf != null) {
                        resf.delete();
                    }
                }
                catch (Exception ext) {}
            }
        }
        if (bytesRead >= this.m_sizeMax) {
            return false;
        }
        if (bos != null) {
            byte[] data = bos.toByteArray();
            String val = new String(data, charset);
            ui.setValue(val);
        } else {
            ui.setValue(resf);
        }
        l.add(ui);
        return true;
    }
}

