/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import to.etc.log.EtcLoggerFactory;
import to.etc.log.Level;
import to.etc.log.event.EtcLogEvent;

public class EtcLogger
implements Logger {
    @Nonnull
    private final String m_key;
    @Nullable
    private Level m_level;

    private EtcLogger(@Nonnull String key, @Nullable Level level) {
        this.m_key = key;
        this.m_level = level;
    }

    @Nonnull
    static EtcLogger create(@Nonnull String key, @Nullable Level level) {
        return new EtcLogger(key, level);
    }

    private void logEvent(@Nonnull Date date, @Nonnull Level level, @Nullable Marker marker, @Nullable Throwable throwable, @Nonnull String msg, Object ... args) {
        EtcLogEvent event = new EtcLogEvent(this, level, marker, msg, throwable, date, Thread.currentThread(), args);
        EtcLoggerFactory.getSingleton().notifyHandlers(event);
    }

    private synchronized boolean checkEnabled(@Nonnull Level level) {
        return this.m_level != null && this.m_level.includes(level);
    }

    private boolean checkEnabled(@Nonnull Level level, @Nonnull Marker marker) {
        return this.checkEnabled(level);
    }

    private void execute(@Nonnull Level level, @Nullable String arg0) {
        if (this.checkEnabled(level)) {
            this.logEvent(new Date(), level, null, null, arg0, new Object[0]);
        }
    }

    private void execute(@Nonnull Level level, @Nullable String arg0, @Nullable Object arg1) {
        if (this.checkEnabled(level)) {
            this.logEvent(new Date(), level, null, null, arg0, arg1);
        }
    }

    private void execute(@Nonnull Level level, @Nullable String arg0, @Nullable Object[] arg1) {
        if (this.checkEnabled(level)) {
            this.logEvent(new Date(), level, null, null, arg0, arg1);
        }
    }

    private void execute(@Nonnull Level level, @Nullable String arg0, @Nullable Throwable arg1) {
        if (this.checkEnabled(level)) {
            this.logEvent(new Date(), level, null, arg1, arg0, new Object[0]);
        }
    }

    private void execute(@Nonnull Level level, @Nullable String arg0, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.checkEnabled(level)) {
            this.logEvent(new Date(), level, null, null, arg0, arg1, arg2);
        }
    }

    private void execute(@Nonnull Level level, @Nullable Marker arg0, @Nullable String arg1) {
        if (this.checkEnabled(level, arg0)) {
            this.logEvent(new Date(), level, arg0, null, arg1, new Object[0]);
        }
    }

    private void execute(@Nonnull Level level, @Nullable Marker arg0, @Nullable String arg1, @Nullable Object arg2) {
        if (this.checkEnabled(level, arg0)) {
            this.logEvent(new Date(), level, arg0, null, arg1, arg2);
        }
    }

    private void execute(@Nonnull Level level, @Nullable Marker arg0, @Nullable String arg1, @Nullable Object[] arg2) {
        if (this.checkEnabled(level, arg0)) {
            this.logEvent(new Date(), level, arg0, null, arg1, arg2);
        }
    }

    private void execute(@Nonnull Level level, @Nullable Marker arg0, @Nullable String arg1, @Nullable Throwable arg2) {
        if (this.checkEnabled(level, arg0)) {
            this.logEvent(new Date(), level, arg0, arg2, arg1, new Object[0]);
        }
    }

    private void execute(@Nonnull Level level, @Nullable Marker arg0, @Nullable String arg1, @Nullable Object arg2, @Nullable Object arg3) {
        if (this.checkEnabled(level, arg0)) {
            this.logEvent(new Date(), level, arg0, null, arg1, arg2, arg3);
        }
    }

    public void debug(String arg0) {
        this.execute(Level.DEBUG, arg0);
    }

    public void debug(String arg0, Object arg1) {
        this.execute(Level.DEBUG, arg0, arg1);
    }

    public void debug(String arg0, Object[] arg1) {
        this.execute(Level.DEBUG, arg0, arg1);
    }

    public void debug(String arg0, Throwable arg1) {
        this.execute(Level.DEBUG, arg0, arg1);
    }

    public void debug(String arg0, Object arg1, Object arg2) {
        this.execute(Level.DEBUG, arg0, arg1, arg2);
    }

    public void debug(Marker arg0, String arg1) {
        this.execute(Level.DEBUG, arg0, arg1);
    }

    public void debug(Marker arg0, String arg1, Object arg2) {
        this.execute(Level.DEBUG, arg0, arg1, arg2);
    }

    public void debug(Marker arg0, String arg1, Object[] arg2) {
        this.execute(Level.DEBUG, arg0, arg1, arg2);
    }

    public void debug(Marker arg0, String arg1, Throwable arg2) {
        this.execute(Level.DEBUG, arg0, arg1, arg2);
    }

    public void debug(Marker arg0, String arg1, Object arg2, Object arg3) {
        this.execute(Level.DEBUG, arg0, arg1, arg2, arg3);
    }

    public void error(String arg0) {
        this.execute(Level.ERROR, arg0);
    }

    public void error(String arg0, Object arg1) {
        this.execute(Level.ERROR, arg0, arg1);
    }

    public void error(String arg0, Object[] arg1) {
        this.execute(Level.ERROR, arg0, arg1);
    }

    public void error(String arg0, Throwable arg1) {
        this.execute(Level.ERROR, arg0, arg1);
    }

    public void error(Marker arg0, String arg1) {
        this.execute(Level.ERROR, arg0, arg1);
    }

    public void error(String arg0, Object arg1, Object arg2) {
        this.execute(Level.ERROR, arg0, arg1, arg2);
    }

    public void error(Marker arg0, String arg1, Object arg2) {
        this.execute(Level.ERROR, arg0, arg1, arg2);
    }

    public void error(Marker arg0, String arg1, Object[] arg2) {
        this.execute(Level.ERROR, arg0, arg1, arg2);
    }

    public void error(Marker arg0, String arg1, Throwable arg2) {
        this.execute(Level.ERROR, arg0, arg1, arg2);
    }

    public void error(Marker arg0, String arg1, Object arg2, Object arg3) {
        this.execute(Level.ERROR, arg0, arg1, arg2, arg3);
    }

    public String getName() {
        return this.m_key;
    }

    public void info(String arg0) {
        this.execute(Level.INFO, arg0);
    }

    public void info(String arg0, Object arg1) {
        this.execute(Level.INFO, arg0, arg1);
    }

    public void info(String arg0, Object[] arg1) {
        this.execute(Level.INFO, arg0, arg1);
    }

    public void info(String arg0, Throwable arg1) {
        this.execute(Level.INFO, arg0, arg1);
    }

    public void info(Marker arg0, String arg1) {
        this.execute(Level.INFO, arg0, arg1);
    }

    public void info(String arg0, Object arg1, Object arg2) {
        this.execute(Level.INFO, arg0, arg1, arg2);
    }

    public void info(Marker arg0, String arg1, Object arg2) {
        this.execute(Level.INFO, arg0, arg1, arg2);
    }

    public void info(Marker arg0, String arg1, Object[] arg2) {
        this.execute(Level.INFO, arg0, arg1, arg2);
    }

    public void info(Marker arg0, String arg1, Throwable arg2) {
        this.execute(Level.INFO, arg0, arg1, arg2);
    }

    public void info(Marker arg0, String arg1, Object arg2, Object arg3) {
        this.execute(Level.INFO, arg0, arg1, arg2, arg3);
    }

    public boolean isDebugEnabled() {
        return this.checkEnabled(Level.DEBUG);
    }

    public boolean isDebugEnabled(Marker arg0) {
        return this.checkEnabled(Level.DEBUG, arg0);
    }

    public boolean isErrorEnabled() {
        return this.checkEnabled(Level.ERROR);
    }

    public boolean isErrorEnabled(Marker arg0) {
        return this.checkEnabled(Level.ERROR, arg0);
    }

    public boolean isInfoEnabled() {
        return this.checkEnabled(Level.INFO);
    }

    public boolean isInfoEnabled(Marker arg0) {
        return this.checkEnabled(Level.INFO, arg0);
    }

    public boolean isTraceEnabled() {
        return this.checkEnabled(Level.TRACE);
    }

    public boolean isTraceEnabled(Marker arg0) {
        return this.checkEnabled(Level.TRACE, arg0);
    }

    public boolean isWarnEnabled() {
        return this.checkEnabled(Level.WARN);
    }

    public boolean isWarnEnabled(Marker arg0) {
        return this.checkEnabled(Level.WARN, arg0);
    }

    public void trace(String arg0) {
        this.execute(Level.TRACE, arg0);
    }

    public void trace(String arg0, Object arg1) {
        this.execute(Level.TRACE, arg0, arg1);
    }

    public void trace(String arg0, Object[] arg1) {
        this.execute(Level.TRACE, arg0, arg1);
    }

    public void trace(String arg0, Throwable arg1) {
        this.execute(Level.TRACE, arg0, arg1);
    }

    public void trace(Marker arg0, String arg1) {
        this.execute(Level.TRACE, arg0, arg1);
    }

    public void trace(String arg0, Object arg1, Object arg2) {
        this.execute(Level.TRACE, arg0, arg1, arg2);
    }

    public void trace(Marker arg0, String arg1, Object arg2) {
        this.execute(Level.TRACE, arg0, arg1, arg2);
    }

    public void trace(Marker arg0, String arg1, Object[] arg2) {
        this.execute(Level.TRACE, arg0, arg1, arg2);
    }

    public void trace(Marker arg0, String arg1, Throwable arg2) {
        this.execute(Level.TRACE, arg0, arg1, arg2);
    }

    public void trace(Marker arg0, String arg1, Object arg2, Object arg3) {
        this.execute(Level.TRACE, arg0, arg1, arg2, arg3);
    }

    public void warn(String arg0) {
        this.execute(Level.WARN, arg0);
    }

    public void warn(String arg0, Object arg1) {
        this.execute(Level.WARN, arg0, arg1);
    }

    public void warn(String arg0, Object[] arg1) {
        this.execute(Level.WARN, arg0, arg1);
    }

    public void warn(String arg0, Throwable arg1) {
        this.execute(Level.WARN, arg0, arg1);
    }

    public void warn(Marker arg0, String arg1) {
        this.execute(Level.WARN, arg0, arg1);
    }

    public void warn(String arg0, Object arg1, Object arg2) {
        this.execute(Level.WARN, arg0, arg1, arg2);
    }

    public void warn(Marker arg0, String arg1, Object arg2) {
        this.execute(Level.WARN, arg0, arg1, arg2);
    }

    public void warn(Marker arg0, String arg1, Object[] arg2) {
        this.execute(Level.WARN, arg0, arg1, arg2);
    }

    public void warn(Marker arg0, String arg1, Throwable arg2) {
        this.execute(Level.WARN, arg0, arg1, arg2);
    }

    public void warn(Marker arg0, String arg1, Object arg2, Object arg3) {
        this.execute(Level.WARN, arg0, arg1, arg2, arg3);
    }

    synchronized boolean isDisabled() {
        return this.m_level == null;
    }

    public synchronized void setLevel(@Nullable Level level) {
        this.m_level = level;
    }
}

