/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log;

import java.io.File;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.ILoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import to.etc.log.EtcLogger;
import to.etc.log.Level;
import to.etc.log.LogUtil;
import to.etc.log.event.EtcLogEvent;
import to.etc.log.handler.ILogHandler;
import to.etc.log.handler.LogHandlerRegistry;

public class EtcLoggerFactory
implements ILoggerFactory {
    @Nonnull
    private static final EtcLoggerFactory SINGLETON;
    @Nonnull
    private static final ThreadLocal<SimpleDateFormat> DATEFORMATTER;
    @Nullable
    private File m_configDir;
    @Nullable
    private File m_logDir;
    @Nullable
    private String m_logDirOriginalConfigured;
    @Nonnull
    private final Map<String, EtcLogger> LOGGERS = new HashMap<String, EtcLogger>();
    @Nonnull
    private List<ILogHandler> m_handlers = new ArrayList<ILogHandler>();
    @Nonnull
    private Object m_handlersLock = new Object();
    @Nonnull
    private static final Level DEFAULT_LEVEL;
    public static final String CONFIG_FILENAME = "etcLoggerConfig.xml";

    @Nonnull
    public static final EtcLoggerFactory getSingleton() {
        return SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EtcLogger getLogger(@Nonnull String key) {
        EtcLogger logger = null;
        Map<String, EtcLogger> map = this.LOGGERS;
        synchronized (map) {
            logger = this.LOGGERS.get(key);
            if (logger == null) {
                logger = EtcLogger.create(key, this.calcLevel(key));
                this.LOGGERS.put(key, logger);
            }
        }
        return logger;
    }

    @Nullable
    private Level calcLevel(@Nonnull String key) {
        Level current = null;
        for (ILogHandler handler : this.getHandlers()) {
            Level level = handler.listenAt(key);
            if (current != null && (level == null || current.includes(level))) continue;
            current = level;
        }
        return current;
    }

    private synchronized void initializeBuiltInLoggerConfig() {
        try {
            String configXml = LogUtil.readResourceAsString(this.getClass(), CONFIG_FILENAME, "utf-8");
            this.loadConfigFromXml(configXml);
            System.err.println(this.getClass().getName() + " is initialized by loading built-in logger configuration as " + this.getClass().getName() + " resource " + CONFIG_FILENAME);
        }
        catch (Exception e) {
            System.err.println("Built-in logger config is invalid! Check class " + this.getClass().getName() + " resource " + CONFIG_FILENAME);
            e.printStackTrace();
        }
    }

    public synchronized void initialize(@Nonnull File configLocation) throws Exception {
        this.m_configDir = configLocation;
        File conf = new File(configLocation, CONFIG_FILENAME);
        String configXml = null;
        if (conf.exists() && this.tryLoadConfigFromXml(configLocation, configXml = LogUtil.readFileAsString(conf, "utf-8"))) {
            return;
        }
        this.initializeBuiltInLoggerConfig();
    }

    public synchronized boolean tryLoadConfigFromXml(@Nonnull File configLocation, @Nonnull String configXml) {
        this.m_configDir = configLocation;
        try {
            this.loadConfigFromXml(configXml);
            return true;
        }
        catch (Exception ex) {
            System.err.println("Failed logger config load from xml:" + configXml);
            ex.printStackTrace();
            return false;
        }
    }

    public synchronized void initialize(@Nonnull File configLocation, @Nonnull String defaultConfig) throws Exception {
        this.m_configDir = configLocation;
        System.out.println(this.getClass().getName() + " logger configuration location set to " + configLocation.getAbsolutePath());
        File conf = new File(configLocation, CONFIG_FILENAME);
        String configXml = null;
        if (conf.exists() && this.tryLoadConfigFromXml(configLocation, configXml = LogUtil.readFileAsString(conf, "utf-8"))) {
            System.out.println(this.getClass().getName() + " is initialized by loading persisted logger configuration.");
            return;
        }
        if (this.tryLoadConfigFromXml(configLocation, defaultConfig)) {
            System.out.println(this.getClass().getName() + " is initialized by loading application specific default configuration.");
            return;
        }
        this.initializeBuiltInLoggerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadConfigFromXml(@Nonnull String configXml) throws Exception {
        try (StringReader sr = null;){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            sr = new StringReader(configXml);
            Document doc = db.parse(new InputSource(sr));
            this.loadConfig(doc);
        }
    }

    @Nonnull
    private ILogHandler loadHandler(@Nonnull Node handlerNode) throws LoggerConfigException {
        Node typeNode = handlerNode.getAttributes().getNamedItem("type");
        if (typeNode == null) {
            throw new LoggerConfigException("Missing [type] attribute on <handler> element!");
        }
        String val = typeNode.getNodeValue();
        return LogHandlerRegistry.getSingleton().createHandler(val, this.m_logDir, handlerNode);
    }

    public void saveConfig() throws Exception {
        Document doc = null;
        doc = this.toXml(false);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(this.m_configDir, CONFIG_FILENAME));
        transformer.transform(source, result);
    }

    @Nonnull
    public Document toXml(boolean includeNonPerstistable) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element rootElement = doc.createElement("config");
        doc.appendChild(rootElement);
        rootElement.setAttribute("logLocation", this.m_logDirOriginalConfigured);
        for (ILogHandler handler : this.getHandlers()) {
            if (!includeNonPerstistable && handler.isTemporary()) continue;
            Element handlerNode = doc.createElement("handler");
            rootElement.appendChild(handlerNode);
            handler.saveToXml(doc, handlerNode, includeNonPerstistable);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateLoggers() {
        Map<String, EtcLogger> map = this.LOGGERS;
        synchronized (map) {
            for (EtcLogger logger : this.LOGGERS.values()) {
                logger.setLevel(this.calcLevel(logger.getName()));
            }
        }
    }

    @Nonnull
    public String getRootDir() {
        return new File(this.m_configDir, CONFIG_FILENAME).getAbsolutePath();
    }

    @Nonnull
    public String getLogDir() {
        return this.m_logDir.getAbsolutePath();
    }

    @Nonnull
    public String logDirOriginalAsConfigured() {
        return this.m_logDirOriginalConfigured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(@Nonnull Document doc) throws LoggerConfigException {
        String logLocation;
        ArrayList<ILogHandler> loadedHandlers = new ArrayList<ILogHandler>();
        doc.getDocumentElement().normalize();
        NodeList configNodes = doc.getElementsByTagName("config");
        if (configNodes.getLength() == 0) {
            throw new LoggerConfigException("Missing config root node.");
        }
        if (configNodes.getLength() > 1) {
            throw new LoggerConfigException("Multiple config element nodes found.");
        }
        Node val = configNodes.item(0).getAttributes().getNamedItem("logLocation");
        if (val == null) {
            throw new LoggerConfigException("Missing [logLocation] attribute in config root node.");
        }
        this.m_logDirOriginalConfigured = logLocation = val.getNodeValue();
        try {
            boolean checkNext = true;
            do {
                int posEnd;
                checkNext = false;
                int posStart = logLocation.indexOf("%");
                if (posStart <= -1 || (posEnd = logLocation.indexOf("%", posStart + 1)) <= -1) continue;
                String part = System.getProperty(logLocation.substring(posStart + 1, posEnd));
                if (part == null) {
                    throw new Exception("Empty part!");
                }
                logLocation = logLocation.substring(0, posStart) + part + logLocation.substring(posEnd + 1);
                checkNext = true;
            } while (checkNext);
            logLocation = logLocation.replace("/", File.separator);
        }
        catch (Exception ex) {
            System.out.println("Etc logger - problem in resolving logger configuration location from loaded default config: " + this.m_logDirOriginalConfigured + ".\nUsing default location: " + logLocation);
        }
        this.m_logDir = new File(logLocation);
        this.m_logDir.mkdirs();
        NodeList handlerNodes = doc.getElementsByTagName("handler");
        for (int i = 0; i < handlerNodes.getLength(); ++i) {
            Node handlerNode = handlerNodes.item(i);
            loadedHandlers.add(this.loadHandler(handlerNode));
        }
        if (loadedHandlers.isEmpty()) {
            ILogHandler handler = LogHandlerRegistry.getSingleton().createDefaultHandler(this.m_configDir, DEFAULT_LEVEL);
            loadedHandlers.add(handler);
        }
        Object object = this.m_handlersLock;
        synchronized (object) {
            this.m_handlers = loadedHandlers;
        }
        this.recalculateLoggers();
    }

    @Nonnull
    public Level getDefaultLevel() {
        return DEFAULT_LEVEL;
    }

    @Nonnull
    public String composeFullLogFileName(@Nonnull String logPath, @Nonnull String fileName) {
        String res = fileName.contains(":") ? fileName : logPath + File.separator + fileName;
        res = res + "_" + DATEFORMATTER.get().format(new Date()) + ".log";
        return res;
    }

    @Nonnull
    public String composeFullLogFileName(@Nonnull String fileName) {
        return this.composeFullLogFileName(this.m_logDir.getAbsolutePath(), fileName);
    }

    void notifyHandlers(@Nonnull EtcLogEvent event) {
        for (ILogHandler handler : this.getHandlers()) {
            handler.handle(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<ILogHandler> getHandlers() {
        Object object = this.m_handlersLock;
        synchronized (object) {
            return this.m_handlers;
        }
    }

    static {
        DATEFORMATTER = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyMMdd");
            }
        };
        DEFAULT_LEVEL = Level.ERROR;
        SINGLETON = new EtcLoggerFactory();
        SINGLETON.initializeBuiltInLoggerConfig();
    }

    public static class LoggerConfigException
    extends Exception {
        public LoggerConfigException(@Nonnull String msg) {
            super(msg);
        }
    }
}

