/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import javax.annotation.Nonnull;

class LogUtil {
    LogUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static final String readResourceAsString(Class<?> base, String name, String encoding) throws Exception {
        InputStream is = base.getResourceAsStream(name);
        if (null == is) {
            throw new IllegalStateException(base + ":" + name + " resource not found");
        }
        try {
            String string = LogUtil.readStreamAsString(is, encoding);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    static String readStreamAsString(InputStream is, String enc) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        LogUtil.readStreamAsString(sb, is, enc);
        return sb.toString();
    }

    static void readStreamAsString(Appendable o, InputStream f, String enc) throws Exception {
        InputStreamReader r = new InputStreamReader(f, enc);
        LogUtil.readStreamAsString(o, r);
    }

    static void readStreamAsString(Appendable o, Reader r) throws Exception {
        int ct;
        char[] buf = new char[4096];
        while ((ct = r.read(buf)) >= 0) {
            o.append(new String(buf, 0, ct));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readFileAsString(Appendable o, File f) throws Exception {
        try (LineNumberReader lr = new LineNumberReader(new FileReader(f));){
            String line;
            while (null != (line = lr.readLine())) {
                o.append(line);
                o.append("\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFileAsString(File f, String encoding) throws Exception {
        try (FileInputStream is = null;){
            is = new FileInputStream(f);
            String string = LogUtil.readStreamAsString(is, encoding);
            return string;
        }
    }
}

