/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log.handler;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import to.etc.log.event.EtcLogEvent;

public class EtcLogFormatter {
    @Nonnull
    private static final ThreadLocal<SimpleDateFormat> TIMEFORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    @Nonnull
    static String format(@Nonnull EtcLogEvent event, @Nonnull String format, @Nullable String filterData) {
        StringBuilder sb = new StringBuilder();
        int ix = 0;
        int len = format.length();
        while (ix < len) {
            char c;
            if ((c = format.charAt(ix++)) == '%') {
                if (ix + 1 >= len) continue;
                char nextChar = format.charAt(ix++);
                boolean notReplaced = false;
                switch (nextChar) {
                    case 'D': 
                    case 'd': {
                        sb.append(TIMEFORMATTER.get().format(event.getTimestamp()));
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        sb.append(event.getLogger().getName());
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        sb.append("\n");
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        sb.append((Object)event.getLevel());
                        break;
                    }
                    case 'T': 
                    case 't': {
                        sb.append(event.getThread().getName());
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        if (len >= ix + 2 && "msg".equalsIgnoreCase(format.substring(ix - 1, ix + 2))) {
                            ix += 2;
                            EtcLogFormatter.handleMsg(event, sb);
                            break;
                        }
                        if (len >= ix + 2 && "mdc".equalsIgnoreCase(format.substring(ix - 1, ix + 2))) {
                            ix += 2;
                            ix = EtcLogFormatter.handleMdc(format, ix, sb);
                            break;
                        }
                        if (len >= ix + 5 && "marker".equalsIgnoreCase(format.substring(ix - 1, ix + 5))) {
                            ix += 5;
                            Marker marker = event.getMarker();
                            sb.append(marker != null ? marker.getName() : "");
                            break;
                        }
                        sb.append("%").append(nextChar);
                        break;
                    }
                    default: {
                        sb.append("%").append(nextChar);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        Throwable t = event.getThrown();
        if (t != null) {
            sb.append("\n").append("---------- THROWN ---------- " + t.getClass()).append("\n");
            EtcLogFormatter.logThrowable(sb, 0, t, true);
            int loggedCauses = 0;
            while (t.getCause() != null && t != t.getCause()) {
                t = t.getCause();
                sb.append("---------- NESTED CAUSE (" + ++loggedCauses + ") ---------- " + t.getClass()).append("\n");
                EtcLogFormatter.logThrowable(sb, loggedCauses, t, true);
            }
        }
        return sb.toString();
    }

    private static void handleMsg(@Nonnull EtcLogEvent event, @Nonnull StringBuilder sb) {
        Object[] args = event.getArgs();
        if (args != null && args.length > 0) {
            FormattingTuple tuple = args.length == 1 ? MessageFormatter.format((String)event.getMsg(), (Object)args) : (args.length == 2 ? MessageFormatter.format((String)event.getMsg(), (Object)args[0], (Object)args[1]) : MessageFormatter.arrayFormat((String)event.getMsg(), (Object[])args));
            sb.append(tuple.getMessage());
        } else {
            sb.append(event.getMsg());
        }
    }

    private static int handleMdc(@Nonnull String format, int ix, @Nonnull StringBuilder sb) {
        if (format.charAt(ix) != '{') {
            return ix;
        }
        int pos = format.indexOf("}", ix);
        if (pos == -1) {
            return ix;
        }
        String key = format.substring(ix + 1, pos).trim();
        String value = MDC.get((String)key);
        if (value != null) {
            sb.append(value);
        }
        return pos + 1;
    }

    private static void logThrowable(@Nonnull StringBuilder sb, int causeIndex, @Nonnull Throwable t, boolean checkNextExceptions) {
        StackTraceElement[] stacktrace;
        if (t.getMessage() != null) {
            sb.append("- message: ").append(t.getMessage()).append("\n");
        }
        for (StackTraceElement stack : stacktrace = t.getStackTrace()) {
            sb.append("   ").append(stack.toString()).append("\n");
        }
        if (!checkNextExceptions) {
            return;
        }
        if (t instanceof SQLException) {
            int loggedNextExceptions = 0;
            for (SQLException sx = (SQLException)t; sx.getNextException() != null && sx != sx.getNextException(); sx = sx.getNextException()) {
                sb.append("---------- NEXT EXCEPTION (" + ++loggedNextExceptions + ") ---------- " + t.getClass()).append("\n");
                EtcLogFormatter.logThrowable(sb, loggedNextExceptions, sx, false);
            }
        }
    }
}

