/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log.handler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import to.etc.log.EtcLogger;
import to.etc.log.EtcLoggerFactory;
import to.etc.log.Level;
import to.etc.log.event.EtcLogEvent;
import to.etc.log.handler.EtcLogFormat;
import to.etc.log.handler.EtcLogFormatter;
import to.etc.log.handler.ILogHandler;
import to.etc.log.handler.LogFilter;
import to.etc.log.handler.LogFilterType;
import to.etc.log.handler.LogMatcher;

class FileLogHandler
implements ILogHandler {
    @Nullable
    private final String m_out;
    @Nullable
    private final File m_logRoot;
    @Nonnull
    private final List<LogMatcher> m_matchers = new ArrayList<LogMatcher>();
    @Nonnull
    private List<LogFilter> m_filters = Collections.EMPTY_LIST;
    @Nonnull
    private final Map<EtcLogger, Boolean[]> m_loggers = new HashMap<EtcLogger, Boolean[]>();
    @Nonnull
    private final Object m_writeLock = new Object();
    @Nullable
    private EtcLogFormat m_format = null;

    public FileLogHandler(@Nonnull File logRoot, @Nullable String out) {
        this.m_logRoot = logRoot;
        this.m_out = out;
    }

    @Nonnull
    public static FileLogHandler createDefaultHandler(@Nonnull File logRoot, @Nonnull Level level) {
        FileLogHandler handler = new FileLogHandler(logRoot, null);
        LogMatcher matcher = new LogMatcher("", level);
        handler.addMatcher(matcher);
        return handler;
    }

    public void addMatcher(@Nonnull LogMatcher matcher) {
        this.m_matchers.add(matcher);
        this.m_loggers.clear();
    }

    public void addFilter(@Nonnull LogFilter filter) {
        if (this.m_filters == Collections.EMPTY_LIST) {
            this.m_filters = new ArrayList<LogFilter>();
        }
        this.m_filters.add(filter);
    }

    @Override
    public void handle(@Nonnull EtcLogEvent event) {
        Boolean isApplicable;
        Boolean[] applicablePerLevels = this.m_loggers.get(event.getLogger());
        if (null == applicablePerLevels) {
            applicablePerLevels = new Boolean[Level.values().length];
            this.m_loggers.put(event.getLogger(), applicablePerLevels);
        }
        if ((isApplicable = applicablePerLevels[event.getLevel().getCode()]) == null) {
            applicablePerLevels[event.getLevel().getCode()] = isApplicable = this.decideOnMatchers(event);
        }
        if (isApplicable.booleanValue() && this.checkFilters(event)) {
            this.log(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(@Nonnull EtcLogEvent event) {
        String line = EtcLogFormatter.format(event, this.m_format != null ? this.m_format.getFormat() : "%d %p %mdc{loginId}\t%t [%l] %msg", this.getLogPartFromFilters());
        Object object = this.m_writeLock;
        synchronized (object) {
            if (this.m_out == null) {
                System.out.println(line);
            } else {
                BufferedWriter w = null;
                String fileName = null;
                fileName = EtcLoggerFactory.getSingleton().composeFullLogFileName(this.m_logRoot.getAbsolutePath(), this.m_out);
                File outFile = new File(fileName);
                outFile.getParentFile().mkdirs();
                try {
                    outFile.createNewFile();
                    w = new BufferedWriter(new FileWriter(outFile, true));
                    w.write(line);
                    w.newLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    if (w != null) {
                        try {
                            w.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    private String getLogPartFromFilters() {
        if (this.m_filters.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (LogFilter filter : this.m_filters) {
            sb.append("[").append(filter.getKey()).append("=").append(filter.getValue()).append("]");
        }
        return sb.toString();
    }

    @Nonnull
    private Boolean decideOnMatchers(@Nonnull EtcLogEvent event) {
        LogMatcher closest = null;
        for (LogMatcher matcher : this.m_matchers) {
            if (!matcher.matches(event) || closest != null && !matcher.isSubmatcherOf(closest)) continue;
            closest = matcher;
        }
        if (closest != null && closest.getLevel().includes(event.getLevel())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean checkFilters(@Nonnull EtcLogEvent event) {
        for (LogFilter filter : this.m_filters) {
            if (filter.accept(event)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public File getLogRoot() {
        return this.m_logRoot;
    }

    @Override
    @Nullable
    public Level listenAt(@Nonnull String key) {
        LogMatcher closest = null;
        for (LogMatcher matcher : this.m_matchers) {
            if (!matcher.matchesName(key) || closest != null && !matcher.isSubmatcherOf(closest)) continue;
            closest = matcher;
        }
        return closest != null ? closest.getLevel() : null;
    }

    @Nonnull
    public static FileLogHandler createFromFileTypeConfig(@Nonnull File logRoot, @Nonnull Node handlerNode) throws EtcLoggerFactory.LoggerConfigException {
        Node file = handlerNode.getAttributes().getNamedItem("file");
        if (file == null) {
            throw new EtcLoggerFactory.LoggerConfigException("Missing file attribute inside file type handler.");
        }
        FileLogHandler res = new FileLogHandler(logRoot, file.getNodeValue());
        res.load(handlerNode);
        return res;
    }

    void load(@Nonnull Node handlerNode) throws EtcLoggerFactory.LoggerConfigException {
        NodeList nodes = handlerNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if ("log".equals(node.getNodeName())) {
                this.addMatcher(LogMatcher.createFromXml(node));
                continue;
            }
            if ("filter".equals(node.getNodeName())) {
                this.addFilter(LogFilter.createFromXml(node));
                continue;
            }
            if (!"format".equals(node.getNodeName())) continue;
            this.addFormat(EtcLogFormat.createFromXml(node));
        }
    }

    private void addFormat(@Nonnull EtcLogFormat format) throws EtcLoggerFactory.LoggerConfigException {
        if (this.m_format != null) {
            throw new EtcLoggerFactory.LoggerConfigException("Multiple format definitions found in log handler.");
        }
        this.m_format = format;
    }

    @Nonnull
    public static FileLogHandler createFromStdoutTypeConfig(@Nonnull File logRoot, @Nonnull Node handlerNode) throws EtcLoggerFactory.LoggerConfigException {
        FileLogHandler res = new FileLogHandler(logRoot, null);
        res.load(handlerNode);
        return res;
    }

    @Override
    public void saveToXml(@Nonnull Document doc, @Nonnull Element handlerNode, boolean includeNonPerstistable) {
        handlerNode.setAttribute("type", this.m_out == null ? "stdout" : "file");
        if (this.m_out != null) {
            handlerNode.setAttribute("file", this.m_out);
        }
        if (this.m_format != null) {
            Element formatNode = doc.createElement("format");
            handlerNode.appendChild(formatNode);
            this.m_format.saveToXml(doc, formatNode);
        }
        for (LogMatcher matcher : this.m_matchers) {
            Element logNode = doc.createElement("log");
            handlerNode.appendChild(logNode);
            matcher.saveToXml(doc, logNode);
        }
        for (LogFilter filter : this.m_filters) {
            if (!includeNonPerstistable && !filter.getType().isPersistable()) continue;
            Element filterNode = doc.createElement("filter");
            handlerNode.appendChild(filterNode);
            filter.saveToXml(doc, filterNode);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("handler ").append(this.m_out != null ? "file: " + this.m_out : "stdout");
        if (!this.m_matchers.isEmpty()) {
            sb.append("\nmatchers: ");
            for (LogMatcher matcher : this.m_matchers) {
                sb.append("[").append(matcher.toString()).append("]");
            }
        }
        if (!this.m_filters.isEmpty()) {
            sb.append("\nfilters: ");
            for (LogFilter filter : this.m_filters) {
                sb.append("[").append(filter.toString()).append("]");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isTemporary() {
        for (LogFilter filter : this.m_filters) {
            if (filter.getType() != LogFilterType.SESSION) continue;
            return true;
        }
        return false;
    }
}

