/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.MDC;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import to.etc.log.EtcLoggerFactory;
import to.etc.log.event.EtcLogEvent;
import to.etc.log.handler.LogFilterType;

class LogFilter {
    @Nonnull
    private final LogFilterType m_type;
    @Nonnull
    private final String m_key;
    @Nonnull
    private final String m_value;

    private LogFilter(@Nonnull LogFilterType type, @Nonnull String key, @Nonnull String value) {
        this.m_type = type;
        this.m_key = key;
        this.m_value = value;
    }

    @Nonnull
    LogFilterType getType() {
        return this.m_type;
    }

    @Nullable
    String getKey() {
        return this.m_key;
    }

    @Nullable
    String getValue() {
        return this.m_value;
    }

    @Nonnull
    static LogFilter mdcFilter(@Nonnull String key, @Nonnull String value) {
        return new LogFilter(LogFilterType.MDC, key, value);
    }

    @Nonnull
    static LogFilter sessionFilter(@Nonnull String value) {
        return new LogFilter(LogFilterType.SESSION, "session", value);
    }

    boolean accept(@Nonnull EtcLogEvent event) {
        switch (this.m_type) {
            case SESSION: 
            case MDC: {
                String val = MDC.get((String)this.m_key);
                return this.m_value.equalsIgnoreCase(val);
            }
        }
        throw new IllegalStateException("Filter of unknown type: " + (Object)((Object)this.m_type));
    }

    @Nonnull
    static LogFilter createFromXml(@Nonnull Node node) throws EtcLoggerFactory.LoggerConfigException {
        Node typeNode = node.getAttributes().getNamedItem("type");
        if (typeNode == null) {
            throw new EtcLoggerFactory.LoggerConfigException("Missing [type] at filter node.");
        }
        LogFilterType type = LogFilterType.valueOf(typeNode.getNodeValue().toUpperCase());
        String key = null;
        if (type == LogFilterType.MDC) {
            Node keyNode = node.getAttributes().getNamedItem("key");
            if (keyNode == null) {
                throw new EtcLoggerFactory.LoggerConfigException("Missing [key] at filter node of type=\"mdc\".");
            }
            key = keyNode.getNodeValue();
        } else if (type == LogFilterType.SESSION) {
            key = "session";
        } else {
            throw new EtcLoggerFactory.LoggerConfigException("Non supported filter node of type=\"" + (Object)((Object)type) + "\".");
        }
        Node valNode = node.getAttributes().getNamedItem("value");
        if (valNode == null) {
            throw new EtcLoggerFactory.LoggerConfigException("Missing [value] at filter node.");
        }
        String value = valNode.getNodeValue();
        return new LogFilter(type, key, value);
    }

    void saveToXml(@Nonnull Document doc, @Nonnull Element filterNode) {
        filterNode.setAttribute("type", this.m_type.name());
        filterNode.setAttribute("key", this.m_key);
        filterNode.setAttribute("value", this.m_value);
    }

    public String toString() {
        return "filter " + (Object)((Object)this.m_type) + " [" + this.m_key + "=" + this.m_value + "]";
    }
}

