/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log.handler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import to.etc.log.EtcLoggerFactory;
import to.etc.log.Level;
import to.etc.log.handler.FileLogHandler;
import to.etc.log.handler.ILogHandler;

public class LogHandlerRegistry {
    @Nonnull
    private final Map<String, ILogHandlerFactory> m_makerRegistry = new HashMap<String, ILogHandlerFactory>();
    @Nonnull
    private static final LogHandlerRegistry SINGLETON = new LogHandlerRegistry();

    @Nonnull
    public static final LogHandlerRegistry getSingleton() {
        return SINGLETON;
    }

    public synchronized void register(@Nonnull String type, @Nonnull ILogHandlerFactory handlerFactory) {
        this.m_makerRegistry.put(type, handlerFactory);
    }

    @Nonnull
    public synchronized ILogHandler createHandler(@Nonnull String type, @Nonnull File logDir, @Nonnull Node handlerNode) throws EtcLoggerFactory.LoggerConfigException {
        ILogHandlerFactory maker = this.m_makerRegistry.get(type);
        if (maker != null) {
            return maker.createInstance(logDir, handlerNode);
        }
        throw new EtcLoggerFactory.LoggerConfigException("Unknown handler type found: " + type);
    }

    @Nonnull
    public ILogHandler createDefaultHandler(@Nonnull File rootDir, @Nonnull Level level) {
        return FileLogHandler.createDefaultHandler(rootDir, level);
    }

    static {
        SINGLETON.register("stdout", new ILogHandlerFactory(){

            @Override
            public ILogHandler createInstance(@Nonnull File logDir, @Nonnull Node handlerNode) throws EtcLoggerFactory.LoggerConfigException {
                return FileLogHandler.createFromStdoutTypeConfig(logDir, handlerNode);
            }
        });
        SINGLETON.register("file", new ILogHandlerFactory(){

            @Override
            public ILogHandler createInstance(@Nonnull File logDir, @Nonnull Node handlerNode) throws EtcLoggerFactory.LoggerConfigException {
                return FileLogHandler.createFromFileTypeConfig(logDir, handlerNode);
            }
        });
    }

    public static interface ILogHandlerFactory {
        @Nonnull
        public ILogHandler createInstance(@Nonnull File var1, @Nonnull Node var2) throws EtcLoggerFactory.LoggerConfigException;
    }
}

