/*
 * Decompiled with CFR 0.152.
 */
package to.etc.log.handler;

import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import to.etc.log.EtcLoggerFactory;
import to.etc.log.Level;
import to.etc.log.event.EtcLogEvent;

class LogMatcher {
    @Nonnull
    private final String m_name;
    @Nonnull
    private final Level m_level;

    LogMatcher(@Nonnull String name, @Nonnull Level level) {
        this.m_name = name;
        this.m_level = level;
    }

    @Nonnull
    String getName() {
        return this.m_name;
    }

    @Nonnull
    Level getLevel() {
        return this.m_level;
    }

    boolean matches(@Nonnull EtcLogEvent event) {
        return this.matchesName(event.getLogger().getName()) && this.m_level.includes(event.getLevel());
    }

    boolean isSubmatcherOf(@Nonnull LogMatcher other) {
        if (this.m_name.length() == 0) {
            return false;
        }
        if (other.getName().length() == 0) {
            return true;
        }
        return this.m_name.startsWith(other.getName() + ".");
    }

    boolean matchesName(@Nonnull String key) {
        return this.m_name.length() == 0 || key.startsWith(this.m_name + ".") || key.equals(this.m_name);
    }

    @Nonnull
    static LogMatcher createFromXml(@Nonnull Node node) throws EtcLoggerFactory.LoggerConfigException {
        Node nameNode = node.getAttributes().getNamedItem("name");
        String name = nameNode == null ? "" : nameNode.getNodeValue();
        Node levelNode = node.getAttributes().getNamedItem("level");
        if (levelNode == null) {
            throw new EtcLoggerFactory.LoggerConfigException("Missing [level] at log node.");
        }
        Level level = Level.valueOf(levelNode.getNodeValue().toUpperCase());
        return new LogMatcher(name, level);
    }

    public void saveToXml(@Nonnull Document doc, @Nonnull Element logNode) {
        logNode.setAttribute("name", this.m_name);
        logNode.setAttribute("level", this.m_level.name());
    }

    public String toString() {
        return "matcher " + this.m_name + " " + (Object)((Object)this.m_level);
    }
}

