/*
 * Decompiled with CFR 0.152.
 */
package to.etc.syntaxer;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.text.Segment;
import to.etc.syntaxer.HtmlColorizer;
import to.etc.syntaxer.TokenMarker;
import to.etc.syntaxer.XModeHandler;
import to.etc.syntaxer.XmlParser;
import to.etc.util.FileTool;
import to.etc.util.WrappedException;

public class Colorizer {
    private static Map<String, Mode> m_modeMap = new HashMap<String, Mode>();
    private static Map<String, String> m_extMap = new HashMap<String, String>();

    private static void p(String a, String ... suf) {
        for (String s : suf) {
            m_extMap.put(s, a);
        }
    }

    private static Mode findMode(String name) {
        return m_modeMap.get(name.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Mode getMode(String name) throws Exception {
        Mode m = Colorizer.findMode(name);
        if (m != null) {
            return m;
        }
        System.out.println("Trying to load mode " + name);
        m = new Mode(name);
        InputStream is = Colorizer.class.getResourceAsStream("/modes/" + name.toLowerCase() + ".xml");
        if (is == null) {
            System.out.println("Missing resource for mode=" + name);
            return Colorizer.getMode("text");
        }
        try {
            InputStreamReader r = new InputStreamReader(is);
            XModeHandler mh = new XModeHandler(name){

                @Override
                protected void error(String msg, Object subst) {
                    System.out.println("error: " + msg + ", " + subst);
                }

                @Override
                protected TokenMarker getTokenMarker(String mode) {
                    try {
                        Mode md = Colorizer.getMode(mode);
                        return md == null ? null : md.getTokenMarker();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        throw new WrappedException((Throwable)x);
                    }
                }
            };
            m_modeMap.put(name.toLowerCase(), m);
            XmlParser xp = new XmlParser();
            xp.setHandler(mh);
            m.setTokenMarker(mh.getTokenMarker());
            xp.parse(null, null, r);
            m.setProperties(mh.getModeProperties());
            Mode mode = m;
            return mode;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Mode getModeForExtension(String ext) throws Exception {
        String s = m_extMap.get(ext.trim().toLowerCase());
        return Colorizer.getMode(s == null ? ext : s);
    }

    public void colorize(String text, String mode, int tabsize, Appendable a) throws Exception {
        Mode m = Colorizer.getMode(mode);
        char[] ch = text.toCharArray();
        TokenMarker tm = m.getTokenMarker();
        HtmlColorizer th = new HtmlColorizer(a, tabsize);
        Segment s = new Segment(ch, 0, 0);
        int len = ch.length;
        int off = 0;
        TokenMarker.LineContext lc = null;
        while (off < len) {
            int pos;
            for (pos = off; pos < len && ch[pos] != '\n'; ++pos) {
            }
            int eol = pos;
            if (eol > off && ch[eol - 1] == '\r') {
                --eol;
            }
            s.offset = off;
            s.count = eol - off;
            lc = tm.markTokens(lc, th, s);
            off = pos + 1;
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("Starting");
            Colorizer c = new Colorizer();
            StringBuilder sb = new StringBuilder(8192);
            c.colorize(FileTool.readFileAsString((File)new File("/home/jal/wsplanner/navi.web/WebContent/manual/CalendarPartGenerator.java")), "java", 4, sb);
            System.out.println("HTML:\n" + sb.toString());
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static {
        Colorizer.p("antlr", "g");
        Colorizer.p("asp", "asp");
        Colorizer.p("assembly-x86", "x86", "masm");
        Colorizer.p("awk", "awk");
        Colorizer.p("batch", "bat", "cmd");
        Colorizer.p("bcel", "bcel");
        Colorizer.p("css", "css");
        Colorizer.p("hex", "hex");
        Colorizer.p("html", "html", "htm");
        Colorizer.p("ini", "ini");
        Colorizer.p("jsp", "jsp", "jspx", "inc");
        Colorizer.p("patch", "patch", "diff");
        Colorizer.p("php", "php");
        Colorizer.p("postscript", "ps");
        Colorizer.p("python", "py");
        Colorizer.p("relax-ng", "rng");
        Colorizer.p("sh", "shellscript");
        Colorizer.p("xsl", "xsl");
        Colorizer.p("c", "c");
        Colorizer.p("csharp", "cs", "c#");
        Colorizer.p("cobol", "cob", "cbl");
        Colorizer.p("java", "java");
        Colorizer.p("javascript", "js");
        Colorizer.p("pl-sql", "plb", "plc", "pck", "dbs", "trg", "vw");
        Colorizer.p("tsql", "sql");
        Colorizer.p("xml", "tld", "xml", "classpath", "project", "component", "settings", "xhtml");
        Colorizer.p("props", "prefs", "properties");
    }

    public static class Mode {
        private TokenMarker m_tokenMarker;
        private String m_name;
        private Hashtable m_properties;

        public Hashtable getProperties() {
            return this.m_properties;
        }

        public void setProperties(Hashtable properties) {
            this.m_properties = properties;
        }

        public Mode(String name) {
            this.m_name = name;
        }

        public TokenMarker getTokenMarker() {
            return this.m_tokenMarker;
        }

        public void setTokenMarker(TokenMarker tokenMarker) {
            this.m_tokenMarker = tokenMarker;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

