/*
 * Decompiled with CFR 0.152.
 */
package to.etc.syntaxer;

import java.util.Vector;
import javax.swing.text.Segment;
import to.etc.syntaxer.SyntaxUtilities;

public class KeywordMap {
    private int m_mapLength;
    private Keyword[] m_map;
    private boolean m_ignoreCase;
    private StringBuffer m_noWordSep;

    public KeywordMap(boolean ignoreCase) {
        this(ignoreCase, 52);
        this.m_ignoreCase = ignoreCase;
        this.m_noWordSep = new StringBuffer();
    }

    public KeywordMap(boolean ignoreCase, int mapLength) {
        this.m_mapLength = mapLength;
        this.m_ignoreCase = ignoreCase;
        this.m_map = new Keyword[mapLength];
    }

    public byte lookup(Segment text, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        Keyword k = this.m_map[this.getSegmentMapKey(text, offset, length)];
        while (k != null) {
            if (length != k.keyword.length) {
                k = k.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.m_ignoreCase, text, offset, k.keyword)) {
                return k.id;
            }
            k = k.next;
        }
        return 0;
    }

    public void add(String keyword, byte id) {
        this.add(keyword.toCharArray(), id);
    }

    public void add(char[] keyword, byte id) {
        int key = this.getStringMapKey(keyword);
        block0: for (int i = 0; i < keyword.length; ++i) {
            char ch = keyword[i];
            if (Character.isLetterOrDigit(ch)) continue;
            for (int j = 0; j < this.m_noWordSep.length(); ++j) {
                if (this.m_noWordSep.charAt(j) == ch) continue block0;
            }
            this.m_noWordSep.append(ch);
        }
        this.m_map[key] = new Keyword(keyword, id, this.m_map[key]);
    }

    public String getNonAlphaNumericChars() {
        return this.m_noWordSep.toString();
    }

    public String[] getKeywords() {
        Vector<String> vector = new Vector<String>(100);
        for (int i = 0; i < this.m_map.length; ++i) {
            Keyword keyword = this.m_map[i];
            while (keyword != null) {
                vector.addElement(new String(keyword.keyword));
                keyword = keyword.next;
            }
        }
        Object[] retVal = new String[vector.size()];
        vector.copyInto(retVal);
        return retVal;
    }

    public boolean getIgnoreCase() {
        return this.m_ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.m_ignoreCase = ignoreCase;
    }

    public void add(KeywordMap map) {
        for (int i = 0; i < map.m_map.length; ++i) {
            Keyword k = map.m_map[i];
            while (k != null) {
                this.add(k.keyword, k.id);
                k = k.next;
            }
        }
    }

    private int getStringMapKey(char[] s) {
        return (Character.toUpperCase(s[0]) + Character.toUpperCase(s[s.length - 1])) % this.m_mapLength;
    }

    protected int getSegmentMapKey(Segment s, int off, int len) {
        return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % this.m_mapLength;
    }

    class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        public Keyword(char[] keyword, byte id, Keyword next) {
            this.keyword = keyword;
            this.id = id;
            this.next = next;
        }
    }
}

