/*
 * Decompiled with CFR 0.152.
 */
package to.etc.syntaxer;

import gnu.regexp.RE;
import java.util.Hashtable;
import java.util.LinkedList;
import to.etc.syntaxer.KeywordMap;
import to.etc.syntaxer.ParserRule;

public class ParserRuleSet {
    private static ParserRuleSet[] standard = new ParserRuleSet[19];
    private static final int RULE_BUCKET_COUNT = 128;
    private String modeName;
    private String setName;
    private Hashtable props;
    private KeywordMap keywords;
    private int ruleCount;
    private ParserRule[] ruleMapFirst;
    private ParserRule[] ruleMapLast;
    private LinkedList imports;
    private int terminateChar = -1;
    private boolean ignoreCase = true;
    private byte defaultToken;
    private ParserRule escapeRule;
    private boolean highlightDigits;
    private RE digitRE;
    private String _noWordSep;
    private String noWordSep;
    private boolean builtIn;

    public static ParserRuleSet getStandardRuleSet(byte id) {
        return standard[id];
    }

    public ParserRuleSet(String modeName, String setName) {
        this.modeName = modeName;
        this.setName = setName;
        this.ruleMapFirst = new ParserRule[128];
        this.ruleMapLast = new ParserRule[128];
        this.imports = new LinkedList();
    }

    public String getModeName() {
        return this.modeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public String getName() {
        return this.modeName + "::" + this.setName;
    }

    public Hashtable getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable props) {
        this.props = props;
        this._noWordSep = null;
    }

    public void resolveImports() {
        for (ParserRuleSet ruleset : this.imports) {
            for (int i = 0; i < ruleset.ruleMapFirst.length; ++i) {
                ParserRule rule = ruleset.ruleMapFirst[i];
                while (rule != null) {
                    this.addRule(rule);
                    rule = rule.next;
                }
            }
            if (ruleset.keywords == null) continue;
            if (this.keywords == null) {
                this.keywords = new KeywordMap(this.ignoreCase);
            }
            this.keywords.add(ruleset.keywords);
        }
        this.imports.clear();
    }

    public void addRuleSet(ParserRuleSet ruleset) {
        this.imports.add(ruleset);
    }

    public void addRule(ParserRule r) {
        ++this.ruleCount;
        int key = Character.toUpperCase(r.hashChar) % 128;
        ParserRule last = this.ruleMapLast[key];
        if (last == null) {
            this.ruleMapFirst[key] = this.ruleMapLast[key] = r;
        } else {
            last.next = r;
            this.ruleMapLast[key] = r;
        }
    }

    public ParserRule getRules(char ch) {
        int key = Character.toUpperCase(ch) % 128;
        return this.ruleMapFirst[key];
    }

    public int getRuleCount() {
        return this.ruleCount;
    }

    public int getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(int atChar) {
        this.terminateChar = atChar >= 0 ? atChar : -1;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public KeywordMap getKeywords() {
        return this.keywords;
    }

    public void setKeywords(KeywordMap km) {
        this.keywords = km;
        this._noWordSep = null;
    }

    public boolean getHighlightDigits() {
        return this.highlightDigits;
    }

    public void setHighlightDigits(boolean highlightDigits) {
        this.highlightDigits = highlightDigits;
    }

    public RE getDigitRegexp() {
        return this.digitRE;
    }

    public void setDigitRegexp(RE digitRE) {
        this.digitRE = digitRE;
    }

    public ParserRule getEscapeRule() {
        return this.escapeRule;
    }

    public void setEscapeRule(ParserRule escapeRule) {
        this.addRule(escapeRule);
        this.escapeRule = escapeRule;
    }

    public byte getDefault() {
        return this.defaultToken;
    }

    public void setDefault(byte def) {
        this.defaultToken = def;
    }

    public String getNoWordSep() {
        if (this._noWordSep == null) {
            this._noWordSep = this.noWordSep;
            if (this.noWordSep == null) {
                this.noWordSep = "";
            }
            if (this.keywords != null) {
                this.noWordSep = this.noWordSep + this.keywords.getNonAlphaNumericChars();
            }
        }
        return this.noWordSep;
    }

    public void setNoWordSep(String noWordSep) {
        this.noWordSep = noWordSep;
        this._noWordSep = null;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.modeName + "::" + this.setName + "]";
    }

    static {
        for (byte i = 0; i < standard.length; i = (byte)(i + 1)) {
            ParserRuleSet.standard[i] = new ParserRuleSet(null, null);
            standard[i].setDefault(i);
            ParserRuleSet.standard[i].builtIn = true;
        }
    }
}

