/*
 * Decompiled with CFR 0.152.
 */
package to.etc.syntaxer;

import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.util.Hashtable;
import javax.swing.text.Segment;
import to.etc.syntaxer.CharIndexedSegment;
import to.etc.syntaxer.KeywordMap;
import to.etc.syntaxer.ParserRule;
import to.etc.syntaxer.ParserRuleSet;
import to.etc.syntaxer.SyntaxUtilities;
import to.etc.syntaxer.TokenHandler;

public class TokenMarker {
    private Hashtable m_ruleSets;
    private ParserRuleSet m_mainRuleSet;
    private TokenHandler m_tokenHandler;
    private Segment m_line;
    private LineContext m_context;
    private KeywordMap m_keywords;
    private Segment m_pattern = new Segment();
    private int m_lastOffset;
    private int m_lineLength;
    private int m_pos;
    private boolean m_escaped;
    private int m_whitespaceEnd;
    private boolean m_seenWhitespaceEnd;

    public TokenMarker() {
        this.m_ruleSets = new Hashtable(64);
    }

    public void addRuleSet(ParserRuleSet rules) {
        this.m_ruleSets.put(rules.getSetName(), rules);
        if (rules.getSetName().equals("MAIN")) {
            this.m_mainRuleSet = rules;
        }
    }

    public ParserRuleSet getMainRuleSet() {
        return this.m_mainRuleSet;
    }

    public ParserRuleSet getRuleSet(String setName) {
        return (ParserRuleSet)this.m_ruleSets.get(setName);
    }

    public ParserRuleSet[] getRuleSets() {
        return this.m_ruleSets.values().toArray(new ParserRuleSet[this.m_ruleSets.size()]);
    }

    public LineContext markTokens(LineContext prevContext, TokenHandler tokenHandler, Segment line) {
        ParserRule rule;
        this.m_tokenHandler = tokenHandler;
        this.m_line = line;
        this.m_lastOffset = line.offset;
        this.m_lineLength = line.count + line.offset;
        this.m_context = new LineContext();
        if (prevContext == null) {
            this.m_context.rules = this.getMainRuleSet();
            if (this.m_context.rules == null) {
                throw new IllegalStateException("No context rules??");
            }
        } else {
            this.m_context.parent = prevContext.parent;
            this.m_context.inRule = prevContext.inRule;
            this.m_context.rules = prevContext.rules;
            this.m_context.spanEndSubst = prevContext.spanEndSubst;
        }
        this.m_keywords = this.m_context.rules.getKeywords();
        this.m_escaped = false;
        this.m_seenWhitespaceEnd = false;
        this.m_whitespaceEnd = line.offset;
        int terminateChar = this.m_context.rules.getTerminateChar();
        boolean terminated = false;
        this.m_pos = line.offset;
        while (this.m_pos < this.m_lineLength) {
            block19: {
                if (terminateChar >= 0 && this.m_pos - line.offset >= terminateChar && !terminated) {
                    terminated = true;
                    this.m_context = new LineContext(ParserRuleSet.getStandardRuleSet(this.m_context.rules.getDefault()), this.m_context);
                    this.m_keywords = this.m_context.rules.getKeywords();
                }
                if (this.m_context.parent != null && (rule = this.m_context.parent.inRule) != null && this.checkDelegateEnd(rule)) {
                    this.m_seenWhitespaceEnd = true;
                } else {
                    char ch = line.array[this.m_pos];
                    rule = this.m_context.rules.getRules(ch);
                    while (rule != null) {
                        if (this.handleRule(rule, false)) {
                            this.m_seenWhitespaceEnd = true;
                            break block19;
                        }
                        rule = rule.next;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (!this.m_seenWhitespaceEnd) {
                            this.m_whitespaceEnd = this.m_pos + 1;
                        }
                        if (this.m_context.inRule != null) {
                            this.handleRule(this.m_context.inRule, true);
                        }
                        this.handleNoWordBreak();
                        this.markKeyword(false);
                        if (this.m_lastOffset != this.m_pos) {
                            tokenHandler.handleToken(line, this.m_context.rules.getDefault(), this.m_lastOffset - line.offset, this.m_pos - this.m_lastOffset, this.m_context);
                        }
                        tokenHandler.handleToken(line, this.m_context.rules.getDefault(), this.m_pos - line.offset, 1, this.m_context);
                        this.m_lastOffset = this.m_pos + 1;
                        this.m_escaped = false;
                    } else {
                        if (this.m_keywords != null || this.m_context.rules.getRuleCount() != 0) {
                            String noWordSep = this.m_context.rules.getNoWordSep();
                            if (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) {
                                if (this.m_context.inRule != null) {
                                    this.handleRule(this.m_context.inRule, true);
                                }
                                this.handleNoWordBreak();
                                this.markKeyword(true);
                                tokenHandler.handleToken(line, this.m_context.rules.getDefault(), this.m_lastOffset - line.offset, 1, this.m_context);
                                this.m_lastOffset = this.m_pos + 1;
                            }
                        }
                        this.m_seenWhitespaceEnd = true;
                        this.m_escaped = false;
                    }
                }
            }
            ++this.m_pos;
        }
        this.m_pos = this.m_lineLength;
        if (this.m_context.inRule != null) {
            this.handleRule(this.m_context.inRule, true);
        }
        this.handleNoWordBreak();
        this.markKeyword(true);
        while (this.m_context.parent != null && ((rule = this.m_context.parent.inRule) != null && (rule.action & 0x200) == 512 || terminated)) {
            this.m_context = this.m_context.parent;
            this.m_keywords = this.m_context.rules.getKeywords();
            this.m_context.inRule = null;
        }
        tokenHandler.handleToken(line, (byte)127, this.m_pos - line.offset, 0, this.m_context);
        this.m_context = this.m_context.intern();
        tokenHandler.setLineContext(this.m_context);
        return this.m_context;
    }

    private boolean checkDelegateEnd(ParserRule rule) {
        ParserRule escape;
        if (rule.end == null) {
            return false;
        }
        LineContext tempContext = this.m_context;
        this.m_context = this.m_context.parent;
        this.m_keywords = this.m_context.rules.getKeywords();
        boolean tempEscaped = this.m_escaped;
        boolean b = this.handleRule(rule, true);
        this.m_context = tempContext;
        this.m_keywords = this.m_context.rules.getKeywords();
        if (b && !tempEscaped) {
            if (this.m_context.inRule != null) {
                this.handleRule(this.m_context.inRule, true);
            }
            this.markKeyword(true);
            this.m_context = (LineContext)this.m_context.parent.clone();
            this.m_tokenHandler.handleToken(this.m_line, (this.m_context.inRule.action & 0x100) == 256 ? this.m_context.rules.getDefault() : this.m_context.inRule.token, this.m_pos - this.m_line.offset, this.m_pattern.count, this.m_context);
            this.m_keywords = this.m_context.rules.getKeywords();
            this.m_context.inRule = null;
            this.m_lastOffset = this.m_pos + this.m_pattern.count;
            this.m_pos += this.m_pattern.count - 1;
            return true;
        }
        return (rule.action & 0x1000) == 0 && (escape = this.m_context.parent.rules.getEscapeRule()) != null && this.handleRule(escape, false);
    }

    private boolean handleRule(ParserRule checkRule, boolean end) {
        int posMatch;
        if (!end && Character.toUpperCase(checkRule.hashChar) != Character.toUpperCase(this.m_line.array[this.m_pos])) {
            return false;
        }
        int offset = (checkRule.action & 4) != 0 ? this.m_lastOffset : this.m_pos;
        int n = posMatch = end ? checkRule.endPosMatch : checkRule.startPosMatch;
        if ((posMatch & 2) == 2 ? offset != this.m_line.offset : ((posMatch & 4) == 4 ? offset != this.m_whitespaceEnd : (posMatch & 8) == 8 && offset != this.m_lastOffset)) {
            return false;
        }
        int matchedChars = 1;
        CharIndexedSegment charIndexed = null;
        REMatch match = null;
        if (!end || (checkRule.action & 8) == 0) {
            if ((checkRule.action & 0x2000) == 0 || end) {
                this.m_pattern.array = end ? (this.m_context.spanEndSubst != null ? this.m_context.spanEndSubst : checkRule.end) : checkRule.start;
                this.m_pattern.offset = 0;
                matchedChars = this.m_pattern.count = this.m_pattern.array.length;
                if (!SyntaxUtilities.regionMatches(this.m_context.rules.getIgnoreCase(), this.m_line, this.m_pos, this.m_pattern.array)) {
                    return false;
                }
            } else {
                int matchStart = this.m_pos - this.m_line.offset;
                charIndexed = new CharIndexedSegment(this.m_line, matchStart);
                match = checkRule.startRegexp.getMatch((Object)charIndexed, 0, 64);
                if (match == null) {
                    return false;
                }
                if (match.getStartIndex() != 0) {
                    throw new InternalError("Can't happen");
                }
                matchedChars = match.getEndIndex();
                if (matchedChars == 0) {
                    matchedChars = 1;
                }
            }
        }
        if ((checkRule.action & 0x800) == 2048) {
            if (this.m_context.inRule != null) {
                this.handleRule(this.m_context.inRule, true);
            }
            this.m_escaped = !this.m_escaped;
            this.m_pos += this.m_pattern.count - 1;
        } else if (this.m_escaped) {
            this.m_escaped = false;
            this.m_pos += this.m_pattern.count - 1;
        } else if (!end) {
            if (this.m_context.inRule != null) {
                this.handleRule(this.m_context.inRule, true);
            }
            this.markKeyword((checkRule.action & 4) != 4);
            switch (checkRule.action & 0xFF) {
                case 0: {
                    this.m_context.spanEndSubst = null;
                    if ((checkRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.m_tokenHandler, checkRule.token, this.m_pos - this.m_line.offset, matchedChars, this.m_context);
                    } else {
                        this.m_tokenHandler.handleToken(this.m_line, checkRule.token, this.m_pos - this.m_line.offset, matchedChars, this.m_context);
                    }
                    if (checkRule.delegate == null) break;
                    this.m_context = new LineContext(checkRule.delegate, this.m_context.parent);
                    this.m_keywords = this.m_context.rules.getKeywords();
                    break;
                }
                case 2: 
                case 16: {
                    byte tokenType;
                    this.m_context.inRule = checkRule;
                    byte by = tokenType = (checkRule.action & 0x100) == 256 ? this.m_context.rules.getDefault() : checkRule.token;
                    if ((checkRule.action & 0x2000) != 0) {
                        this.handleTokenWithSpaces(this.m_tokenHandler, tokenType, this.m_pos - this.m_line.offset, matchedChars, this.m_context);
                    } else {
                        this.m_tokenHandler.handleToken(this.m_line, tokenType, this.m_pos - this.m_line.offset, matchedChars, this.m_context);
                    }
                    char[] spanEndSubst = null;
                    if (charIndexed != null && checkRule.end != null) {
                        spanEndSubst = this.substitute(match, checkRule.end);
                    }
                    this.m_context.spanEndSubst = spanEndSubst;
                    this.m_context = new LineContext(checkRule.delegate, this.m_context);
                    this.m_keywords = this.m_context.rules.getKeywords();
                    break;
                }
                case 8: {
                    this.m_tokenHandler.handleToken(this.m_line, (checkRule.action & 0x100) == 256 ? this.m_context.rules.getDefault() : checkRule.token, this.m_pos - this.m_line.offset, this.m_pattern.count, this.m_context);
                    this.m_context.spanEndSubst = null;
                    this.m_context.inRule = checkRule;
                    break;
                }
                case 4: {
                    this.m_context.spanEndSubst = null;
                    if ((checkRule.action & 0x100) == 256) {
                        if (this.m_pos != this.m_lastOffset) {
                            this.m_tokenHandler.handleToken(this.m_line, checkRule.token, this.m_lastOffset - this.m_line.offset, this.m_pos - this.m_lastOffset, this.m_context);
                        }
                        this.m_tokenHandler.handleToken(this.m_line, this.m_context.rules.getDefault(), this.m_pos - this.m_line.offset, this.m_pattern.count, this.m_context);
                        break;
                    }
                    this.m_tokenHandler.handleToken(this.m_line, checkRule.token, this.m_lastOffset - this.m_line.offset, this.m_pos - this.m_lastOffset + this.m_pattern.count, this.m_context);
                    break;
                }
                default: {
                    throw new InternalError("Unhandled major action");
                }
            }
            this.m_pos += matchedChars - 1;
            this.m_lastOffset = this.m_pos + 1;
        } else if ((this.m_context.inRule.action & 8) != 0) {
            if (this.m_pos != this.m_lastOffset) {
                this.m_tokenHandler.handleToken(this.m_line, this.m_context.inRule.token, this.m_lastOffset - this.m_line.offset, this.m_pos - this.m_lastOffset, this.m_context);
            }
            this.m_lastOffset = this.m_pos;
            this.m_context.inRule = null;
        }
        return true;
    }

    private void handleNoWordBreak() {
        ParserRule rule;
        if (this.m_context.parent != null && (rule = this.m_context.parent.inRule) != null && (this.m_context.parent.inRule.action & 0x400) != 0) {
            if (this.m_pos != this.m_lastOffset) {
                this.m_tokenHandler.handleToken(this.m_line, rule.token, this.m_lastOffset - this.m_line.offset, this.m_pos - this.m_lastOffset, this.m_context);
            }
            this.m_lastOffset = this.m_pos;
            this.m_context = this.m_context.parent;
            this.m_keywords = this.m_context.rules.getKeywords();
            this.m_context.inRule = null;
        }
    }

    private void handleTokenWithSpaces(TokenHandler tokenHandler, byte tokenType, int start, int len, LineContext context) {
        int last = start;
        int end = start + len;
        for (int i = start; i < end; ++i) {
            if (!Character.isWhitespace(this.m_line.array[i + this.m_line.offset])) continue;
            if (last != i) {
                tokenHandler.handleToken(this.m_line, tokenType, last, i - last, context);
            }
            tokenHandler.handleToken(this.m_line, tokenType, i, 1, context);
            last = i + 1;
        }
        if (last != end) {
            tokenHandler.handleToken(this.m_line, tokenType, last, end - last, context);
        }
    }

    private void markKeyword(boolean addRemaining) {
        byte id;
        int len = this.m_pos - this.m_lastOffset;
        if (len == 0) {
            return;
        }
        if (this.m_context.rules.getHighlightDigits()) {
            boolean digit = false;
            boolean mixed = false;
            for (int i = this.m_lastOffset; i < this.m_pos; ++i) {
                char ch = this.m_line.array[i];
                if (Character.isDigit(ch)) {
                    digit = true;
                    continue;
                }
                mixed = true;
            }
            if (mixed) {
                RE digitRE = this.m_context.rules.getDigitRegexp();
                if (digit) {
                    if (digitRE == null) {
                        digit = false;
                    } else {
                        CharIndexedSegment seg = new CharIndexedSegment(this.m_line, false);
                        int oldCount = this.m_line.count;
                        int oldOffset = this.m_line.offset;
                        this.m_line.offset = this.m_lastOffset;
                        this.m_line.count = len;
                        if (!digitRE.isMatch((Object)seg)) {
                            digit = false;
                        }
                        this.m_line.offset = oldOffset;
                        this.m_line.count = oldCount;
                    }
                }
            }
            if (digit) {
                this.m_tokenHandler.handleToken(this.m_line, (byte)5, this.m_lastOffset - this.m_line.offset, len, this.m_context);
                this.m_lastOffset = this.m_pos;
                return;
            }
        }
        if (this.m_keywords != null && (id = this.m_keywords.lookup(this.m_line, this.m_lastOffset, len)) != 0) {
            this.m_tokenHandler.handleToken(this.m_line, id, this.m_lastOffset - this.m_line.offset, len, this.m_context);
            this.m_lastOffset = this.m_pos;
            return;
        }
        if (addRemaining) {
            this.m_tokenHandler.handleToken(this.m_line, this.m_context.rules.getDefault(), this.m_lastOffset - this.m_line.offset, len, this.m_context);
            this.m_lastOffset = this.m_pos;
        }
    }

    private char[] substitute(REMatch match, char[] end) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < end.length; ++i) {
            char ch = end[i];
            if (ch == '$') {
                if (i == end.length - 1) {
                    buf.append(ch);
                    continue;
                }
                char digit = end[i + 1];
                if (!Character.isDigit(digit)) {
                    buf.append(ch);
                    continue;
                }
                buf.append(match.toString(digit - 48));
                ++i;
                continue;
            }
            buf.append(ch);
        }
        char[] returnValue = new char[buf.length()];
        buf.getChars(0, buf.length(), returnValue, 0);
        return returnValue;
    }

    static boolean objEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static class LineContext {
        private static Hashtable intern = new Hashtable();
        public LineContext parent;
        public ParserRule inRule;
        public ParserRuleSet rules;
        public char[] spanEndSubst;

        public LineContext(ParserRuleSet rs, LineContext lc) {
            this.rules = rs;
            this.parent = lc == null ? null : (LineContext)lc.clone();
        }

        public LineContext() {
        }

        public LineContext intern() {
            Object obj = intern.get(this);
            if (obj == null) {
                intern.put(this, this);
                return this;
            }
            return (LineContext)obj;
        }

        public int hashCode() {
            if (this.inRule != null) {
                return this.inRule.hashCode();
            }
            if (this.rules != null) {
                return this.rules.hashCode();
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineContext) {
                LineContext lc = (LineContext)obj;
                return lc.inRule == this.inRule && lc.rules == this.rules && TokenMarker.objEqual(this.parent, lc.parent) && this.charArraysEqual(this.spanEndSubst, lc.spanEndSubst);
            }
            return false;
        }

        public Object clone() {
            LineContext lc = new LineContext();
            lc.inRule = this.inRule;
            lc.rules = this.rules;
            lc.parent = this.parent == null ? null : (LineContext)this.parent.clone();
            lc.spanEndSubst = this.spanEndSubst;
            return lc;
        }

        private boolean charArraysEqual(char[] c1, char[] c2) {
            if (c1 == null) {
                return c2 == null;
            }
            if (c2 == null) {
                return c1 == null;
            }
            if (c1.length != c2.length) {
                return false;
            }
            for (int i = 0; i < c1.length; ++i) {
                if (c1[i] == c2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

