/*
 * Decompiled with CFR 0.152.
 */
package to.etc.syntaxer;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import to.etc.syntaxer.XmlHandler;

public class XmlParser {
    private static final boolean USE_CHEATS = true;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    public static final int ATTRIBUTE_UNDECLARED = 0;
    public static final int ATTRIBUTE_CDATA = 1;
    public static final int ATTRIBUTE_ID = 2;
    public static final int ATTRIBUTE_IDREF = 3;
    public static final int ATTRIBUTE_IDREFS = 4;
    public static final int ATTRIBUTE_ENTITY = 5;
    public static final int ATTRIBUTE_ENTITIES = 6;
    public static final int ATTRIBUTE_NMTOKEN = 7;
    public static final int ATTRIBUTE_NMTOKENS = 8;
    public static final int ATTRIBUTE_ENUMERATED = 9;
    public static final int ATTRIBUTE_NOTATION = 10;
    private static Hashtable attributeTypeHash = new Hashtable();
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 0;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 1;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 2;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 3;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 4;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_EXTERNAL = 2;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_BUFFER = 4;
    private static final int INPUT_READER = 5;
    private static final int LIT_CHAR_REF = 1;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_PE_REF = 4;
    private static final int LIT_NORMALIZE = 8;
    private static final int CONTEXT_NONE = 0;
    private static final int CONTEXT_DTD = 1;
    private static final int CONTEXT_ENTITYVALUE = 2;
    private static final int CONTEXT_ATTRIBUTEVALUE = 3;
    XmlHandler m_handler;
    private Reader m_reader;
    private InputStream m_is;
    private int m_line;
    private int m_column;
    private int m_sourceType;
    private Stack m_inputStack;
    private URLConnection m_externalEntity;
    private int m_encoding;
    private int m_currentByteCount;
    private int errorCount;
    private static final int READ_BUFFER_MAX = 16384;
    private char[] m_readBuffer;
    private int m_rbpos;
    private int m_rblen;
    private int m_rboverflow;
    private byte[] m_rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] m_dataBuffer;
    private int m_dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] m_nameBuffer;
    private int m_nameBufferPos;
    private Hashtable m_elementInfo;
    private Hashtable m_entityInfo;
    private Hashtable m_notationInfo;
    private String m_currentElement;
    private int m_currentElementContent;
    private String m_basePublicId;
    private String m_baseURI;
    private Reader m_baseReader;
    private InputStream m_baseInputStream;
    private Stack m_entityStack;
    private int m_context;
    private Object[] m_symbolTable;
    private static final int SYMBOL_TABLE_LENGTH = 1087;
    private String[] m_tagAttributes;
    private int m_tagAttributePos;
    private boolean m_sawCR;

    public void setHandler(XmlHandler handler) {
        this.m_handler = handler;
    }

    public void parse(String systemId, String publicId, String encoding) throws Exception {
        this.doParse(systemId, publicId, null, null, encoding);
    }

    public void parse(String systemId, String publicId, InputStream stream, String encoding) throws Exception {
        this.doParse(systemId, publicId, null, stream, encoding);
    }

    public void parse(String systemId, String publicId, Reader reader) throws Exception {
        this.doParse(systemId, publicId, reader, null, null);
    }

    private synchronized void doParse(String systemId, String publicId, Reader reader, InputStream stream, String encoding) throws Exception {
        this.m_basePublicId = publicId;
        this.m_baseURI = systemId;
        this.m_baseReader = reader;
        this.m_baseInputStream = stream;
        this.initializeVariables();
        this.setInternalEntity(this.intern("amp"), "&#38;");
        this.setInternalEntity(this.intern("lt"), "&#60;");
        this.setInternalEntity(this.intern("gt"), "&#62;");
        this.setInternalEntity(this.intern("apos"), "&#39;");
        this.setInternalEntity(this.intern("quot"), "&#34;");
        if (this.m_handler != null) {
            this.m_handler.startDocument();
        }
        this.pushURL("[document]", this.m_basePublicId, this.m_baseURI, this.m_baseReader, this.m_baseInputStream, encoding);
        this.parseDocument();
        if (this.m_handler != null) {
            this.m_handler.endDocument();
        }
        this.cleanupVariables();
    }

    void error(String message, String textFound, String textExpected) throws Exception {
        ++this.errorCount;
        if (textFound != null) {
            message = message + " (found \"" + textFound + "\")";
        }
        if (textExpected != null) {
            message = message + " (expected \"" + textExpected + "\")";
        }
        if (this.m_handler != null) {
            String uri = null;
            if (this.m_externalEntity != null) {
                uri = this.m_externalEntity.getURL().toString();
            }
            this.m_handler.error(message, uri, this.m_line, this.m_column);
        }
    }

    void error(String message, char textFound, String textExpected) throws Exception {
        this.error(message, new Character(textFound).toString(), textExpected);
    }

    void parseDocument() throws Exception {
        this.parseProlog();
        this.require('<');
        this.parseElement();
        try {
            this.parseMisc();
            char c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException e) {
            return;
        }
    }

    void parseComment() throws Exception {
        this.skipUntil("-->");
    }

    void parsePI() throws Exception {
        String name = this.readNmtoken(true);
        if (!this.tryRead("?>")) {
            this.requireWhitespace();
            this.parseUntil("?>");
        }
        if (this.m_handler != null) {
            this.m_handler.processingInstruction(name, this.dataBufferToString());
        }
    }

    void parseCDSect() throws Exception {
        this.parseUntil("]]>");
    }

    void parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
        }
    }

    void parseXMLDecl(boolean ignoreEncoding) throws Exception {
        String encodingName = null;
        this.require("version");
        this.parseEq();
        String version = this.readLiteral(0);
        if (!version.equals("1.0")) {
            this.error("unsupported XML version", version, "1.0");
        }
        this.skipWhitespace();
        if (this.tryRead("encoding")) {
            this.parseEq();
            encodingName = this.readLiteral(0);
            this.checkEncoding(encodingName, ignoreEncoding);
        }
        this.skipWhitespace();
        if (this.tryRead("standalone")) {
            this.parseEq();
            this.readLiteral(0);
        }
        this.skipWhitespace();
        this.require("?>");
    }

    void parseTextDecl(boolean ignoreEncoding) throws Exception {
        String encodingName = null;
        if (this.tryRead("version")) {
            this.parseEq();
            String version = this.readLiteral(0);
            if (!version.equals("1.0")) {
                this.error("unsupported XML version", version, "1.0");
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        encodingName = this.readLiteral(0);
        this.checkEncoding(encodingName, ignoreEncoding);
        this.skipWhitespace();
        this.require("?>");
    }

    void checkEncoding(String encodingName, boolean ignoreEncoding) throws Exception {
        encodingName = encodingName.toUpperCase();
        if (ignoreEncoding) {
            return;
        }
        switch (this.m_encoding) {
            case 1: {
                if (encodingName.equals("ISO-8859-1")) {
                    this.m_encoding = 2;
                    break;
                }
                if (encodingName.equals("UTF-8")) break;
                this.error("unsupported 8-bit encoding", encodingName, "UTF-8 or ISO-8859-1");
                break;
            }
            case 3: 
            case 4: {
                if (encodingName.equals("ISO-10646-UCS-2") || encodingName.equals("UTF-16")) break;
                this.error("unsupported 16-bit encoding", encodingName, "ISO-10646-UCS-2");
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (encodingName.equals("ISO-10646-UCS-4")) break;
                this.error("unsupported 32-bit encoding", encodingName, "ISO-10646-UCS-4");
            }
        }
    }

    void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead("<?")) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead("<!--")) break;
            this.parseComment();
        }
    }

    void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String doctypeName = this.readNmtoken(true);
        this.skipWhitespace();
        String[] ids = this.readExternalIds(false);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.m_context = 1;
                this.skipWhitespace();
                this.m_context = 0;
                if (this.tryRead(']')) break;
                this.m_context = 1;
                this.parseMarkupdecl();
                this.m_context = 0;
            }
        }
        if (ids[1] != null) {
            this.pushURL("[external subset]", ids[0], ids[1], null, null, null);
            while (true) {
                this.m_context = 1;
                this.skipWhitespace();
                this.m_context = 0;
                if (!this.tryRead('>')) {
                    this.m_context = 1;
                    this.parseMarkupdecl();
                    this.m_context = 0;
                    continue;
                }
                break;
            }
        } else {
            this.skipWhitespace();
            this.require('>');
        }
        if (this.m_handler != null) {
            this.m_handler.doctypeDecl(doctypeName, ids[0], ids[1]);
        }
    }

    void parseMarkupdecl() throws Exception {
        if (this.tryRead("<!ELEMENT")) {
            this.parseElementdecl();
        } else if (this.tryRead("<!ATTLIST")) {
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            this.parseNotationDecl();
        } else if (this.tryRead("<?")) {
            this.parsePI();
        } else if (this.tryRead("<!--")) {
            this.parseComment();
        } else if (this.tryRead("<![")) {
            this.parseConditionalSect();
        } else {
            this.error("expected markup declaration", null, null);
        }
    }

    void parseElement() throws Exception {
        String gi;
        int oldElementContent = this.m_currentElementContent;
        String oldElement = this.m_currentElement;
        this.m_tagAttributePos = 0;
        this.m_currentElement = gi = this.readNmtoken(true);
        this.m_currentElementContent = this.getElementContentType(gi);
        if (this.m_currentElementContent == 0) {
            this.m_currentElementContent = 1;
        }
        this.skipWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            this.parseAttribute(gi);
            this.skipWhitespace();
            c = this.readCh();
        }
        this.unread(c);
        Enumeration atts = this.declaredAttributes(gi);
        if (atts != null) {
            block5: while (atts.hasMoreElements()) {
                String aname = (String)atts.nextElement();
                for (int i = 0; i < this.m_tagAttributePos; ++i) {
                    if (this.m_tagAttributes[i] == aname) continue block5;
                }
                if (this.m_handler == null) continue;
                this.m_handler.attribute(aname, this.getAttributeExpandedValue(gi, aname), false);
            }
        }
        c = this.readCh();
        switch (c) {
            case '>': {
                if (this.m_handler != null) {
                    this.m_handler.startElement(gi);
                }
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                if (this.m_handler == null) break;
                this.m_handler.startElement(gi);
                this.m_handler.endElement(gi);
            }
        }
        this.m_currentElement = oldElement;
        this.m_currentElementContent = oldElementContent;
    }

    void parseAttribute(String name) throws Exception {
        String aname = this.readNmtoken(true).intern();
        int type = this.getAttributeDefaultValueType(name, aname);
        this.parseEq();
        String value = type == 1 || type == 0 ? this.readLiteral(3) : this.readLiteral(11);
        if (this.m_handler != null) {
            this.m_handler.attribute(aname, value, true);
        }
        this.m_dataBufferPos = 0;
        if (this.m_tagAttributePos == this.m_tagAttributes.length) {
            String[] newAttrib = new String[this.m_tagAttributes.length * 2];
            System.arraycopy(this.m_tagAttributes, 0, newAttrib, 0, this.m_tagAttributePos);
            this.m_tagAttributes = newAttrib;
        }
        this.m_tagAttributes[this.m_tagAttributePos++] = aname;
    }

    void parseEq() throws Exception {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    void parseETag() throws Exception {
        String name = this.readNmtoken(true);
        if (name != this.m_currentElement) {
            this.error("mismatched end tag", name, this.m_currentElement);
        }
        this.skipWhitespace();
        this.require('>');
        if (this.m_handler != null) {
            this.m_handler.endElement(name);
        }
    }

    void parseContent() throws Exception {
        while (true) {
            switch (this.m_currentElementContent) {
                case 1: 
                case 3: {
                    this.parsePCData();
                    break;
                }
                case 4: {
                    this.parseWhitespace();
                }
            }
            char c = this.readCh();
            block4 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                        break;
                    }
                    this.unread(c);
                    this.parseEntityRef(true);
                    break;
                }
                case '<': {
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-');
                                    this.parseComment();
                                    break block4;
                                }
                                case '[': {
                                    this.require("CDATA[");
                                    this.parseCDSect();
                                    break block4;
                                }
                            }
                            this.error("expected comment or CDATA section", c, null);
                            break block4;
                        }
                        case '?': {
                            this.dataBufferFlush();
                            this.parsePI();
                            break block4;
                        }
                        case '/': {
                            this.dataBufferFlush();
                            this.parseETag();
                            return;
                        }
                    }
                    this.dataBufferFlush();
                    this.unread(c);
                    this.parseElement();
                }
            }
        }
    }

    void parseElementdecl() throws Exception {
        this.requireWhitespace();
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(name);
        this.skipWhitespace();
        this.require('>');
    }

    void parseContentspec(String name) throws Exception {
        if (this.tryRead("EMPTY")) {
            this.setElement(name, 2, null, null);
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(name, 1, null, null);
            return;
        }
        this.require('(');
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed();
            this.setElement(name, 3, this.dataBufferToString(), null);
        } else {
            this.parseElements();
            this.setElement(name, 4, this.dataBufferToString(), null);
        }
    }

    void parseElements() throws Exception {
        char sep;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c = this.readCh();
        switch (c) {
            case ')': {
                this.dataBufferAppend(')');
                c = this.readCh();
                switch (c) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c);
                        break;
                    }
                    default: {
                        this.unread(c);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                sep = c;
                this.dataBufferAppend(c);
                break;
            }
            default: {
                this.error("bad separator in content model", c, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c = this.readCh();
            if (c == ')') break;
            if (c != sep) {
                this.error("bad separator in content model", c, null);
                return;
            }
            this.dataBufferAppend(c);
        }
        this.dataBufferAppend(')');
        c = this.readCh();
        switch (c) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c);
                return;
            }
        }
        this.unread(c);
    }

    void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements();
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    void parseMixed() throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")*")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(")*");
    }

    void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String elementName = this.readNmtoken(true);
        this.requireWhitespace();
        while (!this.tryRead('>')) {
            this.parseAttDef(elementName);
            this.skipWhitespace();
        }
    }

    void parseAttDef(String elementName) throws Exception {
        String enumeration = null;
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        int type = this.readAttType();
        if (type == 9 || type == 10) {
            enumeration = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(elementName, name, type, enumeration);
    }

    int readAttType() throws Exception {
        Integer type;
        if (this.tryRead('(')) {
            this.parseEnumeration();
            return 9;
        }
        String typeString = this.readNmtoken(true);
        if (typeString.equals("NOTATION")) {
            this.parseNotationType();
        }
        if ((type = (Integer)attributeTypeHash.get(typeString)) == null) {
            this.error("illegal attribute type", typeString, null);
            return 0;
        }
        return type;
    }

    void parseEnumeration() throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(true));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration();
    }

    void parseDefault(String elementName, String name, int type, String enumeration) throws Exception {
        int valueType = 1;
        String value = null;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                valueType = 4;
                this.requireWhitespace();
                this.m_context = 3;
                value = this.readLiteral(1);
                this.m_context = 1;
            } else if (this.tryRead("REQUIRED")) {
                valueType = 3;
            } else if (this.tryRead("IMPLIED")) {
                valueType = 2;
            } else {
                this.error("illegal keyword for attribute default value", null, null);
            }
        } else {
            this.m_context = 3;
            value = this.readLiteral(1);
            this.m_context = 1;
        }
        this.setAttribute(elementName, name, type, enumeration, value, valueType);
    }

    void parseConditionalSect() throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            int nest = 1;
            while (nest > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (this.tryRead("![")) {
                            ++nest;
                        }
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --nest;
                    }
                }
            }
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE", null, null);
        }
    }

    void parseCharRef() throws Exception {
        int value = 0;
        if (this.tryRead('x')) {
            block8: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        value *= 16;
                        value += Integer.parseInt(new Character(c).toString(), 16);
                        continue block8;
                    }
                    case ';': {
                        break block8;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block8;
                    }
                }
                break;
            }
        } else {
            block9: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value *= 10;
                        value += Integer.parseInt(new Character(c).toString(), 10);
                        continue block9;
                    }
                    case ';': {
                        break block9;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block9;
                    }
                }
                break;
            }
        }
        if (value <= 65535) {
            this.dataBufferAppend((char)value);
        } else if (value <= 1048575) {
            this.dataBufferAppend((char)(0xD8 | (value & 0xFFC00) >> 10));
            this.dataBufferAppend((char)(0xDC | value & 0x3FF));
        } else {
            this.error("character reference " + value + " is too large for UTF-16", new Integer(value).toString(), null);
        }
    }

    void parseEntityRef(boolean externalAllowed) throws Exception {
        String name = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                this.error("reference to undeclared entity", name, null);
                break;
            }
            case 1: {
                this.pushString(name, this.getEntityValue(name));
                break;
            }
            case 3: {
                if (externalAllowed) {
                    this.pushURL(name, this.getEntityPublicId(name), this.getEntitySystemId(name), null, null, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
                break;
            }
            case 2: {
                if (externalAllowed) {
                    this.error("data entity reference in content", name, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
            }
        }
    }

    void parsePEReference(boolean isEntityValue) throws Exception {
        String name = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                this.error("reference to undeclared parameter entity", name, null);
                break;
            }
            case 1: {
                if (isEntityValue) {
                    this.pushString(name, this.getEntityValue(name));
                    break;
                }
                this.pushString(name, " " + this.getEntityValue(name) + ' ');
                break;
            }
            case 3: {
                if (isEntityValue) {
                    this.pushString(null, " ");
                }
                this.pushURL(name, this.getEntityPublicId(name), this.getEntitySystemId(name), null, null, null);
                if (!isEntityValue) break;
                this.pushString(null, " ");
            }
        }
    }

    void parseEntityDecl() throws Exception {
        boolean peFlag = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            peFlag = true;
            this.requireWhitespace();
        }
        String name = this.readNmtoken(true);
        if (peFlag) {
            name = "%" + name;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            this.m_context = 2;
            String value = this.readLiteral(5);
            this.m_context = 1;
            this.setInternalEntity(name, value);
        } else {
            String[] ids = this.readExternalIds(false);
            if (ids[1] == null) {
                this.error("system identifer missing", name, null);
            }
            this.skipWhitespace();
            if (this.tryRead("NDATA")) {
                this.requireWhitespace();
                String notationName = this.readNmtoken(true);
                this.setExternalDataEntity(name, ids[0], ids[1], notationName);
            } else {
                this.setExternalTextEntity(name, ids[0], ids[1]);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String nname = this.readNmtoken(true);
        this.requireWhitespace();
        String[] ids = this.readExternalIds(true);
        if (ids[0] == null && ids[1] == null) {
            this.error("external identifer missing", nname, null);
        }
        this.setNotation(nname, ids[0], ids[1]);
        this.skipWhitespace();
        this.require('>');
    }

    void parsePCData() throws Exception {
        int lineAugment = 0;
        int columnAugment = 0;
        block7: for (int i = this.m_rbpos; i < this.m_rblen; ++i) {
            switch (this.m_readBuffer[i]) {
                case '\n': {
                    ++lineAugment;
                    columnAugment = 0;
                    continue block7;
                }
                case '&': 
                case '<': {
                    int start = this.m_rbpos;
                    ++columnAugment;
                    this.m_rbpos = i;
                    if (lineAugment > 0) {
                        this.m_line += lineAugment;
                        this.m_column = columnAugment;
                    } else {
                        this.m_column += columnAugment;
                    }
                    this.dataBufferAppend(this.m_readBuffer, start, i - start);
                    return;
                }
                default: {
                    ++columnAugment;
                }
            }
        }
        while (true) {
            char c = this.readCh();
            switch (c) {
                case '&': 
                case '<': {
                    this.unread(c);
                    return;
                }
            }
            this.dataBufferAppend(c);
        }
    }

    void requireWhitespace() throws Exception {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace expected", c, null);
        }
    }

    void parseWhitespace() throws Exception {
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            this.dataBufferAppend(c);
            c = this.readCh();
        }
        this.unread(c);
    }

    void skipWhitespace() throws Exception {
        int lineAugment = 0;
        int columnAugment = 0;
        block5: for (int i = this.m_rbpos; i < this.m_rblen; ++i) {
            switch (this.m_readBuffer[i]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++columnAugment;
                    continue block5;
                }
                case '\n': {
                    ++lineAugment;
                    columnAugment = 0;
                    continue block5;
                }
                case '%': {
                    if (this.m_context == 1 || this.m_context == 2) break block5;
                }
                default: {
                    this.m_rbpos = i;
                    if (lineAugment > 0) {
                        this.m_line += lineAugment;
                        this.m_column = columnAugment;
                    } else {
                        this.m_column += columnAugment;
                    }
                    return;
                }
            }
        }
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    String readNmtoken(boolean isName) throws Exception {
        block7: for (int i = this.m_rbpos; i < this.m_rblen; ++i) {
            switch (this.m_readBuffer[i]) {
                case '%': {
                    if (this.m_context == 1 || this.m_context == 2) break block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '#': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int start = this.m_rbpos;
                    if (i == start) {
                        this.error("name expected", this.m_readBuffer[i], null);
                    }
                    this.m_rbpos = i;
                    return this.intern(this.m_readBuffer, start, i - start);
                }
                default: {
                    continue block7;
                }
            }
        }
        this.m_nameBufferPos = 0;
        while (true) {
            char c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.m_nameBufferPos == 0) {
                        this.error("name expected", null, null);
                    }
                    String s = this.intern(this.m_nameBuffer, 0, this.m_nameBufferPos);
                    this.m_nameBufferPos = 0;
                    return s;
                }
            }
            this.m_nameBuffer = (char[])this.extendArray(this.m_nameBuffer, this.m_nameBuffer.length, this.m_nameBufferPos);
            this.m_nameBuffer[this.m_nameBufferPos++] = c;
        }
    }

    String readLiteral(int flags) throws Exception {
        int startLine = this.m_line;
        char delim = this.readCh();
        if (delim != '\"' && delim != '\'' && delim != '\u0000') {
            this.error("expected '\"' or \"'\"", delim, null);
            return null;
        }
        try {
            char c = this.readCh();
            block6: while (c != delim) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        c = ' ';
                        break;
                    }
                    case '&': {
                        if ((flags & 1) <= 0) break;
                        c = this.readCh();
                        if (c == '#') {
                            this.parseCharRef();
                            c = this.readCh();
                            continue block6;
                        }
                        if ((flags & 2) > 0) {
                            this.unread(c);
                            this.parseEntityRef(false);
                            c = this.readCh();
                            continue block6;
                        }
                        this.dataBufferAppend('&');
                        break;
                    }
                }
                this.dataBufferAppend(c);
                c = this.readCh();
            }
        }
        catch (EOFException e) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, new Character(delim).toString());
        }
        if ((flags & 8) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    String[] readExternalIds(boolean inNotation) throws Exception {
        String[] ids = new String[2];
        if (this.tryRead("PUBLIC")) {
            this.requireWhitespace();
            ids[0] = this.readLiteral(8);
            if (inNotation) {
                this.skipWhitespace();
                if (this.tryRead('\"') || this.tryRead('\'')) {
                    ids[1] = this.readLiteral(0);
                }
            } else {
                this.requireWhitespace();
                ids[1] = this.readLiteral(0);
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            ids[1] = this.readLiteral(0);
        }
        return ids;
    }

    final boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    void dataBufferAppend(char c) {
        this.m_dataBuffer = (char[])this.extendArray(this.m_dataBuffer, this.m_dataBuffer.length, this.m_dataBufferPos);
        this.m_dataBuffer[this.m_dataBufferPos++] = c;
    }

    void dataBufferAppend(String s) {
        this.dataBufferAppend(s.toCharArray(), 0, s.length());
    }

    void dataBufferAppend(char[] ch, int start, int length) {
        this.m_dataBuffer = (char[])this.extendArray(this.m_dataBuffer, this.m_dataBuffer.length, this.m_dataBufferPos + length);
        System.arraycopy(ch, start, this.m_dataBuffer, this.m_dataBufferPos, length);
        this.m_dataBufferPos += length;
    }

    void dataBufferNormalize() {
        int j;
        int i = 0;
        int end = this.m_dataBufferPos;
        for (j = 0; j < end && this.isWhitespace(this.m_dataBuffer[j]); ++j) {
        }
        while (end > j && this.isWhitespace(this.m_dataBuffer[end - 1])) {
            --end;
        }
        while (j < end) {
            char c;
            if (this.isWhitespace(c = this.m_dataBuffer[j++])) {
                while (j < end && this.isWhitespace(this.m_dataBuffer[j++])) {
                }
                this.m_dataBuffer[i++] = 32;
                this.m_dataBuffer[i++] = this.m_dataBuffer[j - 1];
                continue;
            }
            this.m_dataBuffer[i++] = c;
        }
        this.m_dataBufferPos = i;
    }

    String dataBufferToString() {
        String s = new String(this.m_dataBuffer, 0, this.m_dataBufferPos);
        this.m_dataBufferPos = 0;
        return s;
    }

    void dataBufferFlush() throws Exception {
        if (this.m_dataBufferPos > 0) {
            switch (this.m_currentElementContent) {
                case 0: 
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    if (this.m_handler == null) break;
                    this.m_handler.charData(this.m_dataBuffer, 0, this.m_dataBufferPos);
                    break;
                }
                case 4: {
                    if (this.m_handler == null) break;
                    this.m_handler.ignorableWhitespace(this.m_dataBuffer, 0, this.m_dataBufferPos);
                }
            }
            this.m_dataBufferPos = 0;
        }
    }

    void require(String delim) throws Exception {
        char[] ch = delim.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            this.require(ch[i]);
        }
    }

    void require(char delim) throws Exception {
        char c = this.readCh();
        if (c != delim) {
            this.error("expected character", c, new Character(delim).toString());
        }
    }

    public String intern(String s) {
        char[] ch = s.toCharArray();
        return this.intern(ch, 0, ch.length);
    }

    public String intern(char[] ch, int start, int length) {
        char[] chFound;
        int index;
        int hash = 0;
        for (int i = start; i < start + length; ++i) {
            hash = (hash << 1 & 0xFFFFFF) + ch[i];
        }
        Object[] bucket = (Object[])this.m_symbolTable[hash %= 1087];
        if (bucket == null) {
            bucket = new Object[8];
            this.m_symbolTable[hash] = bucket;
        }
        for (index = 0; index < bucket.length && (chFound = (char[])bucket[index]) != null; index += 2) {
            if (chFound.length != length) continue;
            for (int i = 0; i < chFound.length && ch[start + i] == chFound[i]; ++i) {
                if (i != length - 1) continue;
                return (String)bucket[index + 1];
            }
        }
        bucket = (Object[])this.extendArray(bucket, bucket.length, index);
        String s = new String(ch, start, length);
        bucket[index] = s.toCharArray();
        bucket[index + 1] = s;
        this.m_symbolTable[hash] = bucket;
        return s;
    }

    Object extendArray(Object array, int currentSize, int requiredSize) {
        if (requiredSize < currentSize) {
            return array;
        }
        Object[] newArray = null;
        int newSize = currentSize * 2;
        if (newSize <= requiredSize) {
            newSize = requiredSize + 1;
        }
        if (array instanceof char[]) {
            newArray = new char[newSize];
        } else if (array instanceof Object[]) {
            newArray = new Object[newSize];
        }
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    public Enumeration declaredElements() {
        return this.m_elementInfo.keys();
    }

    public int getElementContentType(String name) {
        Object[] element = (Object[])this.m_elementInfo.get(name);
        if (element == null) {
            return 0;
        }
        return (Integer)element[0];
    }

    public String getElementContentModel(String name) {
        Object[] element = (Object[])this.m_elementInfo.get(name);
        if (element == null) {
            return null;
        }
        return (String)element[1];
    }

    void setElement(String name, int contentType, String contentModel, Hashtable attributes) throws Exception {
        Object[] element = (Object[])this.m_elementInfo.get(name);
        if (element == null) {
            element = new Object[]{new Integer(0), null, null};
        } else if (contentType != 0 && (Integer)element[0] != 0) {
            this.error("multiple declarations for element type", name, null);
            return;
        }
        if (contentType != 0) {
            element[0] = new Integer(contentType);
        }
        if (contentModel != null) {
            element[1] = contentModel;
        }
        if (attributes != null) {
            element[2] = attributes;
        }
        this.m_elementInfo.put(name, element);
    }

    Hashtable getElementAttributes(String name) {
        Object[] element = (Object[])this.m_elementInfo.get(name);
        if (element == null) {
            return null;
        }
        return (Hashtable)element[2];
    }

    public Enumeration declaredAttributes(String elname) {
        Hashtable attlist = this.getElementAttributes(elname);
        if (attlist == null) {
            return null;
        }
        return attlist.keys();
    }

    public int getAttributeType(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return 0;
        }
        return (Integer)attribute[0];
    }

    public String getAttributeEnumeration(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        return (String)attribute[3];
    }

    public String getAttributeDefaultValue(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        return (String)attribute[1];
    }

    public String getAttributeExpandedValue(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        if (attribute[4] == null && attribute[1] != null) {
            try {
                this.pushString(null, '\u0000' + (String)attribute[1] + '\u0000');
                attribute[4] = this.readLiteral(11);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (String)attribute[4];
    }

    public int getAttributeDefaultValueType(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return 0;
        }
        return (Integer)attribute[2];
    }

    void setAttribute(String elName, String name, int type, String enumeration, String value, int valueType) throws Exception {
        Hashtable<String, Object[]> attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            attlist = new Hashtable<String, Object[]>();
        }
        if (attlist.get(name) != null) {
            return;
        }
        Object[] attribute = new Object[]{new Integer(type), value, new Integer(valueType), enumeration, null};
        attlist.put(name.intern(), attribute);
        this.setElement(elName, 0, null, attlist);
    }

    Object[] getAttribute(String elName, String name) {
        Hashtable attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            return null;
        }
        Object[] attribute = (Object[])attlist.get(name);
        return attribute;
    }

    public Enumeration declaredEntities() {
        return this.m_entityInfo.keys();
    }

    public int getEntityType(String ename) {
        Object[] entity = (Object[])this.m_entityInfo.get(ename);
        if (entity == null) {
            return 0;
        }
        return (Integer)entity[0];
    }

    public String getEntityPublicId(String ename) {
        Object[] entity = (Object[])this.m_entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[1];
    }

    public String getEntitySystemId(String ename) {
        Object[] entity = (Object[])this.m_entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[2];
    }

    public String getEntityValue(String ename) {
        Object[] entity = (Object[])this.m_entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[3];
    }

    public String getEntityNotationName(String eName) {
        Object[] entity = (Object[])this.m_entityInfo.get(eName);
        if (entity == null) {
            return null;
        }
        return (String)entity[4];
    }

    void setInternalEntity(String eName, String value) {
        this.setEntity(eName, 1, null, null, value, null);
    }

    void setExternalDataEntity(String eName, String pubid, String sysid, String nName) {
        this.setEntity(eName, 2, pubid, sysid, null, nName);
    }

    void setExternalTextEntity(String eName, String pubid, String sysid) {
        this.setEntity(eName, 3, pubid, sysid, null, null);
    }

    void setEntity(String eName, int eClass, String pubid, String sysid, String value, String nName) {
        if (this.m_entityInfo.get(eName) == null) {
            Object[] entity = new Object[]{new Integer(eClass), pubid, sysid, value, nName};
            this.m_entityInfo.put(eName, entity);
        }
    }

    public Enumeration declaredNotations() {
        return this.m_notationInfo.keys();
    }

    public String getNotationPublicId(String nname) {
        Object[] notation = (Object[])this.m_notationInfo.get(nname);
        if (notation == null) {
            return null;
        }
        return (String)notation[0];
    }

    public String getNotationSystemId(String nname) {
        Object[] notation = (Object[])this.m_notationInfo.get(nname);
        if (notation == null) {
            return null;
        }
        return (String)notation[1];
    }

    void setNotation(String nname, String pubid, String sysid) throws Exception {
        if (this.m_notationInfo.get(nname) == null) {
            Object[] notation = new Object[]{pubid, sysid};
            this.m_notationInfo.put(nname, notation);
        } else {
            this.error("multiple declarations of notation", nname, null);
        }
    }

    public int getLineNumber() {
        return this.m_line;
    }

    public int getColumnNumber() {
        return this.m_column;
    }

    char readCh() throws Exception {
        char c;
        block3: while (this.m_rbpos >= this.m_rblen) {
            switch (this.m_sourceType) {
                case 2: 
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.m_rblen < 1) {
                        this.popInput();
                        if (this.m_rblen >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
            }
            this.popInput();
        }
        if ((c = this.m_readBuffer[this.m_rbpos++]) == '%' && (this.m_context == 1 || this.m_context == 2)) {
            char c2 = this.readCh();
            this.unread(c2);
            if (!this.isWhitespace(c2)) {
                this.parsePEReference(this.m_context == 2);
                return this.readCh();
            }
        }
        if (c == '\n') {
            ++this.m_line;
            this.m_column = 0;
        } else {
            ++this.m_column;
        }
        return c;
    }

    void unread(char c) throws Exception {
        if (c == '\n') {
            --this.m_line;
            this.m_column = -1;
        }
        if (this.m_rbpos > 0) {
            this.m_readBuffer[--this.m_rbpos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    void unread(char[] ch, int length) throws Exception {
        for (int i = 0; i < length; ++i) {
            if (ch[i] != '\n') continue;
            --this.m_line;
            this.m_column = -1;
        }
        if (length < this.m_rbpos) {
            this.m_rbpos -= length;
        } else {
            this.pushCharArray(null, ch, 0, length);
            this.m_sourceType = 4;
        }
    }

    void pushURL(String ename, String publicId, String systemId, Reader reader, InputStream stream, String encoding) throws Exception {
        Object input;
        boolean ignoreEncoding = false;
        this.pushInput(ename);
        this.m_readBuffer = new char[16388];
        this.m_rbpos = 0;
        this.m_rblen = 0;
        this.m_rboverflow = -1;
        this.m_is = null;
        this.m_line = 1;
        this.m_currentByteCount = 0;
        this.dataBufferFlush();
        if (systemId != null && this.m_externalEntity != null) {
            systemId = new URL(this.m_externalEntity.getURL(), systemId).toString();
        } else if (this.m_baseURI != null) {
            try {
                systemId = new URL(new URL(this.m_baseURI), systemId).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (systemId != null && this.m_handler != null && (input = this.m_handler.resolveEntity(publicId, systemId)) != null) {
            if (input instanceof String) {
                systemId = (String)input;
            } else if (input instanceof InputStream) {
                stream = (InputStream)input;
            } else if (input instanceof Reader) {
                reader = (Reader)input;
            }
        }
        if (this.m_handler != null) {
            if (systemId != null) {
                this.m_handler.startExternalEntity(systemId);
            } else {
                this.m_handler.startExternalEntity("[external stream]");
            }
        }
        if (reader != null) {
            this.m_sourceType = 5;
            this.m_reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        if (stream != null) {
            this.m_sourceType = 3;
            this.m_is = stream;
        } else {
            this.m_sourceType = 2;
            URL url = new URL(systemId);
            this.m_externalEntity = url.openConnection();
            this.m_externalEntity.connect();
            this.m_is = this.m_externalEntity.getInputStream();
        }
        if (!this.m_is.markSupported()) {
            this.m_is = new BufferedInputStream(this.m_is);
        }
        if (encoding == null && this.m_externalEntity != null) {
            encoding = this.m_externalEntity.getContentEncoding();
        }
        if (encoding != null) {
            this.checkEncoding(encoding, false);
            ignoreEncoding = true;
        } else {
            this.detectEncoding();
            ignoreEncoding = false;
        }
        this.tryEncodingDecl(ignoreEncoding);
    }

    void tryEncodingDecl(boolean ignoreEncoding) throws Exception {
        if (this.tryRead("<?xml")) {
            if (this.tryWhitespace()) {
                if (this.m_inputStack.size() > 0) {
                    this.parseTextDecl(ignoreEncoding);
                } else {
                    this.parseXMLDecl(ignoreEncoding);
                }
            } else {
                this.unread("xml".toCharArray(), 3);
                this.parsePI();
            }
        }
    }

    void detectEncoding() throws Exception {
        byte[] signature = new byte[4];
        this.m_is.mark(4);
        this.m_is.read(signature);
        this.m_is.reset();
        if (this.tryEncoding(signature, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.m_encoding = 5;
        } else if (this.tryEncoding(signature, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.m_encoding = 6;
        } else if (this.tryEncoding(signature, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.m_encoding = 7;
        } else if (this.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.m_encoding = 8;
        } else if (this.tryEncoding(signature, (byte)-2, (byte)-1)) {
            this.m_encoding = 3;
            this.m_is.read();
            this.m_is.read();
        } else if (this.tryEncoding(signature, (byte)-1, (byte)-2)) {
            this.m_encoding = 4;
            this.m_is.read();
            this.m_is.read();
        } else if (this.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.m_encoding = 3;
            this.error("no byte-order mark for UCS-2 entity", null, null);
        } else if (this.tryEncoding(signature, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.m_encoding = 4;
            this.error("no byte-order mark for UCS-2 entity", null, null);
        } else if (this.tryEncoding(signature, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.m_encoding = 1;
            this.read8bitEncodingDeclaration();
        } else {
            this.m_encoding = 1;
        }
    }

    boolean tryEncoding(byte[] sig, byte b1, byte b2, byte b3, byte b4) {
        return sig[0] == b1 && sig[1] == b2 && sig[2] == b3 && sig[3] == b4;
    }

    boolean tryEncoding(byte[] sig, byte b1, byte b2) {
        return sig[0] == b1 && sig[1] == b2;
    }

    void pushString(String ename, String s) throws Exception {
        char[] ch = s.toCharArray();
        this.pushCharArray(ename, ch, 0, ch.length);
    }

    void pushCharArray(String ename, char[] ch, int start, int length) throws Exception {
        this.pushInput(ename);
        this.m_sourceType = 1;
        this.m_readBuffer = ch;
        this.m_rbpos = start;
        this.m_rblen = length;
        this.m_rboverflow = -1;
    }

    void pushInput(String ename) throws Exception {
        Object[] input = new Object[12];
        if (ename != null) {
            Enumeration entities = this.m_entityStack.elements();
            while (entities.hasMoreElements()) {
                String e = (String)entities.nextElement();
                if (e != ename) continue;
                this.error("recursive reference to entity", ename, null);
            }
        }
        this.m_entityStack.push(ename);
        if (this.m_sourceType == 0) {
            return;
        }
        input[0] = new Integer(this.m_sourceType);
        input[1] = this.m_externalEntity;
        input[2] = this.m_readBuffer;
        input[3] = new Integer(this.m_rbpos);
        input[4] = new Integer(this.m_rblen);
        input[5] = new Integer(this.m_line);
        input[6] = new Integer(this.m_encoding);
        input[7] = new Integer(this.m_rboverflow);
        input[8] = this.m_is;
        input[9] = new Integer(this.m_currentByteCount);
        input[10] = new Integer(this.m_column);
        input[11] = this.m_reader;
        this.m_inputStack.push(input);
    }

    void popInput() throws Exception {
        switch (this.m_sourceType) {
            case 2: {
                this.dataBufferFlush();
                if (this.m_handler == null || this.m_externalEntity == null) break;
                this.m_handler.endExternalEntity(this.m_externalEntity.getURL().toString());
                break;
            }
            case 3: {
                this.dataBufferFlush();
                if (this.m_baseURI == null || this.m_handler == null) break;
                this.m_handler.endExternalEntity(this.m_baseURI);
                break;
            }
            case 5: {
                this.dataBufferFlush();
                if (this.m_baseURI == null || this.m_handler == null) break;
                this.m_handler.endExternalEntity(this.m_baseURI);
            }
        }
        if (this.m_inputStack.isEmpty()) {
            throw new EOFException();
        }
        Object[] input = (Object[])this.m_inputStack.pop();
        this.m_entityStack.pop();
        this.m_sourceType = (Integer)input[0];
        this.m_externalEntity = (URLConnection)input[1];
        this.m_readBuffer = (char[])input[2];
        this.m_rbpos = (Integer)input[3];
        this.m_rblen = (Integer)input[4];
        this.m_line = (Integer)input[5];
        this.m_encoding = (Integer)input[6];
        this.m_rboverflow = (Integer)input[7];
        this.m_is = (InputStream)input[8];
        this.m_currentByteCount = (Integer)input[9];
        this.m_column = (Integer)input[10];
        this.m_reader = (Reader)input[11];
    }

    boolean tryRead(char delim) throws Exception {
        char c = this.readCh();
        if (c == delim) {
            return true;
        }
        this.unread(c);
        return false;
    }

    boolean tryRead(String delim) throws Exception {
        char[] ch = delim.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = this.readCh();
            if (c == ch[i]) continue;
            this.unread(c);
            if (i != 0) {
                this.unread(ch, i);
            }
            return false;
        }
        return true;
    }

    boolean tryWhitespace() throws Exception {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    void parseUntil(String delim) throws Exception {
        int startLine = this.m_line;
        try {
            while (!this.tryRead(delim)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException e) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, delim);
        }
    }

    void skipUntil(String delim) throws Exception {
        while (!this.tryRead(delim)) {
            this.readCh();
        }
    }

    void read8bitEncodingDeclaration() throws Exception {
        this.m_rblen = 0;
        this.m_rbpos = 0;
        while (true) {
            int ch = this.m_is.read();
            this.m_readBuffer[this.m_rblen++] = (char)ch;
            switch (ch) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("end of file before end of XML or encoding declaration.", null, "?>");
                    return;
                }
            }
            if (this.m_readBuffer.length != this.m_rblen) continue;
            this.error("unfinished XML or encoding declaration", null, null);
        }
    }

    void readDataChunk() throws Exception {
        if (this.m_rboverflow > -1) {
            this.m_readBuffer[0] = (char)this.m_rboverflow;
            this.m_rboverflow = -1;
            this.m_rbpos = 1;
            this.m_sawCR = true;
        } else {
            this.m_rbpos = 0;
            this.m_sawCR = false;
        }
        if (this.m_sourceType == 5) {
            int count = this.m_reader.read(this.m_readBuffer, this.m_rbpos, 16383);
            if (count < 0) {
                this.m_rblen = -1;
            } else {
                this.m_rblen = this.m_rbpos + count;
                this.filterCR();
                this.m_sawCR = false;
            }
            return;
        }
        int count = this.m_is.read(this.m_rawReadBuffer, 0, 16384);
        switch (this.m_encoding) {
            case 1: {
                this.copyUtf8ReadBuffer(count);
                break;
            }
            case 2: {
                this.copyIso8859_1ReadBuffer(count);
                break;
            }
            case 3: {
                this.copyUcs2ReadBuffer(count, 8, 0);
                break;
            }
            case 4: {
                this.copyUcs2ReadBuffer(count, 0, 8);
                break;
            }
            case 5: {
                this.copyUcs4ReadBuffer(count, 24, 16, 8, 0);
                break;
            }
            case 6: {
                this.copyUcs4ReadBuffer(count, 0, 8, 16, 24);
                break;
            }
            case 7: {
                this.copyUcs4ReadBuffer(count, 16, 24, 0, 8);
                break;
            }
            case 8: {
                this.copyUcs4ReadBuffer(count, 8, 0, 24, 16);
            }
        }
        if (this.m_sawCR) {
            this.filterCR();
            this.m_sawCR = false;
        }
        this.m_rbpos = 0;
        this.m_currentByteCount += count;
    }

    void filterCR() {
        this.m_rboverflow = -1;
        int i = 0;
        block3: for (int j = 0; j < this.m_rblen; ++j) {
            switch (this.m_readBuffer[j]) {
                case '\r': {
                    if (j == this.m_rblen - 1) {
                        this.m_rboverflow = 13;
                        --this.m_rblen;
                        break block3;
                    }
                    if (this.m_readBuffer[j + 1] == '\n') {
                        ++j;
                    }
                    this.m_readBuffer[i] = 10;
                    break;
                }
                default: {
                    this.m_readBuffer[i] = this.m_readBuffer[j];
                }
            }
            ++i;
        }
        this.m_rblen = i;
    }

    void copyUtf8ReadBuffer(int count) throws Exception {
        int i = 0;
        int j = this.m_rbpos;
        while (i < count) {
            byte b1;
            if (((b1 = this.m_rawReadBuffer[i++]) & 0x80) == 0) {
                this.m_readBuffer[j++] = (char)b1;
            } else if ((b1 & 0xE0) == 192) {
                this.m_readBuffer[j++] = (char)((b1 & 0x1F) << 6 | this.getNextUtf8Byte(i++, count));
            } else if ((b1 & 0xF0) == 224) {
                this.m_readBuffer[j++] = (char)((b1 & 0xF) << 12 | this.getNextUtf8Byte(i++, count) << 6 | this.getNextUtf8Byte(i++, count));
            } else if ((b1 & 0xF8) == 240) {
                int b2 = this.getNextUtf8Byte(i++, count);
                int b3 = this.getNextUtf8Byte(i++, count);
                int b4 = this.getNextUtf8Byte(i++, count);
                this.m_readBuffer[j++] = (char)(0xD800 | ((b1 & 7) << 2 | ((b2 & 0x30) >> 4) - 1) << 6 | (b2 & 0xF) << 2 | (b3 & 0x30) >> 4);
                this.m_readBuffer[j++] = (char)(0xDC | (b3 & 0xF) << 6 | b4);
            } else {
                this.encodingError("bad start for UTF-8 multi-byte sequence", b1, i);
            }
            if (this.m_readBuffer[j - 1] != '\r') continue;
            this.m_sawCR = true;
        }
        this.m_rblen = j;
    }

    int getNextUtf8Byte(int pos, int count) throws Exception {
        int val;
        if (pos < count) {
            val = this.m_rawReadBuffer[pos];
        } else {
            val = this.m_is.read();
            if (val == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, pos);
            }
        }
        if ((val & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", val, pos + 1);
        }
        return val & 0x3F;
    }

    void copyIso8859_1ReadBuffer(int count) {
        int i = 0;
        int j = this.m_rbpos;
        while (i < count) {
            this.m_readBuffer[j] = (char)(this.m_rawReadBuffer[i] & 0xFF);
            if (this.m_readBuffer[j] == '\r') {
                this.m_sawCR = true;
            }
            ++i;
            ++j;
        }
        this.m_rblen = j;
    }

    void copyUcs2ReadBuffer(int count, int shift1, int shift2) throws Exception {
        int j = this.m_rbpos;
        if (count > 0 && count % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, count);
        }
        for (int i = 0; i < count; i += 2) {
            this.m_readBuffer[j++] = (char)((this.m_rawReadBuffer[i] & 0xFF) << shift1 | (this.m_rawReadBuffer[i + 1] & 0xFF) << shift2);
            if (this.m_readBuffer[j - 1] != '\r') continue;
            this.m_sawCR = true;
        }
        this.m_rblen = j;
    }

    void copyUcs4ReadBuffer(int count, int shift1, int shift2, int shift3, int shift4) throws Exception {
        int j = this.m_rbpos;
        if (count > 0 && count % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, count);
        }
        for (int i = 0; i < count; i += 4) {
            int value = (this.m_rawReadBuffer[i] & 0xFF) << shift1 | (this.m_rawReadBuffer[i + 1] & 0xFF) << shift2 | (this.m_rawReadBuffer[i + 2] & 0xFF) << shift3 | (this.m_rawReadBuffer[i + 3] & 0xFF) << shift4;
            if (value < 65535) {
                this.m_readBuffer[j++] = (char)value;
                if (value != 13) continue;
                this.m_sawCR = true;
                continue;
            }
            if (value < 1048575) {
                this.m_readBuffer[j++] = (char)(0xD8 | (value & 0xFFC00) >> 10);
                this.m_readBuffer[j++] = (char)(0xDC | value & 0x3FF);
                continue;
            }
            this.encodingError("value cannot be represented in UTF-16", value, i);
        }
        this.m_rblen = j;
    }

    void encodingError(String message, int value, int offset) throws Exception {
        if (value >= 0) {
            message = message + " (byte value: 0x" + Integer.toHexString(value) + ')';
        }
        String uri = this.m_externalEntity != null ? this.m_externalEntity.getURL().toString() : this.m_baseURI;
        this.m_handler.error(message, uri, -1, offset + this.m_currentByteCount);
    }

    void initializeVariables() {
        this.errorCount = 0;
        this.m_line = 1;
        this.m_column = 0;
        this.m_dataBufferPos = 0;
        this.m_dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.m_nameBufferPos = 0;
        this.m_nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.m_elementInfo = new Hashtable();
        this.m_entityInfo = new Hashtable();
        this.m_notationInfo = new Hashtable();
        this.m_currentElement = null;
        this.m_currentElementContent = 0;
        this.m_sourceType = 0;
        this.m_inputStack = new Stack();
        this.m_entityStack = new Stack();
        this.m_externalEntity = null;
        this.m_tagAttributePos = 0;
        this.m_tagAttributes = new String[100];
        this.m_rawReadBuffer = new byte[16384];
        this.m_rboverflow = -1;
        this.m_context = 0;
        this.m_symbolTable = new Object[1087];
    }

    void cleanupVariables() {
        this.errorCount = -1;
        this.m_line = -1;
        this.m_column = -1;
        this.m_dataBuffer = null;
        this.m_nameBuffer = null;
        this.m_currentElement = null;
        this.m_currentElementContent = 0;
        this.m_sourceType = 0;
        this.m_inputStack = null;
        this.m_externalEntity = null;
        this.m_entityStack = null;
    }

    static {
        attributeTypeHash.put("CDATA", new Integer(1));
        attributeTypeHash.put("ID", new Integer(2));
        attributeTypeHash.put("IDREF", new Integer(3));
        attributeTypeHash.put("IDREFS", new Integer(4));
        attributeTypeHash.put("ENTITY", new Integer(5));
        attributeTypeHash.put("ENTITIES", new Integer(6));
        attributeTypeHash.put("NMTOKEN", new Integer(7));
        attributeTypeHash.put("NMTOKENS", new Integer(8));
        attributeTypeHash.put("NOTATION", new Integer(10));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
    }
}

