/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.container;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.iocular.BindingScope;
import to.etc.iocular.Container;
import to.etc.iocular.container.BuildPlan;
import to.etc.iocular.container.IocContainerException;
import to.etc.iocular.container.StaticComponentRef;
import to.etc.iocular.def.ComponentDef;
import to.etc.iocular.def.ComponentRef;
import to.etc.iocular.def.ContainerDefinition;
import to.etc.util.IndentWriter;

public class BasicContainer
implements Container {
    private boolean m_started;
    private final BasicContainer m_parent;
    private final ContainerDefinition m_def;
    private final BasicContainer[] m_stack;
    private final Map<ComponentDef, StaticComponentRef> m_staticMap = new HashMap<ComponentDef, StaticComponentRef>();
    private final Map<ComponentDef, ContainerObjectRef> m_singletonMap = new HashMap<ComponentDef, ContainerObjectRef>();
    private List<Destructor> m_destructorList = Collections.EMPTY_LIST;

    public BasicContainer(ContainerDefinition def, Container parent) {
        if (def == null) {
            throw new IllegalStateException("The definition for a container cannot be null of course");
        }
        if (parent == null && def.getParentDefinition() != null) {
            throw new IllegalStateException("This container's definition states that this container REQUIRES a parent container '" + def.getParentDefinition().getName() + "'");
        }
        if (parent != null && def.getParentDefinition() == null) {
            throw new IllegalStateException("This container's definition states that it has NO parent container, but one was passed anyway?");
        }
        this.m_def = def;
        this.m_parent = (BasicContainer)parent;
        this.m_stack = new BasicContainer[def.getContainerIndex() + 1];
        this.m_stack[def.getContainerIndex()] = this;
        BasicContainer c = (BasicContainer)parent;
        while (c != null) {
            this.m_stack[c.m_def.getContainerIndex()] = c;
            c = c.m_parent;
        }
    }

    @Override
    public synchronized void start() {
        if (this.m_started) {
            throw new IllegalStateException(this + ": container has already been started!!");
        }
        this.m_started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ArrayList<Destructor> dlist;
        BasicContainer basicContainer = this;
        synchronized (basicContainer) {
            if (!this.m_started) {
                return;
            }
            this.m_started = false;
            if (this.m_destructorList.size() == 0) {
                return;
            }
            dlist = new ArrayList<Destructor>(this.m_destructorList);
            this.m_destructorList.clear();
            this.m_singletonMap.clear();
            this.m_staticMap.clear();
        }
        int i = dlist.size();
        while (--i >= 0) {
            Destructor d = (Destructor)dlist.get(i);
            System.out.println("Destroying: " + d.getInstance());
            d.getPlan().destroy(this, d.getInstance());
        }
    }

    public String getIdent() {
        return this.m_def.getName();
    }

    private synchronized ContainerObjectRef getRef(ComponentDef cd) {
        if (!this.m_started) {
            throw new IllegalStateException(this + ": the container has been destroyed, or it has not yet been started.");
        }
        ContainerObjectRef ref = this.m_singletonMap.get(cd);
        if (ref == null) {
            ref = new ContainerObjectRef(cd);
            this.m_singletonMap.put(cd, ref);
        }
        return ref;
    }

    @Override
    public <T> T findObject(Class<T> theClass) {
        return null;
    }

    @Override
    public <T> T findObject(String name, Class<T> theClass) {
        return null;
    }

    @Override
    public <T> T getObject(Class<T> theClass) throws Exception {
        ComponentRef ref = this.m_def.findComponentReference(theClass);
        if (ref == null) {
            throw new IocContainerException(this, "Can't create object of type=" + theClass.getName() + ": definition is not found");
        }
        return (T)this.retrieve(ref);
    }

    @Override
    public <T> T getObject(String name, Class<T> theClass) throws Exception {
        ComponentRef ref = this.m_def.findComponentReference(name);
        if (ref == null) {
            throw new IocContainerException(this, "Object with name=" + name + " not defined");
        }
        return (T)this.retrieve(ref);
    }

    @Override
    public void setParameter(Object instance) {
        if (instance == null) {
            throw new IocContainerException(this, "You cannot set a parameter to null using this function, you must specify the parameter type or name!");
        }
        ComponentRef ref = null;
        Class<?> current = instance.getClass();
        while (ref == null && (ref = this.m_def.findComponentReference(current)) == null) {
            if ((current = current.getSuperclass()) != Object.class && current != null) continue;
            throw new IocContainerException(this, "Undefined container parameter with type=" + instance.getClass() + " (or base class)");
        }
        this.assignParameter(ref, instance);
    }

    @Override
    public void setParameter(Class<?> theClass, Object instance) {
        ComponentRef ref = this.m_def.findComponentReference(theClass);
        if (ref == null) {
            throw new IocContainerException(this, "Can't create object of type=" + theClass.getName() + ": definition is not found");
        }
        this.assignParameter(ref, instance);
    }

    @Override
    public void setParameter(String name, Object instance) {
        ComponentRef ref = this.m_def.findComponentReference(name);
        if (ref == null) {
            throw new IocContainerException(this, "Object with name=" + name + " not defined");
        }
        this.assignParameter(ref, instance);
    }

    private void assignParameter(ComponentRef cref, Object instance) {
        ContainerObjectRef ref;
        ContainerObjectRef containerObjectRef = ref = this.getRef(cref.getDefinition());
        synchronized (containerObjectRef) {
            switch (ref.state) {
                default: {
                    throw new IllegalStateException("Unexpected state " + (Object)((Object)ref.state));
                }
                case NEW: {
                    ref.instance = instance;
                    ref.state = RefState.OKAY;
                    return;
                }
                case OKAY: 
            }
            throw new IocContainerException(this, "Attempt to re-assign the container parameter=" + cref.getDefinition());
        }
    }

    private synchronized void addDestructor(BuildPlan plan, Object inst) {
        if (this.m_destructorList == Collections.EMPTY_LIST) {
            this.m_destructorList = new ArrayList<Destructor>();
        }
        this.m_destructorList.add(new Destructor(plan, inst));
    }

    public Object retrieve(ComponentRef ref) throws Exception {
        return this.m_stack[ref.getContainerIndex()]._retrieve(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _retrieve(ComponentRef cr) throws Exception {
        if (cr.getContainerIndex() != this.m_def.getContainerIndex()) {
            throw new IllegalStateException("Internal: Container index does not correspond with this container's index!?");
        }
        this.handleOneTimeInit(cr.getDefinition());
        if (cr.getDefinition().getScope() == BindingScope.PROTOTYPE) {
            Object inst = this.createObject(cr.getDefinition());
            if (cr.getBuildPlan().hasDestructors()) {
                this.addDestructor(cr.getBuildPlan(), inst);
            }
            return inst;
        }
        ContainerObjectRef ref = this.getRef(cr.getDefinition());
        long ets = 0L;
        block20: while (true) {
            ContainerObjectRef containerObjectRef = ref;
            synchronized (containerObjectRef) {
                switch (ref.state) {
                    default: {
                        throw new IllegalStateException("Internal: unexpected state " + (Object)((Object)ref.state));
                    }
                    case OKAY: {
                        return ref.instance;
                    }
                    case ERROR: {
                        if (ref.exception == null) {
                            throw new IllegalStateException("Missing exception type for object ref in ERROR state");
                        }
                        throw ref.exception;
                    }
                    case NEW: {
                        ref.state = RefState.ALLOCATING;
                        break block20;
                    }
                    case ALLOCATING: {
                        long ts = System.currentTimeMillis();
                        if (ets == 0L) {
                            ets = ts + 60000L;
                        } else if (ts >= ets) {
                            throw new IocContainerException(this, "Another thread took too long to initialize an instance of component=" + cr.getDefinition());
                        }
                        ref.wait(10000L);
                        break;
                    }
                }
            }
        }
        Exception thex = null;
        RefState nstate = RefState.ERROR;
        Object theObject = null;
        try {
            theObject = this.createObject(cr.getDefinition());
            nstate = RefState.OKAY;
            if (cr.getBuildPlan().hasDestructors()) {
                this.addDestructor(cr.getBuildPlan(), theObject);
            }
            Object object = theObject;
            return object;
        }
        catch (Exception x) {
            thex = x;
            nstate = RefState.ERROR;
            throw x;
        }
        finally {
            ContainerObjectRef containerObjectRef = ref;
            synchronized (containerObjectRef) {
                ref.state = nstate;
                ref.instance = theObject;
                ref.exception = thex;
                ref.notify();
            }
        }
    }

    private Object createObject(ComponentDef cd) throws Exception {
        try {
            return cd.getBuildPlan().getObject(this);
        }
        catch (InvocationTargetException itx) {
            if (itx.getCause() instanceof Error) {
                throw (Error)itx.getCause();
            }
            if (itx.getCause() instanceof Exception) {
                throw (Exception)itx.getCause();
            }
            throw itx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOneTimeInit(ComponentDef def) throws Exception {
        StaticComponentRef sr;
        BuildPlan pl = def.getBuildPlan();
        if (!pl.needsStaticInitialization()) {
            return;
        }
        Map<ComponentDef, StaticComponentRef> map = this.m_staticMap;
        synchronized (map) {
            sr = this.m_staticMap.get(def);
            if (sr == null) {
                sr = new StaticComponentRef(def);
                this.m_staticMap.put(def, sr);
            }
        }
        if (sr.mustInitialize(this)) {
            boolean success = false;
            try {
                def.getBuildPlan().staticStart(this);
                success = true;
            }
            finally {
                sr.initCompleted(success);
            }
        }
    }

    private static void dump(ComponentDef cd, BuildPlan pl) {
        StringWriter sw = new StringWriter(8192);
        IndentWriter iw = new IndentWriter((Writer)sw);
        try {
            pl.dump(iw);
            sw.close();
            System.out.println("DUMP: Build plan for component " + cd + ", defined at " + cd.getDefinitionLocation());
            System.out.println(sw.getBuffer().toString());
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public void dump(Class<?> theClass) {
        ComponentRef ref = this.m_def.findComponentReference(theClass);
        if (ref == null) {
            throw new IocContainerException(this, "Can't dump object of type=" + theClass.getName() + ": definition is not found");
        }
        BasicContainer.dump(ref.getDefinition(), ref.getBuildPlan());
    }

    public String toString() {
        return "Container: " + this.getIdent();
    }

    private static final class Destructor {
        private final Object m_instance;
        private final BuildPlan m_plan;

        public Destructor(BuildPlan plan, Object instance) {
            this.m_plan = plan;
            this.m_instance = instance;
        }

        public Object getInstance() {
            return this.m_instance;
        }

        public BuildPlan getPlan() {
            return this.m_plan;
        }
    }

    private static class ContainerObjectRef {
        Object instance;
        Exception exception;
        RefState state = RefState.NEW;

        ContainerObjectRef(ComponentDef cd) {
        }
    }

    private static enum RefState {
        NEW,
        OKAY,
        ALLOCATING,
        ERROR;

    }
}

