/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.container;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import to.etc.iocular.container.BasicContainer;
import to.etc.iocular.def.ComponentRef;
import to.etc.util.IndentWriter;

public final class MethodInvoker {
    private final Method m_method;
    private final ComponentRef[] m_actuals;
    private final ComponentRef m_thisRef;

    public MethodInvoker(Method method, ComponentRef thisref, ComponentRef[] actuals) {
        this.m_method = method;
        this.m_actuals = actuals;
        this.m_thisRef = thisref;
        if (Modifier.isStatic(method.getModifiers())) {
            if (thisref != null) {
                throw new IllegalStateException("Internal: cannot create a method invoker using a 'this' with a static method");
            }
        } else if (thisref == null) {
            throw new IllegalStateException("Internal: cannot create a method invoker without a 'this' with a non-static method");
        }
    }

    public int getScore() {
        return this.m_method.getParameterTypes().length;
    }

    @Deprecated
    public Object invoke(Object thisobject, BasicContainer bc, Object selfobject) throws Exception {
        Object[] param = new Object[this.m_actuals.length];
        int i = this.m_actuals.length;
        while (--i >= 0) {
            if (this.m_actuals[i].isSelf()) {
                param[i] = selfobject;
                continue;
            }
            param[i] = bc.retrieve(this.m_actuals[i]);
        }
        return this.m_method.invoke(thisobject, param);
    }

    public Object invoke(BasicContainer bc, Object selfobject) throws Exception {
        Object thisobject = null;
        if (this.m_thisRef != null) {
            thisobject = this.m_thisRef.isSelf() ? selfobject : bc.retrieve(this.m_thisRef);
        }
        Object[] param = new Object[this.m_actuals.length];
        int i = this.m_actuals.length;
        while (--i >= 0) {
            if (this.m_actuals[i].isSelf()) {
                param[i] = selfobject;
                continue;
            }
            param[i] = bc.retrieve(this.m_actuals[i]);
        }
        return this.m_method.invoke(thisobject, param);
    }

    public void dump(IndentWriter iw) throws IOException {
        iw.print("Method ");
        iw.print(this.m_method.toGenericString());
        iw.print(" (score ");
        iw.print(Integer.toString(this.getScore()));
        iw.println(")");
        if (this.m_actuals.length != 0) {
            iw.println("- Method parameter build plan(s):");
            iw.inc();
            for (int i = 0; i < this.m_actuals.length; ++i) {
                iw.println("argument# " + i);
                iw.inc();
                if (this.m_actuals[i] == null) {
                    iw.println("!?!?!?! null REF!!??!");
                } else {
                    this.m_actuals[i].dump(iw);
                }
                iw.dec();
            }
            iw.dec();
        }
    }
}

