/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.container;

import to.etc.iocular.container.BasicContainer;
import to.etc.iocular.container.IocContainerException;
import to.etc.iocular.def.ComponentDef;

public class StaticComponentRef {
    private boolean m_initialized;
    private boolean m_initializing;
    private ComponentDef m_def;

    public StaticComponentRef(ComponentDef def) {
        this.m_def = def;
    }

    synchronized boolean mustInitialize(BasicContainer c) {
        if (this.m_initialized) {
            return false;
        }
        int tries = 0;
        do {
            if (this.m_initialized) {
                return false;
            }
            if (!this.m_initializing) {
                this.m_initializing = true;
                return true;
            }
            try {
                this.wait(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (tries++ <= 2);
        throw new IocContainerException(c, "Timeout waiting for 'static' initialization of " + this.m_def);
    }

    synchronized void initCompleted(boolean success) {
        if (!this.m_initializing || this.m_initialized) {
            throw new IllegalStateException("!?");
        }
        this.m_initializing = false;
        this.m_initialized = success;
        this.notifyAll();
    }
}

