/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.io.IOException;
import java.util.List;
import to.etc.iocular.container.BasicContainer;
import to.etc.iocular.container.BuildPlan;
import to.etc.iocular.container.MethodInvoker;
import to.etc.iocular.def.PropertyInjector;
import to.etc.util.IndentWriter;

public abstract class AbstractBuildPlan
implements BuildPlan {
    private List<PropertyInjector> m_injectorList;
    private MethodInvoker[] m_startList;
    private MethodInvoker[] m_destroyList;

    @Override
    public abstract Object getObject(BasicContainer var1) throws Exception;

    @Override
    public abstract boolean needsStaticInitialization();

    @Override
    public abstract void staticStart(BasicContainer var1) throws Exception;

    public List<PropertyInjector> getInjectorList() {
        return this.m_injectorList;
    }

    public void setInjectorList(List<PropertyInjector> injectorList) {
        this.m_injectorList = injectorList;
    }

    @Override
    public void dump(IndentWriter iw) throws IOException {
        this.internalDumpSetters(iw);
        this.internalDumpStartStop(iw);
    }

    protected void injectProperties(Object instance, BasicContainer bc) throws Exception {
        for (PropertyInjector pi : this.m_injectorList) {
            Object value = bc.retrieve(pi.getRef());
            pi.getSetter().invoke(instance, value);
        }
    }

    protected void internalDumpSetters(IndentWriter iw) throws IOException {
        if (this.m_injectorList.size() == 0) {
            return;
        }
        iw.println("Property Injectors:");
        iw.inc();
        for (PropertyInjector pij : this.m_injectorList) {
            iw.println("method: " + pij.getSetter().getName() + " refers " + pij.getRef());
        }
    }

    protected void internalDumpStartStop(IndentWriter iw) throws IOException {
        int ix;
        if (this.m_startList == null) {
            iw.println("No START methods defined.");
        } else {
            iw.println("Start method(s):");
            iw.inc();
            ix = 0;
            for (MethodInvoker mi : this.m_startList) {
                iw.print("#" + ix + ": ");
                mi.dump(iw);
                ++ix;
            }
        }
        if (this.m_destroyList == null) {
            iw.println("No DESTROY methods defined.");
        } else {
            iw.println("Destroy method(s):");
            iw.inc();
            ix = 0;
            for (MethodInvoker mi : this.m_destroyList) {
                iw.print("#" + ix + ": ");
                mi.dump(iw);
                ++ix;
            }
        }
    }

    @Override
    public void destroy(BasicContainer bc, Object self) {
        if (this.m_destroyList == null) {
            return;
        }
        for (MethodInvoker m : this.m_destroyList) {
            try {
                m.invoke(bc, self);
            }
            catch (Exception x) {
                System.err.println("Exception while trying to destroy instance=" + self);
                x.printStackTrace();
            }
        }
    }

    public void setDestroyList(MethodInvoker[] destroyList) {
        this.m_destroyList = destroyList;
    }

    public void setStartList(MethodInvoker[] startList) {
        this.m_startList = startList;
    }

    @Override
    public boolean hasDestructors() {
        return this.m_destroyList != null && this.m_destroyList.length > 0;
    }

    @Override
    public void start(BasicContainer bc, Object self) throws Exception {
        if (this.m_startList == null) {
            return;
        }
        for (MethodInvoker m : this.m_startList) {
            m.invoke(bc, self);
        }
    }
}

