/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.iocular.Builder;
import to.etc.iocular.def.ComponentBuilder;
import to.etc.iocular.def.ComponentPropertyDef;
import to.etc.iocular.def.ComponentRef;
import to.etc.iocular.def.ContainerDefinition;
import to.etc.iocular.def.ISelfDef;
import to.etc.iocular.def.IocConfigurationException;
import to.etc.iocular.def.MethodParameterSpec;

public class BasicContainerBuilder
implements Builder {
    private static final Logger LOG = LoggerFactory.getLogger(BasicContainerBuilder.class);
    private ContainerDefinition m_myDefinition;
    private final String m_name;
    private int m_containerIndex;
    private final ContainerDefinition m_parentDefinition;
    private final ContainerDefinition m_baseDefinition;
    private final List<ComponentBuilder> m_builderList = new ArrayList<ComponentBuilder>();
    private final Map<String, ComponentBuilder> m_namedComponentMap = new HashMap<String, ComponentBuilder>();
    private final Map<Class<?>, ComponentBuilder> m_definedTypeMap = new HashMap();
    private final Map<Class<?>, List<ComponentBuilder>> m_availableTypeMap = new HashMap();
    private final Map<Class<?>, List<Class<?>>> m_implementationMap = new HashMap();

    private BasicContainerBuilder(ContainerDefinition parent, ContainerDefinition base, String name) {
        this.m_name = name;
        this.m_parentDefinition = parent;
        this.m_baseDefinition = base;
        while (parent != null) {
            ++this.m_containerIndex;
            parent = parent.getParentDefinition();
        }
    }

    public static BasicContainerBuilder createBuilder(String name) {
        return new BasicContainerBuilder(null, null, name);
    }

    public static BasicContainerBuilder createChildBuilder(ContainerDefinition parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("The 'parent' cannot be null for a child container");
        }
        return new BasicContainerBuilder(parent, null, name);
    }

    public static BasicContainerBuilder createInheritedBuilder(ContainerDefinition base, String name) {
        if (base == null) {
            throw new IllegalArgumentException("The 'parent' cannot be null for an inherited container");
        }
        return new BasicContainerBuilder(null, base, name);
    }

    private void check() {
        if (this.m_myDefinition != null) {
            throw new IllegalStateException("The containerDefinition has already been created from this builder. Create a new builder to create a new definition.");
        }
    }

    void addComponentName(ComponentBuilder cb, String name) {
        this.check();
        ComponentBuilder t = this.m_namedComponentMap.get(name);
        if (t != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Duplicate name '");
            sb.append(name);
            sb.append("' for the object *now* defined at\n");
            sb.append(cb.getDefinitionLocation());
            sb.append("\nThe earlier object was defined at\n");
            sb.append(t.getDefinitionLocation());
            throw new IocConfigurationException(null, sb.toString());
        }
        this.m_namedComponentMap.put(name, cb);
    }

    @Override
    public <T> void bind(Class<T> intf, Class<T> impl) {
        if (!intf.isInterface()) {
            throw new IllegalStateException("The class " + intf + " is not an interface.");
        }
        if (impl.isInterface()) {
            throw new IllegalStateException("The implementation class " + impl + " cannot be an interface");
        }
        int mod = impl.getModifiers();
        if (Modifier.isAbstract(mod)) {
            throw new IllegalStateException("The implementation class " + impl + " cannot be abstract");
        }
        if (!Modifier.isPublic(mod)) {
            throw new IllegalStateException("The implementation class " + impl + " must be public");
        }
        List<Class<?>> list = this.m_implementationMap.get(intf);
        if (list == null) {
            list = new ArrayList();
            this.m_implementationMap.put(intf, list);
        }
        list.add(impl);
    }

    private ComponentBuilder makeBuilder() {
        String loc = null;
        try {
            throw new Exception("duh");
        }
        catch (Exception x) {
            StackTraceElement[] ar = x.getStackTrace();
            loc = ar == null || ar.length < 3 ? "(unknown location)" : ar[2].toString();
            return new ComponentBuilder(this, loc);
        }
    }

    public static String getLocationString(int stackoffset) {
        try {
            throw new Exception("duh");
        }
        catch (Exception x) {
            StackTraceElement[] ar = x.getStackTrace();
            if (ar == null || ar.length <= stackoffset) {
                return "(unknown location)";
            }
            return ar[stackoffset].toString();
        }
    }

    @Override
    public ComponentBuilder register() {
        this.check();
        ComponentBuilder c = this.makeBuilder();
        this.m_builderList.add(c);
        return c;
    }

    public ComponentBuilder registerInstance(Object inst) {
        this.check();
        if (inst == null) {
            throw new IllegalStateException("Instance cannot be null");
        }
        ComponentBuilder c = this.makeBuilder();
        return c;
    }

    public ComponentBuilder registerInstance(String name, Object inst) {
        if (inst == null) {
            throw new IllegalStateException("Instance cannot be null");
        }
        ComponentBuilder c = this.makeBuilder();
        return c;
    }

    private void registerAvailableType(Class<?> clz, ComponentBuilder cb) {
        this.check();
        List<ComponentBuilder> list = this.m_availableTypeMap.get(clz);
        if (list == null) {
            list = new ArrayList<ComponentBuilder>();
            this.m_availableTypeMap.put(clz, list);
        }
        if (!list.contains(cb)) {
            list.add(cb);
        }
    }

    private void registerDefinedType(Class<?> type, ComponentBuilder cb) {
        this.check();
        if (type == Object.class) {
            return;
        }
        ComponentBuilder t = this.m_definedTypeMap.put(type, cb);
        if (t != null) {
            throw new IocConfigurationException(cb, "Duplicate definition of implemented type " + type + "; the other definition was in " + t);
        }
    }

    private void registerBaseClasses(Class<?> clz, ComponentBuilder cb) {
        while ((clz = clz.getSuperclass()) != null && clz != Object.class) {
            this.registerAvailableType(clz, cb);
        }
        return;
    }

    private void registerInterfaces(Class<?> clz, ComponentBuilder cb) {
        Class<?>[] ar;
        for (Class<?> clif : ar = clz.getInterfaces()) {
            this.registerAvailableType(clif, cb);
        }
    }

    Class<?> calcTypeByName(Stack<ComponentBuilder> stack, String name) {
        ComponentBuilder cb = this.m_namedComponentMap.get(name);
        if (cb != null) {
            return cb.calculateType(stack);
        }
        ComponentRef cd = this.m_baseDefinition.findComponentReference(name);
        if (cd != null) {
            return cd.getDefinition().getActualClass();
        }
        cd = this.m_parentDefinition.findComponentReference(name);
        if (cd != null) {
            return cd.getDefinition().getActualClass();
        }
        return null;
    }

    int getContainerIndex() {
        return this.m_containerIndex;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public ContainerDefinition createDefinition() {
        if (this.m_myDefinition != null) {
            return this.m_myDefinition;
        }
        Stack<ComponentBuilder> stack = new Stack<ComponentBuilder>();
        for (ComponentBuilder cb : this.m_builderList) {
            stack.clear();
            cb.calculateType(stack);
        }
        for (ComponentBuilder cb : this.m_builderList) {
            List<Class<?>> defl = cb.getDefinedTypes();
            if (defl.size() > 0) {
                for (Class clazz : defl) {
                    this.registerDefinedType(clazz, cb);
                }
                continue;
            }
            this.registerDefinedType(cb.getActualClass(), cb);
            cb.getDefinedTypes().add(cb.getActualClass());
            this.registerInterfaces(cb.getActualClass(), cb);
            this.registerBaseClasses(cb.getActualClass(), cb);
        }
        HashMap defmap = new HashMap();
        HashMap actmap = new HashMap();
        HashMap<String, ComponentRef> namedmap = new HashMap<String, ComponentRef>();
        for (ComponentBuilder componentBuilder : this.m_builderList) {
            stack.clear();
            ComponentRef ref = componentBuilder.calculateComponentRef(stack);
            for (String string : componentBuilder.getNameList()) {
                namedmap.put(string, ref);
            }
            for (Class clazz : componentBuilder.getDefinedTypes()) {
                defmap.put(clazz, ref);
            }
        }
        for (Class clazz : this.m_availableTypeMap.keySet()) {
            List<ComponentBuilder> list = this.m_availableTypeMap.get(clazz);
            if (list.size() != 1) continue;
            actmap.put(clazz, list.get(0).calculateComponentRef(null));
        }
        this.m_myDefinition = new ContainerDefinition(this.m_name, this.m_baseDefinition, this.m_parentDefinition, namedmap, defmap, actmap, this.m_containerIndex);
        return this.m_myDefinition;
    }

    ComponentRef findReferenceFor(ISelfDef self, Stack<ComponentBuilder> stack, Class<?> ptype, Annotation[] annar, MethodParameterSpec def) {
        ComponentRef ref = this.internalFindReferenceFor(self, stack, ptype, annar, def);
        if (ref == null) {
            return null;
        }
        if (ptype != null && !ptype.isAssignableFrom(ref.getDefinition().getActualClass())) {
            return null;
        }
        return ref;
    }

    ComponentRef internalFindReferenceFor(ISelfDef self, Stack<ComponentBuilder> stack, Class<?> ptype, Annotation[] annar, MethodParameterSpec def) {
        if (def != null && def.isSelf()) {
            if (self == null) {
                throw new IllegalStateException("Internal: self reference requested but 'self' is not known...");
            }
            return new ComponentRef(self);
        }
        ComponentRef ref = this._findDefinedReference(stack, ptype, annar, def);
        if (ref != null) {
            return ref;
        }
        if (this.m_baseDefinition != null && (ref = this.m_baseDefinition.findDefinedReference(ptype, annar, def)) != null) {
            return ref;
        }
        if (this.m_parentDefinition != null && (ref = this.m_parentDefinition.findDefinedReference(ptype, annar, def)) != null) {
            return ref;
        }
        ref = this._findInferredReference(stack, ptype, annar, def);
        if (ref != null) {
            return ref;
        }
        if (this.m_baseDefinition != null && (ref = this.m_baseDefinition.findInferredReference(ptype, annar, def)) != null) {
            return ref;
        }
        if (this.m_parentDefinition != null && (ref = this.m_parentDefinition.findInferredReference(ptype, annar, def)) != null) {
            return ref;
        }
        return null;
    }

    private ComponentRef _findDefinedReference(Stack<ComponentBuilder> stack, Class<?> ptype, Annotation[] annar, MethodParameterSpec def) {
        ComponentBuilder cb = this.m_definedTypeMap.get(ptype);
        if (cb != null) {
            return cb.calculateComponentRef(stack);
        }
        return null;
    }

    private ComponentRef _findInferredReference(Stack<ComponentBuilder> stack, Class<?> ptype, Annotation[] annar, MethodParameterSpec def) {
        List<ComponentBuilder> list = this.m_availableTypeMap.get(ptype);
        if (list == null) {
            return null;
        }
        if (list.size() != 1) {
            LOG.info("Multiple inferred factories for parameter type=" + ptype);
            return null;
        }
        ComponentBuilder cb = list.get(0);
        return cb.calculateComponentRef(stack);
    }

    public ComponentRef findReferenceFor(Stack<ComponentBuilder> stack, ComponentPropertyDef pd) {
        return this.findReferenceFor(null, stack, pd.getInfo().getGetter().getReturnType(), null, null);
    }
}

