/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.io.IOException;
import java.lang.reflect.Constructor;
import to.etc.iocular.container.BasicContainer;
import to.etc.iocular.container.BuildPlan;
import to.etc.iocular.def.AbstractBuildPlan;
import to.etc.iocular.def.ComponentRef;
import to.etc.util.IndentWriter;

public final class BuildPlanForConstructor
extends AbstractBuildPlan {
    private final int m_score;
    private final Constructor<?> m_constructor;
    private final ComponentRef[] m_actuals;

    public BuildPlanForConstructor(Constructor<?> constructor, int score, ComponentRef[] actuals) {
        this.m_constructor = constructor;
        this.m_score = score;
        this.m_actuals = actuals;
    }

    public BuildPlanForConstructor(Constructor<?> constructor, int score) {
        this(constructor, score, BuildPlan.EMPTY_PLANS);
    }

    @Override
    public Object getObject(BasicContainer bc) throws Exception {
        Object[] param = new Object[this.m_actuals.length];
        int i = this.m_actuals.length;
        while (--i >= 0) {
            param[i] = bc.retrieve(this.m_actuals[i]);
        }
        Object inst = this.m_constructor.newInstance(param);
        this.injectProperties(inst, bc);
        return inst;
    }

    public int getScore() {
        return this.m_score;
    }

    @Override
    public void dump(IndentWriter iw) throws IOException {
        iw.print("InstanceConstructor ");
        iw.print(this.m_constructor.toGenericString());
        iw.print(" (score ");
        iw.print(Integer.toString(this.m_score));
        iw.println(")");
        if (this.m_actuals.length != 0) {
            iw.println("- Constructor parameter build plan(s):");
            iw.inc();
            for (int i = 0; i < this.m_actuals.length; ++i) {
                iw.println("constructor parameter# " + i);
                iw.inc();
                if (this.m_actuals[i] == null) {
                    iw.println("!?!?!?! null BuildPlan!!??!");
                } else {
                    this.m_actuals[i].dump(iw);
                }
                iw.dec();
            }
            iw.dec();
        }
        super.dump(iw);
    }

    @Override
    public boolean needsStaticInitialization() {
        return false;
    }

    @Override
    public void staticStart(BasicContainer c) throws Exception {
    }
}

