/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import to.etc.iocular.container.BasicContainer;
import to.etc.iocular.container.MethodInvoker;
import to.etc.iocular.def.AbstractBuildPlan;
import to.etc.iocular.def.ComponentRef;
import to.etc.util.IndentWriter;

public class BuildPlanForStaticFactory
extends AbstractBuildPlan {
    private final Method m_method;
    private final ComponentRef[] m_argumentList;
    private MethodInvoker[] m_startList;
    private final int m_score;

    BuildPlanForStaticFactory(Method m, int score, ComponentRef[] args, List<MethodInvoker> startlist) {
        this.m_method = m;
        this.m_argumentList = args;
        this.m_score = score;
        if (startlist != null && startlist.size() > 0) {
            this.m_startList = startlist.toArray(new MethodInvoker[startlist.size()]);
        }
    }

    public int getScore() {
        return this.m_score;
    }

    @Override
    public Object getObject(BasicContainer bc) throws Exception {
        Object[] param = new Object[this.m_argumentList.length];
        int i = this.m_argumentList.length;
        while (--i >= 0) {
            param[i] = bc.retrieve(this.m_argumentList[i]);
        }
        Object value = this.m_method.invoke(null, param);
        this.injectProperties(value, bc);
        return value;
    }

    @Override
    public void dump(IndentWriter iw) throws IOException {
        iw.print("Staticfactory method ");
        iw.println(this.m_method.toGenericString());
        if (this.m_argumentList.length != 0) {
            iw.println("- Method parameter build plan(s):");
            iw.inc();
            for (int i = 0; i < this.m_argumentList.length; ++i) {
                iw.println("parameter# " + i);
                iw.inc();
                this.m_argumentList[i].dump(iw);
                iw.dec();
            }
            iw.dec();
        }
        super.dump(iw);
    }

    @Override
    public boolean needsStaticInitialization() {
        return this.m_startList != null;
    }

    @Override
    public void staticStart(BasicContainer c) throws Exception {
        for (MethodInvoker miv : this.m_startList) {
            miv.invoke(c, null);
        }
    }
}

