/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import to.etc.iocular.BindingScope;
import to.etc.iocular.container.BuildPlan;
import to.etc.iocular.container.FailedAlternative;
import to.etc.iocular.container.MethodInvoker;
import to.etc.iocular.def.AbstractBuildPlan;
import to.etc.iocular.def.BasicContainerBuilder;
import to.etc.iocular.def.BuildPlanFailedException;
import to.etc.iocular.def.BuildPlanForConstructor;
import to.etc.iocular.def.BuildPlanForContainerParameter;
import to.etc.iocular.def.BuildPlanForStaticFactory;
import to.etc.iocular.def.ComponentDef;
import to.etc.iocular.def.ComponentPropertyDef;
import to.etc.iocular.def.ComponentPropertyMode;
import to.etc.iocular.def.ComponentRef;
import to.etc.iocular.def.CreateMethod;
import to.etc.iocular.def.ISelfDef;
import to.etc.iocular.def.IocCircularException;
import to.etc.iocular.def.IocConfigurationException;
import to.etc.iocular.def.IocUnresolvedParameterException;
import to.etc.iocular.def.MethodCallBuilder;
import to.etc.iocular.def.MethodParameterSpec;
import to.etc.iocular.def.PropertyInjector;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;

public class ComponentBuilder {
    private final BasicContainerBuilder m_builder;
    private final String m_definitionLocation;
    private CreateMethod m_createMethod;
    private final List<String> m_nameList = new ArrayList<String>();
    private final List<Class<?>> m_definedTypeList = new ArrayList();
    private Class<?> m_baseClass;
    private Class<?> m_factoryClass;
    private List<Method> m_factoryMethodList;
    private String m_factoryInstance;
    private String m_factoryMethodText;
    private BindingScope m_scope;
    private String m_creationString;
    private Class<?> m_actualType;
    private MethodCallBuilder m_currentMethodBuilder;
    private final List<MethodCallBuilder> m_factoryStartList = new ArrayList<MethodCallBuilder>();
    private final List<MethodCallBuilder> m_startList = new ArrayList<MethodCallBuilder>();
    private final List<MethodCallBuilder> m_destroyList = new ArrayList<MethodCallBuilder>();
    private ComponentPropertyMode m_propertyMode = ComponentPropertyMode.NONE;
    private final Map<String, ComponentPropertyDef> m_propertyDefMap = new HashMap<String, ComponentPropertyDef>();
    private ComponentRef m_ref;

    ComponentBuilder(BasicContainerBuilder b, String loc) {
        this.m_builder = b;
        this.m_definitionLocation = loc;
    }

    public String getDefinitionLocation() {
        return this.m_definitionLocation;
    }

    public BasicContainerBuilder getBuilder() {
        return this.m_builder;
    }

    MethodCallBuilder getCurrentMethodBuilder() {
        return this.m_currentMethodBuilder;
    }

    private void setCreateMethod(CreateMethod m, String detailed) {
        if (this.m_createMethod != null) {
            throw new IocConfigurationException(this.m_builder, this.getDefinitionLocation(), "Component already created by " + this.m_creationString);
        }
        this.m_createMethod = m;
        this.m_creationString = detailed;
    }

    public ComponentBuilder type(Class<?> clz) {
        this.setCreateMethod(CreateMethod.ASNEW, "Creating a new class instance using <<new>>");
        int mod = clz.getModifiers();
        if (Modifier.isAbstract(mod)) {
            throw new IocConfigurationException(this, this + ": the class " + clz + " is abstract");
        }
        if (!Modifier.isPublic(mod)) {
            throw new IocConfigurationException(this, this + ": the class " + clz + " is not public");
        }
        if (clz.isInterface()) {
            throw new IocConfigurationException(this, this + ": the class " + clz + " is an interface");
        }
        Constructor<?>[] car = clz.getConstructors();
        if (car == null || car.length == 0) {
            throw new IocConfigurationException(this, this + ": the class " + clz + " has no public constructors");
        }
        this.m_actualType = clz;
        this.m_baseClass = clz;
        this.m_definedTypeList.add(clz);
        return this;
    }

    public ComponentBuilder parameter(Class<?> ptype) {
        this.setCreateMethod(CreateMethod.CONTAINER_PARAMETER, "Passed as a parameter by the container's builder");
        this.m_actualType = ptype;
        this.m_definedTypeList.add(ptype);
        return this;
    }

    private BuildPlan createParameterBuildPlan(Stack<ComponentBuilder> stack) {
        return new BuildPlanForContainerParameter(this.m_actualType, this.m_nameList);
    }

    public ComponentBuilder factory(Class<?> clz, String method) {
        this.setCreateMethod(CreateMethod.FACTORY_METHOD, "calling factory method " + method + " on class " + clz);
        this.m_factoryMethodList = this.findMethodInFactory(clz, method, true);
        this.m_factoryClass = clz;
        this.m_actualType = this.m_factoryMethodList.get(0).getReturnType();
        return this;
    }

    private List<Method> findMethodInFactory(Class<?> clz, String method, boolean mbstatic) {
        Method[] mar = to.etc.iocular.util.ClassUtil.findMethod(clz, method);
        if (mar.length == 0) {
            throw new IocConfigurationException(this, "Method " + method + " is not defined in class '" + clz + "'");
        }
        ArrayList<Method> thelist = new ArrayList<Method>();
        Class<?> rtype = null;
        int i = mar.length;
        while (--i >= 0) {
            Class<?> c;
            Method m = mar[i];
            int mod = m.getModifiers();
            if (mbstatic && !Modifier.isStatic(mod) || !Modifier.isPublic(mod) || (c = m.getReturnType()) == Void.TYPE || c.isPrimitive()) continue;
            if (rtype == null) {
                rtype = c;
            } else if (rtype != c) {
                throw new IocConfigurationException(this, "The " + mar.length + " different overloads of the method " + method + " return different types");
            }
            thelist.add(m);
        }
        if (rtype == null) {
            throw new IocConfigurationException(this, "None of the " + mar.length + " versions of the method " + method + " is usable as a" + (mbstatic ? "static " : "") + " public factory method returning an object");
        }
        return thelist;
    }

    public ComponentBuilder factory(String id, String method) {
        this.setCreateMethod(CreateMethod.FACTORY_METHOD, "calling factory method " + method + " on object reference " + id);
        this.m_factoryInstance = id;
        this.m_factoryMethodText = method;
        return this;
    }

    public ComponentBuilder name(String name) {
        this.m_builder.addComponentName(this, name);
        this.m_nameList.add(name);
        return this;
    }

    public ComponentBuilder scope(BindingScope scope) {
        this.m_scope = scope;
        return this;
    }

    public ComponentBuilder destroy(Class<?> wh, String methodName) {
        MethodCallBuilder mcb;
        this.m_currentMethodBuilder = mcb = new MethodCallBuilder(this, wh, methodName);
        mcb.setParameterSelf(0);
        this.m_destroyList.add(mcb);
        return this;
    }

    public ComponentBuilder destroy(String methodName) {
        MethodCallBuilder mcb;
        this.m_currentMethodBuilder = mcb = new MethodCallBuilder(this, this.m_actualType, methodName);
        mcb.setThisIsSelf();
        this.m_destroyList.add(mcb);
        return this;
    }

    public ComponentBuilder implement(Class<?> clz) {
        this.m_definedTypeList.add(clz);
        return this;
    }

    public ComponentBuilder factoryStart(String methodName, Class<?> ... arguments) {
        MethodCallBuilder mcb;
        if (this.m_factoryClass == null) {
            throw new IocConfigurationException(this, "factoryStart() can only be used for static factory classes.");
        }
        this.m_currentMethodBuilder = mcb = new MethodCallBuilder(this, this.m_factoryClass, methodName, arguments, true);
        this.m_factoryStartList.add(mcb);
        return this;
    }

    public ComponentBuilder factoryStart(Class<?> clz, String methodName, Class<?> ... arguments) {
        MethodCallBuilder mcb;
        if (this.m_factoryClass == null) {
            throw new IocConfigurationException(this, "factoryStart() can only be used for static factory classes.");
        }
        this.m_currentMethodBuilder = mcb = new MethodCallBuilder(this, clz, methodName, arguments, true);
        this.m_factoryStartList.add(mcb);
        return this;
    }

    public ComponentBuilder start(String methodName, Class<?> ... arguments) {
        MethodCallBuilder mcb;
        if (this.m_factoryClass == null) {
            throw new IocConfigurationException(this, "factoryStart() can only be used for static factory classes.");
        }
        this.m_currentMethodBuilder = mcb = new MethodCallBuilder(this, this.m_factoryClass, methodName, arguments, false);
        this.m_startList.add(mcb);
        return this;
    }

    public ComponentBuilder setAllProperties() {
        if (this.m_propertyMode != ComponentPropertyMode.NONE) {
            throw new IocConfigurationException(this, "Property configuration mode is already set to " + (Object)((Object)this.m_propertyMode));
        }
        this.m_propertyMode = ComponentPropertyMode.ALL;
        return this;
    }

    public ComponentBuilder setKnownProperties() {
        if (this.m_propertyMode != ComponentPropertyMode.NONE) {
            throw new IocConfigurationException(this, "Property configuration mode is already set to " + (Object)((Object)this.m_propertyMode));
        }
        this.m_propertyMode = ComponentPropertyMode.KNOWN;
        return this;
    }

    private ComponentPropertyDef uniquePropertyDef(String name) {
        ComponentPropertyDef pd = this.m_propertyDefMap.get(name);
        if (pd != null) {
            throw new IocConfigurationException(this, "An initialization for the property '" + name + "' has already been set.");
        }
        pd = new ComponentPropertyDef(this, name);
        this.m_propertyDefMap.put(name, pd);
        return pd;
    }

    public ComponentBuilder setProperties(String ... names) {
        for (String name : names) {
            this.uniquePropertyDef(name).setRequired(true);
        }
        return this;
    }

    public ComponentBuilder setProperty(String name, String componentId) {
        ComponentPropertyDef pd = this.uniquePropertyDef(name);
        pd.setSourceName(componentId);
        pd.setRequired(true);
        return this;
    }

    public ComponentBuilder setProperty(String name, Class<?> componentClass) {
        ComponentPropertyDef pd = this.uniquePropertyDef(name);
        pd.setSourceClass(componentClass);
        pd.setRequired(true);
        return this;
    }

    List<String> getNameList() {
        return this.m_nameList;
    }

    public String getIdent() {
        if (this.m_nameList.size() > 0) {
            return "component(name=" + this.m_nameList.get(0) + ")";
        }
        if (this.m_definedTypeList.size() > 0) {
            return "component(type=" + this.m_definedTypeList.get(0).toString() + ")";
        }
        return "component(Unnamed/untyped)";
    }

    public String toString() {
        if (this.m_nameList.size() > 0) {
            return "component(name=" + this.m_nameList.get(0) + ") defined at " + this.m_definitionLocation;
        }
        if (this.m_definedTypeList.size() > 0) {
            return "component(type=" + this.m_definedTypeList.get(0).toString() + ") defined at " + this.m_definitionLocation;
        }
        return "component(Unnamed/untyped) defined at " + this.m_definitionLocation;
    }

    Class<?> calculateType(Stack<ComponentBuilder> stack) {
        if (this.m_actualType != null) {
            return this.m_actualType;
        }
        if (this.m_factoryInstance != null) {
            if (this.m_factoryMethodText == null) {
                throw new IocConfigurationException(this, "Missing method specification on a 'ref' factory");
            }
            if (stack.contains(this)) {
                throw new IocConfigurationException(this, "Circular reference to " + this);
            }
            stack.push(this);
            Class<?> clz = this.m_builder.calcTypeByName(stack, this.m_factoryInstance);
            if (this != stack.pop()) {
                throw new IllegalStateException("Stack inbalance!?");
            }
            if (clz == null) {
                throw new IocConfigurationException(this, "The component with id='" + this.m_factoryInstance + "' is not known");
            }
            this.m_factoryMethodList = this.findMethodInFactory(clz, this.m_factoryMethodText, false);
            this.m_actualType = this.m_factoryMethodList.get(0).getReturnType();
            return this.m_actualType;
        }
        throw new IocConfigurationException(this, "Can't determine the 'type' of this component: no factory defined.");
    }

    ComponentRef calculateComponentRef(Stack<ComponentBuilder> stack) {
        if (this.m_ref != null) {
            return this.m_ref;
        }
        if (stack.contains(this)) {
            throw new IocCircularException(this, stack, "Circular reference");
        }
        stack.push(this);
        ComponentDef def = new ComponentDef(this.getActualClass(), this.getNameList().toArray(new String[this.getNameList().size()]), this.getDefinedTypes().toArray(new Class[this.getDefinedTypes().size()]), this.getScope(), this.getDefinitionLocation());
        BuildPlan plan = this.createBuildPlan(def, stack);
        if (this != stack.pop()) {
            throw new IllegalStateException("Stack mismatch!?");
        }
        def.setPlan(plan);
        this.m_ref = new ComponentRef(def, this.getBuilder().getContainerIndex());
        return this.m_ref;
    }

    private BuildPlan createBuildPlan(ISelfDef self, Stack<ComponentBuilder> stack) {
        BuildPlan bp = this.createCreationBuildPlan(self, stack);
        if (bp instanceof AbstractBuildPlan) {
            AbstractBuildPlan abp = (AbstractBuildPlan)bp;
            List<PropertyInjector> ijlist = this.calculateSetterInjectors(stack);
            abp.setInjectorList(ijlist);
            if (this.m_destroyList.size() > 0) {
                abp.setDestroyList(this.createCallArray(self, stack, this.m_destroyList));
            }
        } else {
            throw new IllegalStateException("Unexpected build plan");
        }
        return bp;
    }

    private BuildPlan createCreationBuildPlan(ISelfDef self, Stack<ComponentBuilder> stack) {
        switch (this.m_createMethod) {
            default: {
                throw new IocConfigurationException(this, "Internal: unknown CreationMethod " + (Object)((Object)this.m_createMethod));
            }
            case ASNEW: {
                return this.createConstructorPlan(stack);
            }
            case FACTORY_METHOD: {
                return this.createStaticFactoryBuildPlan(self, stack);
            }
            case CONTAINER_PARAMETER: 
        }
        return this.createParameterBuildPlan(stack);
    }

    private BuildPlan createConstructorPlan(Stack<ComponentBuilder> stack) {
        Constructor<?>[] car = this.m_baseClass.getConstructors();
        if (car == null || car.length == 0) {
            throw new IocConfigurationException(this, "The class " + this.m_baseClass + " has no public constructors");
        }
        ArrayList<BuildPlanForConstructor> list = new ArrayList<BuildPlanForConstructor>();
        ArrayList<FailedAlternative> aflist = new ArrayList<FailedAlternative>();
        for (Constructor<?> c : car) {
            if (!Modifier.isPublic(c.getModifiers())) {
                aflist.add(new FailedAlternative("The constructor " + c + " is not public"));
                continue;
            }
            BuildPlanForConstructor cbp = this.calcConstructorPlan(stack, c, aflist);
            if (cbp == null) continue;
            list.add(cbp);
        }
        if (list.size() == 0) {
            throw new BuildPlanFailedException(this, "None of the constructors was usable", aflist);
        }
        BuildPlanForConstructor best = (BuildPlanForConstructor)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            BuildPlanForConstructor bp = (BuildPlanForConstructor)list.get(i);
            if (bp.getScore() <= best.getScore()) continue;
            best = bp;
        }
        return best;
    }

    MethodParameterSpec[] getParameters() {
        return null;
    }

    private BuildPlanForConstructor calcConstructorPlan(Stack<ComponentBuilder> stack, Constructor<?> c, List<FailedAlternative> aflist) {
        Class<?>[] fpar = c.getParameterTypes();
        Annotation[][] fpanar = c.getParameterAnnotations();
        if (fpar == null || fpar.length == 0) {
            return new BuildPlanForConstructor(c, 0);
        }
        try {
            MethodParameterSpec[] paref = this.getParameters();
            List<ComponentRef> actuals = this.calculateParameters(stack, fpar, fpanar, paref);
            return new BuildPlanForConstructor(c, fpar.length, actuals.toArray(new ComponentRef[actuals.size()]));
        }
        catch (IocUnresolvedParameterException x) {
            FailedAlternative fa = new FailedAlternative("The constructor " + c + " is unusable: " + x.getMessage());
            aflist.add(fa);
            return null;
        }
    }

    private List<ComponentRef> calculateParameters(Stack<ComponentBuilder> stack, Class<?>[] fpar, Annotation[][] fpann, MethodParameterSpec[] defar) {
        ArrayList<ComponentRef> actuals = new ArrayList<ComponentRef>();
        for (int i = 0; i < fpar.length; ++i) {
            ComponentRef cr;
            Class<?> fp = fpar[i];
            MethodParameterSpec def = null;
            if (defar != null && i < defar.length) {
                def = defar[i];
            }
            if ((cr = this.m_builder.findReferenceFor(null, stack, fp, fpann[i], def)) == null) {
                throw new IocUnresolvedParameterException("Parameter " + i + " (a " + fp + ") cannot be resolved");
            }
            actuals.add(cr);
        }
        return actuals;
    }

    private BuildPlan createStaticFactoryBuildPlan(ISelfDef self, Stack<ComponentBuilder> stack) {
        List<MethodInvoker> startlist = this.createCallList(self, stack, this.m_factoryStartList);
        ArrayList<BuildPlanForStaticFactory> list = new ArrayList<BuildPlanForStaticFactory>();
        ArrayList<FailedAlternative> aflist = new ArrayList<FailedAlternative>();
        for (Method m : this.m_factoryMethodList) {
            BuildPlanForStaticFactory cbp = this.calcStaticFactoryPlan(stack, m, aflist, startlist);
            if (cbp == null) continue;
            list.add(cbp);
        }
        if (list.size() == 0) {
            throw new BuildPlanFailedException(this, "None of the factory methods was usable", aflist);
        }
        BuildPlanForStaticFactory best = (BuildPlanForStaticFactory)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            BuildPlanForStaticFactory bp = (BuildPlanForStaticFactory)list.get(i);
            if (bp.getScore() <= best.getScore()) continue;
            best = bp;
        }
        return best;
    }

    private BuildPlanForStaticFactory calcStaticFactoryPlan(Stack<ComponentBuilder> stack, Method c, List<FailedAlternative> aflist, List<MethodInvoker> startlist) {
        Class<?>[] fpar = c.getParameterTypes();
        Annotation[][] fpanar = c.getParameterAnnotations();
        if (fpar == null || fpar.length == 0) {
            return new BuildPlanForStaticFactory(c, 0, BuildPlan.EMPTY_PLANS, startlist);
        }
        try {
            MethodParameterSpec[] paref = this.getParameters();
            List<ComponentRef> actuals = this.calculateParameters(stack, fpar, fpanar, paref);
            return new BuildPlanForStaticFactory(c, fpar.length, actuals.toArray(new ComponentRef[actuals.size()]), startlist);
        }
        catch (IocUnresolvedParameterException x) {
            FailedAlternative fa = new FailedAlternative("The static factory method " + c + " is unusable: " + x.getMessage());
            aflist.add(fa);
            return null;
        }
    }

    private List<MethodInvoker> createCallList(ISelfDef self, Stack<ComponentBuilder> stack, List<MethodCallBuilder> list) {
        ArrayList<MethodInvoker> res = new ArrayList<MethodInvoker>(list.size());
        for (MethodCallBuilder mcb : list) {
            res.add(mcb.createInvoker(self, stack));
        }
        return res;
    }

    private MethodInvoker[] createCallArray(ISelfDef self, Stack<ComponentBuilder> stack, List<MethodCallBuilder> source) {
        MethodInvoker[] ar = new MethodInvoker[source.size()];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = source.get(i).createInvoker(self, stack);
        }
        return ar;
    }

    private List<PropertyInjector> calculateSetterInjectors(Stack<ComponentBuilder> stack) {
        if (this.m_propertyMode == ComponentPropertyMode.NONE && this.m_propertyDefMap.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, ComponentPropertyDef> fullmap = new HashMap<String, ComponentPropertyDef>(this.m_propertyDefMap);
        List proplist = ClassUtil.getProperties(this.m_actualType);
        HashSet<String> doneset = new HashSet<String>(this.m_propertyDefMap.keySet());
        for (PropertyInfo pi : proplist) {
            ComponentPropertyDef pd = this.m_propertyDefMap.get(pi.getName());
            if (pd != null) {
                doneset.remove(pi.getName());
                if (pi.getSetter() == null) {
                    throw new IocConfigurationException(this, "The property '" + pi.getName() + "' is defined to be set but it is read-only (it has no applicable setter method)");
                }
            } else if (this.m_propertyMode != ComponentPropertyMode.NONE && pi.getSetter() != null) {
                pd = new ComponentPropertyDef(this, pi.getName());
                pd.setRequired(this.m_propertyMode == ComponentPropertyMode.ALL);
                fullmap.put(pi.getName(), pd);
            }
            if (pd == null) continue;
            pd.setInfo(pi);
        }
        if (doneset.size() > 0) {
            throw new IocConfigurationException(this, "Unknown property/properties '" + doneset + "' on class " + this.m_actualType.getName());
        }
        if (fullmap.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyInjector> res = new ArrayList<PropertyInjector>(fullmap.size());
        for (ComponentPropertyDef pd : fullmap.values()) {
            PropertyInjector pij = this.calculateInjector(stack, pd);
            if (pij == null) {
                if (!pd.isRequired()) continue;
                throw new IocConfigurationException(this, "The property '" + pd.getPropertyName() + "' cannot be injected");
            }
            res.add(pij);
        }
        return res;
    }

    private PropertyInjector calculateInjector(Stack<ComponentBuilder> stack, ComponentPropertyDef pd) {
        ComponentRef cr = this.m_builder.findReferenceFor(stack, pd);
        if (cr == null) {
            return null;
        }
        return new PropertyInjector(cr, pd.getInfo().getSetter());
    }

    Class<?> getActualClass() {
        if (this.m_actualType == null) {
            throw new IllegalStateException("calculateType has not yet been called");
        }
        return this.m_actualType;
    }

    List<Class<?>> getDefinedTypes() {
        return this.m_definedTypeList;
    }

    public BindingScope getScope() {
        return this.m_scope;
    }
}

