/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.io.IOException;
import to.etc.iocular.container.BuildPlan;
import to.etc.iocular.def.ComponentDef;
import to.etc.iocular.def.ISelfDef;
import to.etc.util.IndentWriter;

public final class ComponentRef {
    private final ComponentDef m_def;
    private final int m_containerIndex;

    ComponentRef(ComponentDef def, int containerIndex) {
        this.m_def = def;
        this.m_containerIndex = containerIndex;
    }

    ComponentRef(ISelfDef def) {
        this.m_def = (ComponentDef)def;
        this.m_containerIndex = -1;
    }

    public ComponentDef getDefinition() {
        return this.m_def;
    }

    public boolean isSelf() {
        return this.m_containerIndex < 0;
    }

    public int getContainerIndex() {
        return this.m_containerIndex;
    }

    public void dump(IndentWriter iw) throws IOException {
        if (this.isSelf()) {
            iw.println("REF:self[" + this.m_def.getIdent() + "]");
            return;
        }
        iw.println("REF:container[" + this.m_containerIndex + "] component " + this.m_def.getIdent() + " build plan:");
        iw.inc();
        this.getDefinition().getBuildPlan().dump(iw);
        iw.dec();
    }

    public BuildPlan getBuildPlan() {
        return this.m_def.getBuildPlan();
    }

    public String toString() {
        if (this.isSelf()) {
            return "ref:self[" + this.m_def.getIdent() + "]";
        }
        return "ref:container[" + this.m_containerIndex + "] component " + this.m_def.getIdent();
    }
}

