/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import to.etc.iocular.def.ComponentRef;
import to.etc.iocular.def.MethodParameterSpec;

public final class ContainerDefinition {
    private final String m_name;
    private final ContainerDefinition m_parentContainerDefinition;
    private final int m_containerIndex;
    private Map<String, ComponentRef> m_namedMap = new HashMap<String, ComponentRef>();
    private Map<Class<?>, ComponentRef> m_declaredMap = new HashMap();
    private Map<Class<?>, ComponentRef> m_actualMap = new HashMap();

    public ContainerDefinition(String name, ContainerDefinition base, ContainerDefinition parent, Map<String, ComponentRef> namedMap, Map<Class<?>, ComponentRef> declaredMap, Map<Class<?>, ComponentRef> actualMap, int index) {
        this.m_name = name;
        this.m_parentContainerDefinition = parent;
        this.m_namedMap = namedMap;
        this.m_declaredMap = declaredMap;
        this.m_actualMap = actualMap;
        this.m_containerIndex = index;
    }

    public ContainerDefinition getParentDefinition() {
        return this.m_parentContainerDefinition;
    }

    public String getName() {
        return this.m_name;
    }

    public int getContainerIndex() {
        return this.m_containerIndex;
    }

    public ComponentRef findComponentReference(String name) {
        return this.m_namedMap.get(name);
    }

    public ComponentRef findComponentReference(Class<?> cls) {
        ComponentRef r = this.m_declaredMap.get(cls);
        if (r != null) {
            return r;
        }
        return this.m_actualMap.get(cls);
    }

    ComponentRef findDefinedReference(Class<?> ptype, Annotation[] annar, MethodParameterSpec def) {
        ComponentRef ref = this.m_declaredMap.get(ptype);
        if (ref != null) {
            return ref;
        }
        if (this.m_parentContainerDefinition != null && (ref = this.m_parentContainerDefinition.findDefinedReference(ptype, annar, def)) != null) {
            return ref;
        }
        return null;
    }

    ComponentRef findInferredReference(Class<?> ptype, Annotation[] annar, MethodParameterSpec def) {
        ComponentRef ref = this.m_actualMap.get(ptype);
        if (ref != null) {
            return ref;
        }
        if (this.m_parentContainerDefinition != null && (ref = this.m_parentContainerDefinition.findInferredReference(ptype, annar, def)) != null) {
            return ref;
        }
        return null;
    }
}

