/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.iocular.IocException;
import to.etc.iocular.def.BasicContainerBuilder;
import to.etc.iocular.def.ComponentBuilder;

public class IocConfigurationException
extends IocException {
    private BasicContainerBuilder m_builder;
    private ComponentBuilder m_cb;
    private String m_location;

    public IocConfigurationException(@Nullable ComponentBuilder b, @Nonnull String message) {
        super(message);
        this.m_cb = b;
        if (b != null) {
            this.m_builder = b.getBuilder();
            this.m_location = b.getDefinitionLocation();
        }
    }

    public IocConfigurationException(@Nullable BasicContainerBuilder b, @Nullable String location, @Nonnull String message) {
        super(message);
        this.m_builder = b;
        this.m_location = location;
    }

    public IocConfigurationException(@Nullable BasicContainerBuilder b, @Nullable String location, @Nonnull Throwable cause) {
        super(cause);
        this.m_builder = b;
        this.m_location = location;
    }

    public IocConfigurationException(@Nullable BasicContainerBuilder b, @Nullable String location, @Nonnull String message, @Nonnull Throwable cause) {
        super(message, cause);
        this.m_builder = b;
        this.m_location = location;
    }

    @Override
    public String getMessage() {
        BasicContainerBuilder builder;
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        ComponentBuilder cb = this.m_cb;
        if (cb != null) {
            sb.append("\n- The object being built is: ");
            sb.append(cb.getIdent());
        }
        if ((builder = this.m_builder) != null) {
            sb.append("\n- for the container with the name '");
            sb.append(builder.getName());
            sb.append("'");
        }
        if (this.m_location != null) {
            sb.append("\n- Defined at ");
            sb.append(this.m_location);
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public String getLocationText() {
        return this.m_location;
    }
}

