/*
 * Decompiled with CFR 0.152.
 */
package to.etc.iocular.def;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import to.etc.iocular.container.FailedAlternative;
import to.etc.iocular.container.MethodInvoker;
import to.etc.iocular.def.BuildPlanFailedException;
import to.etc.iocular.def.ComponentBuilder;
import to.etc.iocular.def.ComponentRef;
import to.etc.iocular.def.ISelfDef;
import to.etc.iocular.def.IocConfigurationException;
import to.etc.iocular.def.MethodParameterSpec;
import to.etc.iocular.util.ClassUtil;

public class MethodCallBuilder {
    private final ComponentBuilder m_component;
    private final Class<?> m_baseClass;
    private final String m_methodName;
    private ParamMode m_paramMode = ParamMode.UNKNOWN;
    private boolean m_thisIsSelf;
    private final List<MethodParameterSpec> m_actuals = new ArrayList<MethodParameterSpec>();
    private boolean m_staticOnly;

    public MethodCallBuilder(ComponentBuilder component, Class<?> baseClass, String methodName, Class<?>[] actuals, boolean staticOnly) {
        this.m_component = component;
        this.m_baseClass = baseClass;
        this.m_methodName = methodName;
        this.m_staticOnly = staticOnly;
        if (actuals != null) {
            for (Class<?> ac : actuals) {
                this.setParameter(ac);
            }
        }
    }

    public MethodCallBuilder(ComponentBuilder component, Class<?> baseClass, String methodName) {
        this.m_component = component;
        this.m_baseClass = baseClass;
        this.m_methodName = methodName;
    }

    public void setStaticOnly(boolean staticOnly) {
        this.m_staticOnly = staticOnly;
    }

    private MethodParameterSpec makeNumberedParam(int ix) {
        switch (this.m_paramMode) {
            default: {
                throw new IllegalStateException("Unexpected parameter mode " + (Object)((Object)this.m_paramMode));
            }
            case UNKNOWN: {
                this.m_paramMode = ParamMode.NUMBERED;
                break;
            }
            case NUMBERED: {
                break;
            }
            case UNNUMBERED: {
                throw new IocConfigurationException(this.m_component, "You cannot mix NUMBERED and UNNUMBERED parameters.");
            }
        }
        for (MethodParameterSpec msp : this.m_actuals) {
            if (msp.getParameterNumber() != ix) continue;
            throw new IocConfigurationException(this.m_component, "Numbered parameter " + ix + " is already defined.");
        }
        MethodParameterSpec msp = new MethodParameterSpec();
        this.m_actuals.add(msp);
        msp.setParameterNumber(ix);
        return msp;
    }

    private MethodParameterSpec makeUnnumberedParam() {
        switch (this.m_paramMode) {
            default: {
                throw new IllegalStateException("Unexpected parameter mode " + (Object)((Object)this.m_paramMode));
            }
            case UNKNOWN: {
                this.m_paramMode = ParamMode.UNNUMBERED;
                break;
            }
            case UNNUMBERED: {
                break;
            }
            case NUMBERED: {
                throw new IocConfigurationException(this.m_component, "You cannot mix NUMBERED and UNNUMBERED parameters.");
            }
        }
        MethodParameterSpec msp = new MethodParameterSpec();
        msp.setParameterNumber(this.m_actuals.size());
        this.m_actuals.add(msp);
        return msp;
    }

    public void setParameter(int index, Class<?> type) {
        MethodParameterSpec msp = this.makeNumberedParam(index);
        msp.setSourceType(type);
    }

    public void setParameter(int index, String name) {
        MethodParameterSpec msp = this.makeNumberedParam(index);
        msp.setSourceName(name);
    }

    public void setParameterSelf(int index) {
        MethodParameterSpec msp = this.makeNumberedParam(index);
        msp.setSelf(true);
    }

    public void setParameter(Class<?> type) {
        MethodParameterSpec msp = this.makeUnnumberedParam();
        msp.setSourceType(type);
    }

    public void setParameter(String name) {
        MethodParameterSpec msp = this.makeUnnumberedParam();
        msp.setSourceName(name);
    }

    public void setParameterSelf() {
        MethodParameterSpec msp = this.makeUnnumberedParam();
        msp.setSelf(true);
    }

    public MethodInvoker createInvoker(ISelfDef self, Stack<ComponentBuilder> stack) {
        List<Method> mlist = this.getAcceptableMethods();
        if (mlist.size() == 0) {
            throw new IocConfigurationException(this.m_component, "Cannot find an acceptable method '" + this.m_methodName + " on " + this.m_baseClass);
        }
        ArrayList<FailedAlternative> aflist = new ArrayList<FailedAlternative>();
        MethodInvoker best = null;
        for (Method m : mlist) {
            MethodInvoker miv = this.tryToMakeAnInvokerIfYouWouldBeSoKind(self, stack, m, aflist);
            if (miv == null || best != null && best.getScore() >= miv.getScore()) continue;
            best = miv;
        }
        if (best == null) {
            throw new BuildPlanFailedException(this.m_component, "Can't call any of the available methods", aflist);
        }
        return best;
    }

    private MethodInvoker tryToMakeAnInvokerIfYouWouldBeSoKind(ISelfDef self, Stack<ComponentBuilder> stack, Method m, List<FailedAlternative> aflist) {
        Class<?>[] fpar = m.getParameterTypes();
        Annotation[][] pannar = m.getParameterAnnotations();
        ComponentRef[] refar = new ComponentRef[fpar.length];
        if (this.m_paramMode == ParamMode.NUMBERED || this.m_paramMode == ParamMode.UNKNOWN) {
            if (this.m_actuals.size() != fpar.length) {
                return null;
            }
            for (int i = 0; i < fpar.length; ++i) {
                MethodParameterSpec msp = this.m_actuals.get(i);
                if (msp == null) {
                    return null;
                }
                Class<?> fp = fpar[i];
                ComponentRef cr = this.m_component.getBuilder().findReferenceFor(self, stack, fp, pannar[i], msp);
                if (cr == null) {
                    aflist.add(new FailedAlternative(m + ": Parameter[" + i + "] (a " + fp + ") cannot be provided using the definition " + msp));
                    return null;
                }
                refar[i] = cr;
            }
            if (Modifier.isStatic(m.getModifiers())) {
                return new MethodInvoker(m, null, refar);
            }
            if (this.m_thisIsSelf) {
                return new MethodInvoker(m, new ComponentRef(self), refar);
            }
        }
        throw new IllegalStateException("Not implemented yet");
    }

    private List<Method> getAcceptableMethods() {
        Method[] mar;
        ArrayList<Method> res = new ArrayList<Method>();
        for (Method m : mar = ClassUtil.findMethod(this.m_baseClass, this.m_methodName)) {
            int mod = m.getModifiers();
            if (this.m_staticOnly && !Modifier.isStatic(mod) || !Modifier.isPublic(mod) || !this.matchFormals(m)) continue;
            res.add(m);
        }
        return res;
    }

    private boolean matchFormals(Method m) {
        if (this.m_actuals.size() == 0) {
            return true;
        }
        Class<?>[] par = m.getParameterTypes();
        if (this.m_paramMode == ParamMode.NUMBERED && par.length != this.m_actuals.size()) {
            return false;
        }
        return this.m_actuals.size() <= par.length;
    }

    public void setThisIsSelf() {
        this.m_thisIsSelf = true;
    }

    private static enum ParamMode {
        UNKNOWN,
        NUMBERED,
        UNNUMBERED;

    }
}

